/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public abstract class BufferedCanvas
extends Canvas {
    Image fImgBuf;
    boolean fBufOK = false;
    int fOffWid;
    int fOffHgt;

    public void createBuffer(int n, int n2) {
        this.fImgBuf = n <= 0 || n2 <= 0 ? null : this.createImage(n, n2);
        this.fBufOK = false;
    }

    public void invalidateBuffer() {
        this.fBufOK = false;
    }

    public void translate(int n, int n2) {
        this.fOffWid = n;
        this.fOffHgt = n2;
        this.repaint();
    }

    public void zeroTranslate() {
        if (this.fOffWid != 0 || this.fOffHgt != 0) {
            this.fOffWid = 0;
            this.fOffHgt = 0;
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Object object;
        this.adjustBuffer();
        if (!this.fBufOK && this.fImgBuf != null) {
            object = this.fImgBuf.getGraphics();
            this.fBufOK = this.paintBuffer((Graphics)object);
        }
        if (this.fImgBuf == null) {
            object = graphics.getClipRect();
            graphics.setColor(Color.red);
            graphics.fillRect(0, 0, ((Rectangle)object).width, ((Rectangle)object).height);
            return;
        }
        graphics.translate(-this.fOffWid, -this.fOffHgt);
        graphics.drawImage(this.fImgBuf, 0, 0, null);
    }

    private void adjustBuffer() {
        Dimension dimension = this.size();
        if (this.fImgBuf == null || dimension.width != this.fImgBuf.getWidth(null) || dimension.height != this.fImgBuf.getHeight(null)) {
            this.createBuffer(dimension.width, dimension.height);
        }
    }

    public Image getBuffer() {
        return this.fImgBuf;
    }

    public abstract boolean paintBuffer(Graphics var1);

    public abstract void sizeBuffer();

    public static void version() {
        System.out.println("BufferedCanvas 0.0");
    }
}

