/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class PaletteMgr {
    int fNumRed;
    int fNumGrn;
    int fNumBlu;
    int fNumClr;
    byte[] fRedLst;
    byte[] fGrnLst;
    byte[] fBluLst;
    IndexColorModel fIdxClrMdl;

    public void makePalette(int n) {
        int n2 = (int)Math.pow(2.0, n);
        int n3 = (int)Math.pow(n2, 0.3333333432674408);
        int n4 = n3 * n3 * (n3 + 1) + 1;
        int n5 = n3 * (n3 + 1) * (n3 + 1) + 1;
        this.fNumRed = n3;
        this.fNumGrn = n3;
        this.fNumBlu = n3;
        if (n4 <= n2) {
            ++this.fNumRed;
        }
        if (n5 <= n2) {
            ++this.fNumGrn;
        }
        if (this.fNumRed * this.fNumGrn * this.fNumBlu + 1 > n2) {
            --this.fNumBlu;
        }
        this.fNumClr = this.fNumRed * this.fNumGrn * this.fNumBlu + 1;
        int n6 = (int)(Math.log(this.fNumClr) / Math.log(2.0) + 0.999999);
        this.fRedLst = new byte[n2];
        this.fGrnLst = new byte[n2];
        this.fBluLst = new byte[n2];
        byte[] byArray = new byte[n2];
        int n7 = 1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n7 < this.fNumClr && n8 < this.fNumRed) {
            n9 = 0;
            while (n7 < this.fNumClr && n9 < this.fNumGrn) {
                n10 = 0;
                while (n7 < this.fNumClr && n10 < this.fNumBlu) {
                    byArray[n7] = -1;
                    this.fRedLst[n7] = n8 == this.fNumRed - 1 ? -1 : (byte)(n8 * (256 / (this.fNumRed - 1)));
                    this.fGrnLst[n7] = n9 == this.fNumGrn - 1 ? -1 : (byte)(n9 * (256 / (this.fNumGrn - 1)));
                    this.fBluLst[n7] = n10 == this.fNumBlu - 1 ? -1 : (byte)(n10 * (256 / (this.fNumBlu - 1)));
                    ++n7;
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
        this.fIdxClrMdl = new IndexColorModel(n6, this.fNumClr, this.fRedLst, this.fGrnLst, this.fBluLst, byArray);
    }

    public Image convertToIndexed(Image image) {
        if (image == null) {
            return null;
        }
        if (this.fIdxClrMdl == null) {
            return image;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = n * n2;
        int[] nArray = new int[n3];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error indexing image ");
            return null;
        }
        if ((pixelGrabber.status() & 0x40) != 0) {
            System.out.println("Error indexing image");
            return null;
        }
        return this.convertToIndexed(nArray, n, n2);
    }

    public Image convertToIndexed(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return null;
        }
        if (this.fIdxClrMdl == null) {
            return null;
        }
        int n3 = nArray.length;
        float f = 256 / this.fNumRed;
        float f2 = 256 / this.fNumGrn;
        float f3 = 256 / this.fNumBlu;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n4];
            int n6 = n5 >> 24 & 0xFF;
            int n7 = n5 >> 16 & 0xFF;
            int n8 = n5 >> 8 & 0xFF;
            int n9 = n5 & 0xFF;
            if (n6 != 0) {
                int n10;
                int n11;
                int n12 = (int)((float)n7 / f);
                if (n12 > this.fNumRed - 1) {
                    n12 = this.fNumRed - 1;
                }
                if ((n11 = (int)((float)n8 / f2)) > this.fNumGrn - 1) {
                    n11 = this.fNumGrn - 1;
                }
                if ((n10 = (int)((float)n9 / f3)) > this.fNumBlu - 1) {
                    n10 = this.fNumBlu - 1;
                }
                byArray[n4] = (byte)(n12 * (this.fNumGrn * this.fNumBlu) + n11 * this.fNumBlu + n10 + 1);
            } else {
                byArray[n4] = 0;
            }
            ++n4;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, (ColorModel)this.fIdxClrMdl, byArray, 0, n));
        return image;
    }

    public void removePalette() {
        this.fIdxClrMdl = null;
    }

    public Image createImage(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        int[] nArray = new int[n * n2];
        if (this.fIdxClrMdl == null) {
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, (ColorModel)this.fIdxClrMdl, nArray, 0, n));
    }

    public static void version() {
        System.out.println("PaletteMgr 0.0");
    }
}

