/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Random;
import java.util.StringTokenizer;

public class TileAnimator
extends Thread {
    static final int kMaxObj = 10;
    static final int kSlpTim = 10;
    static final int kNone = 0;
    static final int kDissolve = 1;
    static final int kFade = 2;
    static final int kWaver = 3;
    static final int kGlow = 4;
    static final int kTwinkle = 5;
    static final int kSwirl = 1;
    static final int kFly = 2;
    static final int kCoast = 3;
    static final int kWander = 4;
    static final int kMaxStp = 10;
    static final int kCntBon = -99999;
    TileMatch fTilApp;
    Image fSavBuf;
    Graphics fSavGrf;
    int fSavWid;
    int fSavHgt;
    boolean fAniGo = false;
    int fMaxEff = 10;
    int fMaxStp = 10;
    int fEffPrmOne = 5;
    int fEffPrmTwo = 10;
    float fEffPrmThr = 0.5f;
    int fSlpTim = 10;
    Random fRnd = new Random();
    int fNumObj;
    int fNxtObjID;
    int[] fObjID = new int[10];
    Image[] fObjBasImg = new Image[10];
    Image[] fObjTilImg = new Image[10];
    Image[] fObjCurImg = new Image[10];
    Image[] fObjNewImg = new Image[10];
    Color[] fObjClr = new Color[10];
    double[] fObjXAcc = new double[10];
    double[] fObjYAcc = new double[10];
    int[] fObjAccMod = new int[10];
    double[] fObjAccDir = new double[10];
    double[] fObjAccRat = new double[10];
    double[] fObjXVel = new double[10];
    double[] fObjYVel = new double[10];
    double[] fObjX = new double[10];
    double[] fObjY = new double[10];
    int[] fObjWid = new int[10];
    int[] fObjHgt = new int[10];
    int[] fObjBdr = new int[10];
    int[] fObjTrm = new int[10];
    int[] fObjTrnMod = new int[10];
    Color[] fObjTrnClr = new Color[10];
    int[] fObjTrnStp = new int[10];
    int[][] fObjPixArr = new int[10][];
    boolean[] fObjNewRdy = new boolean[10];
    boolean[] fObjTilRdy = new boolean[10];
    boolean fRun = false;
    Image fBonImg;
    int fBonX = -99999;
    int fBonY = -99999;
    int fBonWid;
    int fBonHgt;
    Image fTrnTil;
    String fCpt;
    Color fCptClr;
    Color fCptBckClr;
    int fCptLft = -1;
    int fCptTop = -1;
    int fCptSiz = 18;
    String fCptFnt;

    public TileAnimator(TileMatch tileMatch) {
        this.fTilApp = tileMatch;
        this.fMaxStp = tileMatch.getEffectSteps();
        this.fEffPrmOne = tileMatch.getEffectParmOne();
        this.fEffPrmTwo = tileMatch.getEffectParmTwo();
        this.fEffPrmThr = tileMatch.getEffectParmThree();
        this.fSlpTim = tileMatch.getEffectLapse();
        this.fMaxEff = tileMatch.getSimulEffect();
        this.fCptClr = tileMatch.getCaptionColor();
        this.fCptBckClr = tileMatch.getCaptionBackColor();
        this.fCptTop = tileMatch.getCaptionTop();
        this.fCptLft = tileMatch.getCaptionLeft();
        this.fCptFnt = tileMatch.getCaptionFont();
        this.fCptSiz = tileMatch.getCaptionSize();
        this.start();
    }

    public void destroy() {
        this.destroyImages();
        this.fTilApp = null;
        this.fSavGrf = null;
    }

    public void destroyImages() {
        if (this.fBonImg != null) {
            this.fBonImg.flush();
        }
        this.fBonImg = null;
        int n = 0;
        while (n < this.fNumObj) {
            if (this.fObjCurImg[n] != null) {
                this.fObjCurImg[n].flush();
            }
            this.fObjCurImg[n] = null;
            ++n;
        }
        if (this.fSavBuf != null) {
            this.fSavBuf.flush();
        }
        this.fSavBuf = null;
    }

    public void updateSaveBuffer(Graphics graphics) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            this.fSavBuf = this.fTilApp.getTileCanvas().useAnimation() ? this.fTilApp.getTileCanvas().copyBuffer(graphics, this.fSavBuf) : null;
            return;
        }
    }

    public void addEffectObject(Image image, int n, int n2, int n3, int n4, Color color, String string) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fNumObj < 10) {
                this.fObjID[this.fNumObj] = ++this.fNxtObjID;
                this.fObjBasImg[this.fNumObj] = image;
                this.fObjTilImg[this.fNumObj] = null;
                this.fObjCurImg[this.fNumObj] = null;
                this.fObjNewImg[this.fNumObj] = null;
                this.fObjAccDir[this.fNumObj] = 0.0;
                this.fObjAccRat[this.fNumObj] = 0.0;
                this.fObjXAcc[this.fNumObj] = 0.0;
                this.fObjYAcc[this.fNumObj] = 0.0;
                this.fObjXVel[this.fNumObj] = 0.0;
                this.fObjYVel[this.fNumObj] = 0.0;
                this.fObjX[this.fNumObj] = n;
                this.fObjY[this.fNumObj] = n2;
                this.fObjWid[this.fNumObj] = n3;
                this.fObjHgt[this.fNumObj] = n4;
                this.fObjClr[this.fNumObj] = color;
                this.fObjBdr[this.fNumObj] = -1;
                this.fObjTrm[this.fNumObj] = -1;
                this.fObjAccMod[this.fNumObj] = 0;
                this.fObjTrnMod[this.fNumObj] = 0;
                this.fObjNewRdy[this.fNumObj] = true;
                this.fObjTrnStp[this.fNumObj] = 0;
                this.fObjPixArr[this.fNumObj] = null;
                double d = this.fRnd.nextDouble() * 2.0 * 3.14159265358979;
                double d2 = this.fRnd.nextDouble() * (double)(this.fEffPrmTwo - this.fEffPrmOne) + (double)this.fEffPrmOne;
                if (d2 == 0.0) {
                    d2 = this.fEffPrmTwo;
                }
                new TileImageMaker(this.fTilApp, this.fObjID[this.fNumObj]);
                String string2 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.equalsIgnoreCase("Fly")) {
                        this.fObjAccMod[this.fNumObj] = 2;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Swirl")) {
                        this.fObjAccMod[this.fNumObj] = 1;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Wander")) {
                        this.fObjAccMod[this.fNumObj] = 4;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Coast")) {
                        this.fObjAccMod[this.fNumObj] = 3;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Right")) {
                        d = 0.0;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Down")) {
                        d = 1.570796326794895;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Left")) {
                        d = 3.14159265358979;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Up")) {
                        d = 4.712388980384685;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Fade")) {
                        this.fObjTrnMod[this.fNumObj] = 2;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Glow")) {
                        this.fObjTrnMod[this.fNumObj] = 4;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Dissolve")) {
                        this.fObjTrnMod[this.fNumObj] = 1;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Waver")) {
                        this.fObjTrnMod[this.fNumObj] = 3;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Twinkle")) {
                        this.fObjTrnMod[this.fNumObj] = 5;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Any") || string3.equalsIgnoreCase("Random")) {
                        this.fObjTrnMod[this.fNumObj] = Math.abs(this.fRnd.nextInt()) % 5 + 1;
                        continue;
                    }
                    string2 = String.valueOf(string2) + string3 + " ";
                }
                this.fObjTrnClr[this.fNumObj] = ColorPicker.getColor(string2);
                if (this.fObjAccMod[this.fNumObj] == 2) {
                    this.fObjAccDir[this.fNumObj] = d;
                    this.fObjAccRat[this.fNumObj] = d2;
                    this.fObjXAcc[this.fNumObj] = d2 * Math.cos(d);
                    this.fObjYAcc[this.fNumObj] = d2 * Math.sin(d);
                } else if (this.fObjAccMod[this.fNumObj] == 3) {
                    this.fObjXVel[this.fNumObj] = d2 * Math.cos(d);
                    this.fObjYVel[this.fNumObj] = d2 * Math.sin(d);
                } else if (this.fObjAccMod[this.fNumObj] == 1) {
                    this.fObjAccDir[this.fNumObj] = d;
                    this.fObjAccRat[this.fNumObj] = d2;
                    this.fObjXAcc[this.fNumObj] = d2 * Math.cos(d);
                    this.fObjYAcc[this.fNumObj] = d2 * Math.sin(d);
                } else if (this.fObjAccMod[this.fNumObj] == 4) {
                    this.fObjAccDir[this.fNumObj] = d;
                    this.fObjAccRat[this.fNumObj] = d2;
                    this.fObjXAcc[this.fNumObj] = d2 * Math.cos(d);
                    this.fObjYAcc[this.fNumObj] = d2 * Math.sin(d);
                }
                if (this.fObjTrnMod[this.fNumObj] == 0 && this.fObjAccMod[this.fNumObj] == 0) {
                    Object var9_14 = null;
                    return;
                }
                ++this.fNumObj;
                this.setAnimationGo();
            }
            return;
        }
    }

    public void restoreBuffer(Graphics graphics) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            graphics.drawImage(this.fSavBuf, 0, 0, null);
            return;
        }
    }

    public void drawAnimated(Graphics graphics) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            this.fTilApp.getTileCanvas().drawForeground(graphics);
            int n = 0;
            while (n < this.fNumObj) {
                this.drawEffectObject(graphics, n);
                ++n;
            }
            this.drawBonusImage(graphics);
            return;
        }
    }

    public void drawEffectObject(Graphics graphics, int n) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fObjCurImg[n] != null) {
                graphics.drawImage(this.fObjCurImg[n], (int)this.fObjX[n], (int)this.fObjY[n], null);
            } else {
                this.fTilApp.getTileCanvas().drawTile(graphics, this.fObjBasImg[n], (int)this.fObjX[n], (int)this.fObjY[n], this.fObjWid[n], this.fObjHgt[n], this.fObjBdr[n], this.fObjTrm[n], this.fObjClr[n], false);
            }
            this.fObjNewImg[n] = null;
            return;
        }
    }

    public void drawBonusImage(Graphics graphics) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fBonImg != null) {
                int n = this.fBonImg.getWidth(null) + this.fTilApp.getTileCanvas().getFrameAdd();
                int n2 = this.fBonImg.getHeight(null) + this.fTilApp.getTileCanvas().getFrameAdd();
                if (n <= 0) {
                    n = this.fBonWid;
                }
                if (n2 <= 0) {
                    n2 = this.fBonHgt;
                }
                int n3 = 0;
                int n4 = 0;
                if (this.fBonX == -99999 || this.fBonY == -99999) {
                    n3 = (this.fSavBuf.getWidth(null) - n) / 2;
                    n4 = (this.fSavBuf.getHeight(null) - n2) / 2;
                } else {
                    int n5 = this.fSavBuf.getWidth(null);
                    int n6 = this.fSavBuf.getHeight(null);
                    n3 = this.fBonX - n / 2;
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (n3 + n > n5) {
                        n3 = n5 - n;
                    }
                    if ((n4 = this.fBonY - n2 / 2) < 0) {
                        n4 = 0;
                    }
                    if (n4 + n2 > n6) {
                        n4 = n6 - n2;
                    }
                }
                if (this.fCpt != null) {
                    this.drawCaption(graphics, n3, n4);
                }
                this.fTilApp.getTileCanvas().drawTile(graphics, this.fBonImg, n3, n4, n, n2, -2, 0, Color.black, false);
            }
            return;
        }
    }

    public void drawCaption(Graphics graphics, int n, int n2) {
        if (this.fCpt == null || this.fCptSiz == 0 || this.fCptClr == null || this.fCpt.length() == 0) {
            return;
        }
        Dimension dimension = this.getCaptionSize(graphics);
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = this.fCptLft;
        int n6 = this.fCptTop;
        if (n6 < 0) {
            n6 = n2 + n6 - n4;
        }
        if (n5 < 0) {
            n5 = (this.fSavBuf.getWidth(null) - n3) / 2;
        }
        if (this.fCptBckClr != null) {
            this.fTilApp.getTileCanvas().drawTile(graphics, null, n5 - 5, n6 - 5, n3 + 10, n4 + 10, -2, 0, this.fCptBckClr, false);
        }
        graphics.setColor(this.fCptClr);
        graphics.drawString(this.fCpt, n5, n6 + n4);
    }

    public Dimension getCaptionSize(Graphics graphics) {
        Font font = new Font(this.fTilApp.getCaptionFont(), 0, this.fTilApp.getCaptionSize());
        if (font != null) {
            graphics.setFont(font);
        }
        int n = 200;
        int n2 = 20;
        if (font != null) {
            FontMetrics fontMetrics = this.fTilApp.getTileCanvas().getFontMetrics(font);
            n = fontMetrics.stringWidth(this.fCpt);
            n2 = fontMetrics.getHeight();
        }
        return new Dimension(n, n2);
    }

    public void moveAnimated() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n = 0;
            while (n < this.fNumObj) {
                if (this.fObjX[n] < (double)(-(2 * this.fObjWid[n])) || this.fObjX[n] > (double)(this.fSavBuf.getWidth(null) + this.fObjWid[n]) || this.fObjY[n] < (double)(-(2 * this.fObjHgt[n])) || this.fObjY[n] > (double)(this.fSavBuf.getHeight(null) + this.fObjHgt[n])) {
                    n = this.removeEffectObject(n);
                } else {
                    this.fObjX[n] = this.fObjX[n] + this.fObjXVel[n];
                    this.fObjY[n] = this.fObjY[n] + this.fObjYVel[n];
                    this.fObjXVel[n] = this.fObjXVel[n] + this.fObjXAcc[n];
                    this.fObjYVel[n] = this.fObjYVel[n] + this.fObjYAcc[n];
                    this.modifyAcceleration(n);
                }
                ++n;
            }
            return;
        }
    }

    public void modifyAcceleration(int n) {
        if (this.fObjAccMod[n] == 4) {
            if ((double)this.fEffPrmThr > 1.0) {
                float f = 1.0f / this.fEffPrmThr;
            } else {
                float f = this.fEffPrmThr;
            }
            if (this.fRnd.nextFloat() < this.fEffPrmThr) {
                double d = this.fRnd.nextDouble() * 2.0 * 3.14159265358979;
                double d2 = this.fRnd.nextDouble() * (double)(this.fEffPrmTwo - this.fEffPrmOne) + (double)this.fEffPrmOne;
                if (d2 == 0.0) {
                    d2 = this.fEffPrmTwo;
                }
                this.fObjAccDir[n] = d;
                this.fObjAccRat[n] = d2;
                this.fObjXAcc[n] = d2 * Math.cos(d);
                this.fObjYAcc[n] = d2 * Math.sin(d);
                return;
            }
        } else if (this.fObjAccMod[n] == 1) {
            double d;
            double d3 = this.fObjAccRat[n];
            double d4 = Math.atan2(this.fObjYVel[n], this.fObjXVel[n]);
            double d5 = (double)this.fEffPrmThr * 3.14159265358979;
            this.fObjAccDir[n] = d = d4 + d5;
            this.fObjAccRat[n] = d3;
            this.fObjXAcc[n] = d3 * Math.cos(d);
            this.fObjYAcc[n] = d3 * Math.sin(d);
        }
    }

    public void effectAnimated() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fTilApp.getTileCanvas().getUpdateDone()) {
                int n = 0;
                int n2 = 0;
                while (n2 < this.fNumObj) {
                    if (this.fObjNewRdy[n2] && this.fObjNewImg[n2] == null && this.fObjTrnMod[n2] != 0 && n < this.fMaxEff) {
                        int n3 = this.fObjTrnStp[n2];
                        if (n3 < this.fMaxStp) {
                            ++n;
                            this.fObjNewRdy[n2] = false;
                            new TileImageEffector(this.fTilApp, this.fObjID[n2]);
                            int n4 = n2;
                            this.fObjTrnStp[n4] = this.fObjTrnStp[n4] + 1;
                        } else {
                            n2 = this.removeEffectObject(n2);
                        }
                    }
                    ++n2;
                }
                this.fTilApp.getTileCanvas().setUpdateDone(false);
            }
            return;
        }
    }

    public int removeEffectObject(int n) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (n + 1 < this.fNumObj) {
                this.fObjPixArr[n] = null;
                this.fObjID[n] = this.fObjID[this.fNumObj - 1];
                this.fObjX[n] = this.fObjX[this.fNumObj - 1];
                this.fObjY[n] = this.fObjY[this.fNumObj - 1];
                this.fObjAccDir[n] = this.fObjAccDir[this.fNumObj - 1];
                this.fObjAccRat[n] = this.fObjAccRat[this.fNumObj - 1];
                this.fObjXVel[n] = this.fObjXVel[this.fNumObj - 1];
                this.fObjYVel[n] = this.fObjYVel[this.fNumObj - 1];
                this.fObjXAcc[n] = this.fObjXAcc[this.fNumObj - 1];
                this.fObjYAcc[n] = this.fObjYAcc[this.fNumObj - 1];
                this.fObjAccMod[n] = this.fObjAccMod[this.fNumObj - 1];
                this.fObjWid[n] = this.fObjWid[this.fNumObj - 1];
                this.fObjHgt[n] = this.fObjHgt[this.fNumObj - 1];
                this.fObjBasImg[n] = this.fObjBasImg[this.fNumObj - 1];
                this.fObjClr[n] = this.fObjClr[this.fNumObj - 1];
                this.fObjBdr[n] = this.fObjBdr[this.fNumObj - 1];
                this.fObjTrm[n] = this.fObjTrm[this.fNumObj - 1];
                this.fObjNewRdy[n] = this.fObjNewRdy[this.fNumObj - 1];
                this.fObjTrnStp[n] = this.fObjTrnStp[this.fNumObj - 1];
                this.fObjTrnMod[n] = this.fObjTrnMod[this.fNumObj - 1];
                this.fObjTrnClr[n] = this.fObjTrnClr[this.fNumObj - 1];
                this.fObjTilImg[n] = this.fObjTilImg[this.fNumObj - 1];
                this.fObjCurImg[n] = this.fObjCurImg[this.fNumObj - 1];
                this.fObjNewImg[n] = this.fObjNewImg[this.fNumObj - 1];
                this.fObjTilRdy[n] = this.fObjTilRdy[this.fNumObj - 1];
                this.fObjPixArr[n] = this.fObjPixArr[this.fNumObj - 1];
            }
            --this.fNumObj;
            int n2 = n - 1;
            Object var4_4 = null;
            return n2;
        }
    }

    public void setAnimationGo() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            this.fAniGo = this.fNumObj != 0;
            return;
        }
    }

    public void addBonus(Image image, int n, String string) {
        this.addBonus(image, n, -99999, -99999, 0, 0, string);
    }

    public void addBonus(Image image, int n) {
        this.addBonus(image, n, -99999, -99999, 0, 0, null);
    }

    public void addBonus(Image image, int n, int n2, int n3, int n4, int n5) {
        this.addBonus(image, n, n2, n3, n4, n5, null);
    }

    public void addBonus(Image image, int n, int n2, int n3, int n4, int n5, String string) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fBonImg != image) {
                if (this.fBonImg != null) {
                    this.removeBonus();
                }
                this.fCpt = string;
                this.fBonX = n2;
                this.fBonY = n3;
                this.fBonWid = n4;
                this.fBonHgt = n5;
                this.fBonImg = image;
                this.redraw();
            }
            return;
        }
    }

    public boolean removeBonus() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fBonImg != null) {
                this.fBonImg.flush();
            }
            this.fBonImg = null;
            this.fCpt = null;
            this.redraw();
            boolean bl = false;
            Object var3_3 = null;
            return bl;
        }
    }

    public void clearAnimation() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fBonImg != null) {
                this.fBonImg.flush();
            }
            this.fBonImg = null;
            this.fNumObj = 0;
            return;
        }
    }

    public void redraw() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            Graphics graphics;
            Image image = this.fTilApp.getTileCanvas().getBuffer();
            if (image != null && (graphics = image.getGraphics()) != null) {
                this.restoreBuffer(graphics);
                this.drawAnimated(graphics);
                this.fTilApp.getTileCanvas().repaint();
            }
            return;
        }
    }

    public void run() {
        while (true) {
            if (this.fAniGo && this.fSavBuf != null) {
                TileMatch tileMatch = this.fTilApp;
                synchronized (tileMatch) {
                    this.redraw();
                    this.setAnimationGo();
                    this.moveAnimated();
                    this.effectAnimated();
                }
            }
            try {
                Thread.sleep(this.fSlpTim);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public int getObjectIndex(int n) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n2 = 0;
            while (n2 < this.fNumObj) {
                if (this.fObjID[n2] == n) {
                    int n3 = n2;
                    Object var4_6 = null;
                    return n3;
                }
                ++n2;
            }
            int n4 = -1;
            Object var4_7 = null;
            return n4;
        }
    }

    public void setNewImage(int n, Image image) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n2 = this.getObjectIndex(n);
            if (n2 > -1) {
                this.fObjNewImg[n2] = image;
                if (image != null) {
                    this.fObjCurImg[n2] = image;
                }
                this.fObjNewRdy[n2] = true;
            }
            return;
        }
    }

    public void setTileImage(int n, Image image) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n2 = this.getObjectIndex(n);
            if (n2 > -1) {
                this.fObjTilImg[n2] = image;
                if (this.fObjTilImg[n2] != null) {
                    this.fObjPixArr[n2] = null;
                    this.fObjCurImg[n2] = image;
                    int n3 = n2;
                    this.fObjX[n3] = this.fObjX[n3] - (double)this.fTilApp.getTileCanvas().getBorderWidth();
                }
            }
            return;
        }
    }

    public void setPixelArray(int n, int[] nArray) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n2 = this.getObjectIndex(n);
            if (n2 > -1) {
                this.fObjPixArr[n2] = nArray;
            }
            return;
        }
    }

    public Image getBaseImage(int n) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n2 = this.getObjectIndex(n);
            if (n2 > -1) {
                Image image = this.fObjBasImg[n2];
                Object var4_6 = null;
                return image;
            }
            Image image = null;
            Object var4_7 = null;
            return image;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image getTileImage(int n) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n2 = this.getObjectIndex(n);
            if (n2 <= -1) return null;
            if (this.fObjTilImg[n2] == null) return this.fObjBasImg[n2];
            return this.fObjTilImg[n2];
        }
    }

    public int getObjectEffect(int n) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n2 = this.getObjectIndex(n);
            if (n2 > -1) {
                int n3 = this.fObjTrnMod[n2];
                Object var4_6 = null;
                return n3;
            }
            int n4 = 0;
            Object var4_7 = null;
            return n4;
        }
    }

    public int getEffectStep(int n) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n2 = this.getObjectIndex(n);
            if (n2 > -1) {
                int n3 = this.fObjTrnStp[n2];
                Object var4_6 = null;
                return n3;
            }
            int n4 = this.fMaxStp;
            Object var4_7 = null;
            return n4;
        }
    }

    public Color getEffectColor(int n) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n2 = this.getObjectIndex(n);
            if (n2 > -1) {
                Color color = this.fObjTrnClr[n2];
                Object var4_6 = null;
                return color;
            }
            Color color = Color.white;
            Object var4_7 = null;
            return color;
        }
    }

    public int[] getPixelArray(int n) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n2 = this.getObjectIndex(n);
            if (n2 > -1) {
                int[] nArray = this.fObjPixArr[n2];
                Object var4_6 = null;
                return nArray;
            }
            int[] nArray = null;
            Object var4_7 = null;
            return nArray;
        }
    }

    public int getMaxStep() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n = this.fMaxStp;
            Object var3_3 = null;
            return n;
        }
    }

    public int getEffectParmOne() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n = this.fEffPrmOne;
            Object var3_3 = null;
            return n;
        }
    }

    public int getEffectParmTwo() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            int n = this.fEffPrmTwo;
            Object var3_3 = null;
            return n;
        }
    }

    public static void version() {
        System.out.println("TileAnimator 0.0e");
    }
}

