/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.util.Random;
import java.util.StringTokenizer;

public class TileGame {
    static int kNumRow = 8;
    static int kNumCol = 15;
    static int kNumLvl = 5;
    static int kLftOff;
    static int kRgtOff;
    static int kLvlOff;
    static int kTotTil;
    static int kNumTil;
    static int kNumRnk;
    static boolean kLftRgt;
    TileMatch fTilApp;
    TileMatchBuffer fTilCvs;
    int[][] fTilLvl = new int[kNumCol][kNumRow];
    boolean[][][] fTilHiLit = new boolean[kNumCol][kNumRow][kNumLvl];
    int fBasSet;
    int fGamLvl = 4;
    int[][][] fTilSet = new int[kNumCol][kNumRow][kNumLvl];
    int[][][] fTilRnk = new int[kNumCol][kNumRow][kNumLvl];
    int[][][] fTilXOff = new int[kNumCol][kNumRow][kNumLvl];
    int[][][] fTilYOff = new int[kNumCol][kNumRow][kNumLvl];
    boolean[][][] fTilIs = new boolean[kNumCol][kNumRow][kNumLvl];
    boolean[][][] fTilBeg = new boolean[kNumCol][kNumRow][kNumLvl];
    int[][] fTilTop = new int[kNumCol][kNumRow];
    int[] fMovCol = new int[kTotTil];
    int[] fMovRow = new int[kTotTil];
    int[] fMovLvl = new int[kTotTil];
    int[] fSetMch = new int[kNumTil];
    boolean[] fMovMrk = new boolean[kTotTil];
    int fMovNum;
    int fMovTop;
    boolean fLodGam = true;
    int fNumRow = kNumRow;
    int fNumCol = kNumCol;
    int fNumLvl = kNumLvl;
    int fNumTil = kNumTil;
    int fNumRnk = kNumRnk;
    int fTotTil = kTotTil;
    int fLftOff = kLftOff;
    int fRgtOff = kRgtOff;
    int fLvlOff = kLvlOff;
    boolean fLftRgt = kLftRgt;
    boolean fGamRdy = false;
    boolean fGamBeg = false;
    boolean fAutPly = false;
    int fSelCol = -1;
    int fSelRow = -1;
    int fSelLvl = -1;
    int fCluLvl;
    int fCluCrd;
    int fNumHiLit;
    int fBrdLayOutNum = -1;
    String fBrdLayOut = "Standard";
    int[] fWinColOne;
    int[] fWinRowOne;
    int[] fWinLvlOne;
    int[] fWinColTwo;
    int[] fWinRowTwo;
    int[] fWinLvlTwo;
    int fWinTop;
    int fWinCur;

    public TileGame(TileMatch tileMatch, TileMatchBuffer tileMatchBuffer) {
        this.fTilApp = tileMatch;
        this.fTilCvs = tileMatchBuffer;
        this.initialize();
    }

    public TileGame(TileMatch tileMatch) {
        this.fTilApp = tileMatch;
        this.initialize();
    }

    public void initialize() {
        this.fGamLvl = this.fTilApp.getInitLevel();
        this.fBasSet = this.fTilApp.getInitSet();
    }

    public void setBuffer(TileMatchBuffer tileMatchBuffer) {
        this.fTilCvs = tileMatchBuffer;
        this.fTilCvs.loadImages();
    }

    public void setRow(int n, int n2, int n3, int n4) {
        if (n > this.fNumRow || n2 > this.fNumLvl || n4 > this.fNumCol || n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n3 > n4) {
            this.fTilApp.ohNo("Invalid parameter to setRow");
        }
        int n5 = n3;
        while (n5 <= n4) {
            if (this.fTilLvl[n5][n] < n2) {
                this.fTilLvl[n5][n] = n2;
                this.setXOffset(n5, n, n2 - 1);
                this.setYOffset(n5, n, n2 - 1);
            }
            ++n5;
        }
    }

    public void setXOffset(int n, int n2, int n3) {
        if (this.onBoard(n, n2, n3)) {
            if (n3 >= this.fLvlOff) {
                this.fTilXOff[n][n2][n3] = 1;
                return;
            }
            this.fTilXOff[n][n2][n3] = 0;
        }
    }

    public void setYOffset(int n, int n2, int n3) {
        if (this.onBoard(n, n2, n3)) {
            if (n <= this.fLftOff) {
                this.fTilYOff[n][n2][n3] = 1;
                return;
            }
            if (n >= this.fRgtOff || n3 >= this.fLvlOff) {
                this.fTilYOff[n][n2][n3] = 1;
                return;
            }
            this.fTilYOff[n][n2][n3] = 0;
        }
    }

    public void setTile(int n, int n2, int n3, char c) {
        this.fTilBeg[n][n2][n3] = true;
        if (n3 + 1 > this.fTilLvl[n][n2]) {
            this.fTilLvl[n][n2] = n3 + 1;
        }
        switch (c) {
            case 'd': {
                this.fTilXOff[n][n2][n3] = 0;
                this.fTilYOff[n][n2][n3] = 1;
                return;
            }
            case 'r': {
                this.fTilXOff[n][n2][n3] = 1;
                this.fTilYOff[n][n2][n3] = 0;
                return;
            }
            case 'f': {
                this.fTilXOff[n][n2][n3] = 1;
                this.fTilYOff[n][n2][n3] = 1;
                return;
            }
        }
        this.fTilXOff[n][n2][n3] = 0;
        this.fTilYOff[n][n2][n3] = 0;
    }

    public void setRow(String string) {
        int n;
        int n2;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " |");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            try {
                n2 = Integer.parseInt(string2) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                this.fTilApp.ohNo(String.valueOf(this.fBrdLayOut) + ": Non-numeric row number " + string2);
                return;
            }
            if (n2 < 0 || n2 >= this.fNumRow) {
                this.fTilApp.ohNo(String.valueOf(this.fBrdLayOut) + ": Row number " + string2 + " off of board");
                return;
            }
        } else {
            return;
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            try {
                n = Integer.parseInt(string2) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                this.fTilApp.ohNo(String.valueOf(this.fBrdLayOut) + ": Non-numeric base level number " + string2);
                return;
            }
            if (n < 0 || n >= this.fNumLvl) {
                this.fTilApp.ohNo(String.valueOf(this.fBrdLayOut) + ": Base number " + string2 + " off of board");
                return;
            }
        } else {
            return;
        }
        int n3 = 0;
        while (n3 < this.fNumCol && stringTokenizer.hasMoreTokens()) {
            int n4;
            string2 = stringTokenizer.nextToken();
            if (string2.length() < 2) {
                this.fTilApp.ohNo(String.valueOf(this.fBrdLayOut) + ": Invalid tile specification" + string2 + " at " + Integer.toString(n3 + 1) + ", " + Integer.toString(n2 + 1));
                return;
            }
            try {
                n4 = Integer.parseInt(string2.substring(0, string2.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                this.fTilApp.ohNo(String.valueOf(this.fBrdLayOut) + ": Non-numeric tile count " + string2 + " at " + Integer.toString(n3 + 1) + ", " + Integer.toString(n2 + 1));
                return;
            }
            char c = string2.charAt(string2.length() - 1);
            if (n + n4 > this.fNumLvl) {
                this.fTilApp.ohNo(String.valueOf(this.fBrdLayOut) + ": Too many tiles to add (" + string2 + ") at " + Integer.toString(n3 + 1) + ", " + Integer.toString(n2 + 1));
                return;
            }
            int n5 = n;
            while (n5 < n + n4) {
                this.setTile(n3, n2, n5, c);
                ++n5;
            }
            ++n3;
        }
    }

    public String getLoc(int n, int n2, int n3) {
        return "Column " + Integer.toString(n + 1) + ", " + "Row " + Integer.toString(n2 + 1) + ", " + "Level " + Integer.toString(n3 + 1);
    }

    public void checkLayout() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fNumCol) {
            int n3 = 0;
            while (n3 < this.fNumRow) {
                int n4 = 0;
                while (n4 < this.fNumLvl) {
                    if (this.fTilBeg[n2][n3][n4]) {
                        ++n;
                        if (this.fTilXOff[n2][n3][n4] > 0) {
                            if (n2 + 1 < this.fNumCol && this.fTilBeg[n2 + 1][n3][n4] && this.fTilXOff[n2 + 1][n3][n4] == 0) {
                                this.fTilApp.ohNo("Offset tile at " + this.getLoc(n2, n3, n4) + " overlaps tile to right.");
                            }
                            if (n2 + 1 < this.fNumCol && n3 - 1 >= 0 && this.fTilBeg[n2 + 1][n3 - 1][n4] && this.fTilXOff[n2 + 1][n3 - 1][n4] == 0 && this.fTilYOff[n2 + 1][n3 - 1][n4] > 0 && this.fTilYOff[n2][n3][n4] == 0) {
                                this.fTilApp.ohNo("Offset tile at " + this.getLoc(n2, n3, n4) + " overlaps tile to above right.");
                            }
                        }
                        if (this.fTilYOff[n2][n3][n4] > 0) {
                            if (n3 + 1 < this.fNumRow && this.fTilBeg[n2][n3 + 1][n4] && this.fTilYOff[n2][n3 + 1][n4] == 0) {
                                this.fTilApp.ohNo("Offset tile at " + this.getLoc(n2, n3, n4) + " overlaps tile below.");
                            }
                            if (n2 + 1 < this.fNumCol && n3 + 1 < this.fNumRow && this.fTilBeg[n2 + 1][n3 + 1][n4] && this.fTilXOff[n2 + 1][n3 + 1][n4] == 0 && this.fTilYOff[n2 + 1][n3 + 1][n4] == 0 && this.fTilXOff[n2][n3][n4] > 0) {
                                this.fTilApp.ohNo("Offset tile at " + this.getLoc(n2, n3, n4) + " overlaps tile to above right.");
                            }
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        if (n != this.fTotTil) {
            this.fTilApp.ohNo(String.valueOf(Integer.toString(n)) + " tiles in layout , " + Integer.toString(this.fTotTil) + " tiles in set.");
        }
    }

    public void standardLayout() {
        this.fNumRow = kNumRow;
        this.fNumCol = kNumCol;
        this.fNumLvl = kNumLvl;
        this.prepareLayout();
        this.setRow("1  1  0x|1x|1x|1x|1x|1x|1x|1x|1x|1x|1x|1x|1x|0x|0x");
        this.setRow("2  1  0x|0x|0x|1x|2x|2x|2x|2x|2x|2x|1x|0x|0x|0x|0x");
        this.setRow("3  1  0x|0x|1x|1x|2x|3x|3x|3x|3x|2x|1x|1x|0x|0x|0x");
        this.setRow("4  1  1d|1x|1x|1x|2x|3x|4x|4x|3x|2x|1x|1x|1x|1d|1d");
        this.setRow("4  5  0x|0x|0x|0x|0x|0x|1f|0x|0x|0x|0x|0x|0x|0x|0x");
        this.setRow("5  1  0x|1x|1x|1x|2x|3x|4x|4x|3x|2x|1x|1x|1x|0x|0x");
        this.setRow("6  1  0x|0x|1x|1x|2x|3x|3x|3x|3x|2x|1x|1x|0x|0x|0x");
        this.setRow("7  1  0x|0x|0x|1x|2x|2x|2x|2x|2x|2x|1x|0x|0x|0x|0x");
        this.setRow("8  1  0x|1x|1x|1x|1x|1x|1x|1x|1x|1x|1x|1x|1x|0x|0x");
    }

    public void bridgeLayout() {
        this.fNumRow = kNumRow;
        this.fNumCol = kNumCol;
        this.fNumLvl = kNumLvl;
        this.prepareLayout();
        this.setRow("1  1  4x|2x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|2x|4x");
        this.setRow("2  1  4x|2x|2x|0x|0x|0x|0x|0x|0x|0x|0x|0x|2x|2x|4x");
        this.setRow("3  1  4x|3x|2x|1x|0x|0x|0x|0x|0x|0x|0x|1x|2x|3x|4x");
        this.setRow("4  1  2x|2x|2x|2x|1x|2d|2d|2d|2d|2d|1x|2x|2x|2x|2x");
        this.setRow("4  2  0x|0x|0x|0x|1d|0x|0x|0x|0x|0x|1d|0x|0x|0x|0x");
        this.setRow("5  1  2x|2x|2x|2x|1x|0x|0x|0x|0x|0x|1x|2x|2x|2x|2x");
        this.setRow("6  1  4x|3x|2x|1x|0x|0x|0x|0x|0x|0x|0x|1x|2x|3x|4x");
        this.setRow("7  1  4x|2x|2x|0x|0x|0x|0x|0x|0x|0x|0x|0x|2x|2x|4x");
        this.setRow("8  1  4x|2x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|2x|4x");
    }

    public void towersLayout() {
        this.fNumRow = kNumRow;
        this.fNumCol = kNumCol;
        this.fNumLvl = kNumLvl;
        this.prepareLayout();
        this.setRow("1  1  0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x");
        this.setRow("2  1  4d|4x|4x|4d|0x|0x|0x|0x|0x|0x|4d|4x|4x|4d");
        this.setRow("3  1  4d|0x|0x|4d|0x|0x|0x|0x|0x|0x|4d|0x|0x|4d");
        this.setRow("4  1  0x|2x|4x|0x|0x|0x|0x|0x|0x|0x|0x|2x|4x|0x");
        this.setRow("4  4  0x|1x|0x|0x|0x|0x|0x|0x|0x|0x|0x|1x|0x|0x");
        this.setRow("4  4  0x|0x|1x|0x|0x|0x|0x|0x|0x|0x|0x|0x|1x|0x");
        this.setRow("5  2  0x|1x|0x|0x|0x|0x|0x|0x|0x|0x|0x|1x|0x|0x");
        this.setRow("6  1  4d|4x|4x|4d|0x|0x|0x|0x|0x|0x|4d|4x|4x|4d");
        this.setRow("7  1  4d|0x|0x|4d|0x|0x|0x|0x|0x|0x|4d|0x|0x|4d");
        this.setRow("8  1  0x|2x|4x|0x|0x|0x|0x|0x|0x|0x|0x|2x|4x|0x");
        this.setRow("8  4  0x|1x|0x|0x|0x|0x|0x|0x|0x|0x|0x|1x|0x|0x");
        this.setRow("3  3  0x|0x|0x|0x|1x|1x|1x|1x|1x|1x|0x|0x|0x|0x");
        this.setRow("4  3  0x|0x|0x|0x|0x|1x|0x|0x|1x|0x|0x|0x|0x|0x");
        this.setRow("5  3  0x|0x|0x|0x|0x|1x|0x|0x|1x|0x|0x|0x|0x|0x");
        this.setRow("6  3  0x|0x|0x|0x|0x|1x|0x|0x|1x|0x|0x|0x|0x|0x");
        this.setRow("7  3  0x|0x|0x|0x|1x|1x|1x|1x|1x|1x|0x|0x|0x|0x");
    }

    public void childLayout() {
        this.fNumRow = kNumRow;
        this.fNumCol = kNumCol;
        this.fNumLvl = kNumLvl;
        this.prepareLayout();
        this.setRow("1  1  0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x");
        this.setRow("2  1  0x|3x|3x|0x|0x|0x|0x|5x|5x|0x|0x|0x|0x|5x|0x");
        this.setRow("3  1  0x|3x|3x|0x|3x|3x|0x|4x|4x|0x|3x|3x|0x|0x|0x");
        this.setRow("4  1  0x|0x|0x|0x|4x|4x|0x|3x|3x|0x|3x|3x|0x|4d|4d");
        this.setRow("5  1  4x|4x|0x|0x|4d|4d|0x|2x|2x|0x|3x|3x|0x|4d|4d");
        this.setRow("6  1  4x|4x|0x|0x|3d|3d|0x|1x|1x|0x|3x|3x|0x|0x|0x");
        this.setRow("7  1  4x|4x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x");
        this.setRow("8  1  0x|0x|0x|0x|0x|0x|0x|0x|0x|5x|0x|0x|0x|0x|0x");
    }

    public void roomLayout() {
        this.fNumRow = kNumRow;
        this.fNumCol = kNumCol;
        this.fNumLvl = 7;
        this.prepareLayout();
        this.setRow("1  1  0x|0x|3d|3d|3d|3d|1d|1d|3d|3d|3d|3d|0x|0x");
        this.setRow("2  1  0x|0x|3d|1d|1d|1d|1d|1d|1d|1d|1d|3d|0x|0x");
        this.setRow("3  1  0x|0x|3d|1d|2d|1d|2d|2d|1d|2d|1d|3d|0x|0x");
        this.setRow("4  1  0x|0x|1d|1d|2d|1d|2d|2d|1d|2d|1d|1d|0x|0x");
        this.setRow("5  1  0x|0x|3d|1d|2d|1d|2d|2d|1d|2d|1d|3d|0x|0x");
        this.setRow("6  1  0x|0x|3d|1d|1d|1d|1d|1d|1d|1d|1d|3d|0x|0x");
        this.setRow("7  1  0x|0x|3d|3d|3d|3d|1d|1d|3d|3d|3d|3d|0x|0x");
        this.setRow("1  4  0x|0x|0x|0x|0x|1f|0x|1f|0x|0x|0x|0x|0x|0x");
        this.setRow("1  5  0x|0x|0x|0x|0x|0x|1d|1d|0x|0x|0x|0x|0x|0x");
        this.setRow("4  4  0x|0x|1x|0x|0x|0x|0x|0x|0x|0x|0x|1x|0x|0x");
        this.setRow("5  4  0x|0x|1x|0x|0x|0x|0x|0x|0x|0x|0x|1x|0x|0x");
        this.setRow("4  5  0x|0x|1d|0x|0x|0x|0x|0x|0x|0x|0x|1d|0x|0x");
        this.setRow("7  4  0x|0x|0x|0x|0x|1f|0x|1f|0x|0x|0x|0x|0x|0x");
        this.setRow("7  5  0x|0x|0x|0x|0x|0x|1d|1d|0x|0x|0x|0x|0x|0x");
    }

    public void castleLayout() {
        this.fNumRow = kNumRow;
        this.fNumCol = kNumCol;
        this.fNumLvl = 7;
        this.prepareLayout();
        this.setRow("1  1  0x|0x|0x|2d|2d|2d|2d|2d|2d|2d|2d|0x|0x|0x");
        this.setRow("2  1  0x|0x|2x|1d|1d|1d|1d|1d|1d|1d|1d|2x|0x|0x");
        this.setRow("3  1  0x|0x|2x|1d|1d|2d|1d|1d|2d|1d|1d|2x|0x|0x");
        this.setRow("4  1  0x|0x|2x|1d|1d|2d|1d|1d|2d|1d|1d|2x|0x|0x");
        this.setRow("5  1  0x|0x|2x|1d|1d|2d|1d|1d|2d|1d|1d|2x|0x|0x");
        this.setRow("6  1  0x|0x|0x|0x|1d|1d|1d|1d|1d|1d|0x|0x|0x|0x");
        this.setRow("7  1  0x|0x|0x|0x|2d|2d|0d|0x|2d|2d|0x|0x|0x|0x");
        this.setRow("6  1  3d|3x|3x|3d|0x|0x|0x|0x|0x|0x|3d|3x|3x|3d");
        this.setRow("7  1  3d|0x|0x|3d|0x|0x|0x|0x|0x|0x|3d|0x|0x|3d");
        this.setRow("8  1  0x|3x|3x|0x|0x|0x|0x|0x|0x|0x|0x|3x|3x|0x");
        this.setRow("7  3  0x|0x|0x|0x|0x|1f|0x|1f|0x|0x|0x|0x|0x|0x");
        this.setRow("7  4  0x|0x|0x|0x|0x|0x|1d|1d|0x|0x|0x|0x|0x|0x");
        this.setRow("1  3  0x|0x|0x|1f|0x|1f|0x|1f|0x|1f|0x|0x|0x|0x");
        this.setRow("2  3  0x|0x|1x|0x|0x|0x|0x|0x|0x|0x|0x|1x|0x|0x");
        this.setRow("4  3  0x|0x|1x|0x|0x|0x|0x|0x|0x|0x|0x|1x|0x|0x");
    }

    public void oldCastleLayout() {
        this.fNumRow = kNumRow;
        this.fNumCol = kNumCol;
        this.fNumLvl = 7;
        this.prepareLayout();
        this.setRow("2  1  0x|0x|0x|5x|5x|3x|5x|5x|3x|5x|5x|0x|0x|0x|0x");
        this.setRow("2  5  0x|0x|0x|0x|0x|1x|0x|0x|1x|0x|0x|0x|0x|0x|0x");
        this.setRow("2  6  0x|0x|0x|0x|1r|0x|1r|0x|1r|0x|0x|0x|0x|0x|0x");
        this.setRow("3  1  0x|0x|0x|5x|1x|1x|1x|1x|1x|1x|5x|0x|0x|0x|0x");
        this.setRow("3  6  0x|0x|0x|1d|0x|0x|0x|0x|0x|0x|1d|0x|0x|0x|0x");
        this.setRow("4  1  0x|0x|0x|1x|1x|1x|1x|1x|1x|1x|5x|0x|0x|0x|0x");
        this.setRow("4  5  0x|0x|0x|1x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x");
        this.setRow("5  1  0x|0x|0x|1x|1x|1x|1x|1x|1x|1x|5x|0x|0x|0x|0x");
        this.setRow("5  5  0x|0x|0x|1x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x");
        this.setRow("5  6  0x|0x|0x|1d|0x|0x|0x|0x|0x|0x|1d|0x|0x|0x|0x");
        this.setRow("6  1  0x|0x|0x|5x|1x|1x|1x|1x|1x|1x|5x|0x|0x|0x|0x");
        this.setRow("7  1  0x|0x|0x|5x|5x|3x|5x|5x|3x|5x|5x|0x|0x|0x|0x");
        this.setRow("7  5  0x|0x|0x|0x|0x|1x|0x|0x|1x|0x|0x|0x|0x|0x|0x");
        this.setRow("7  6  0x|0x|0x|0x|1r|0x|1r|0x|1r|0x|0x|0x|0x|0x|0x");
    }

    public void standardtaipeiLayout() {
        this.fNumRow = 7;
        this.fNumCol = 11;
        this.fNumLvl = 7;
        this.fNumTil = 36;
        this.fNumRnk = 4;
        this.fTotTil = this.fNumTil * this.fNumRnk;
        this.prepareLayout();
        this.setRow("1  1  1f|1f|0x|1x|1x|1x|1x|1x|1f|1f|0x");
        this.setRow("1  2  0x|0x|0x|1r|1f|1f|1r|0x|0x|0x|0x");
        this.setRow("2  1  1f|1f|1r|1r|1r|1r|1r|1r|1f|1f|0x");
        this.setRow("2  2  0x|1x|1x|1x|1d|1d|1d|1x|1x|1x|0x");
        this.setRow("3  1  0x|1d|1d|1x|1x|1x|1x|1x|1d|1d|0x");
        this.setRow("3  2  0x|1r|1r|1f|1f|1f|1f|1r|1r|0x|0x");
        this.setRow("3  3  0x|0x|1r|1r|1r|1r|1r|1r|0x|0x|0x");
        this.setRow("3  4  0x|0x|0x|1f|1f|1f|1f|0x|0x|0x|0x");
        this.setRow("4  1  1x|1d|1d|1x|1x|1x|1x|1x|1d|1d|1x");
        this.setRow("4  2  0x|1r|1r|1f|1f|1f|1f|1r|1r|0x|0x");
        this.setRow("4  3  0x|0x|1x|1x|1x|1x|1x|1x|1x|0x|0x");
        this.setRow("4  4  0x|0x|1r|1f|1f|1f|1f|1r|0x|0x|0x");
        this.setRow("4  5  0x|0x|0x|0x|1x|1x|1x|0x|0x|0x|0x");
        this.setRow("4  6  0x|0x|0x|0x|1r|1r|0x|0x|0x|0x|0x");
        this.setRow("4  7  0x|0x|0x|0x|0x|1x|0x|0x|0x|0x|0x");
        this.setRow("5  1  1f|1f|0x|1x|1x|1x|1x|1x|1f|1f|0x");
        this.setRow("5  2  0x|1r|1r|0x|1d|1d|1d|1r|1r|0x|0x");
        this.setRow("5  3  0x|0x|1r|1r|1r|1r|1r|1r|0x|0x|0x");
        this.setRow("6  1  1f|1f|1r|1r|1r|1r|1r|1r|1f|1f|0x");
        this.setRow("6  2  0x|1x|1x|1x|1f|1f|0x|1x|1x|1x|0x");
        this.setRow("7  1  0x|0x|0x|1x|1x|1x|1x|1x|0x|0x|0x");
        this.setRow("7  2  0x|0x|0x|1r|0x|0x|1r|0x|0x|0x|0x");
    }

    public void cubeLayout() {
        this.fNumRow = 6;
        this.fNumCol = 6;
        this.fNumLvl = 4;
        this.fNumTil = 36;
        this.fNumRnk = 4;
        this.fTotTil = this.fNumTil * this.fNumRnk;
        this.prepareLayout();
        this.setRow("1  1  4x|4x|4x|4x|4x|4x");
        this.setRow("2  1  4x|4x|4x|4x|4x|4x");
        this.setRow("3  1  4x|4x|4x|4x|4x|4x");
        this.setRow("4  1  4x|4x|4x|4x|4x|4x");
        this.setRow("5  1  4x|4x|4x|4x|4x|4x");
        this.setRow("6  1  4x|4x|4x|4x|4x|4x");
    }

    public void glyphLayout() {
        this.fNumRow = 7;
        this.fNumCol = 9;
        this.fNumLvl = 6;
        this.fNumTil = 36;
        this.fNumRnk = 4;
        this.fTotTil = this.fNumTil * this.fNumRnk;
        this.prepareLayout();
        this.setRow("1  1  3x|3x|3x|0x|3x|0x|3x|3x|3x");
        this.setRow("2  1  0x|0x|3x|0x|4x|0x|3x|0x|0x");
        this.setRow("3  1  3x|3x|3x|4x|5x|4x|3x|3x|3x");
        this.setRow("4  1  3x|0x|4x|0x|6x|0x|4x|0x|3x");
        this.setRow("5  1  3x|3x|3x|4x|5x|4x|3x|3x|3x");
        this.setRow("6  1  0x|0x|3x|0x|4x|0x|3x|0x|0x");
        this.setRow("7  1  3x|3x|3x|0x|3x|0x|3x|3x|3x");
    }

    public void pyramidLayout() {
        this.fNumRow = 7;
        this.fNumCol = 8;
        this.fNumLvl = 7;
        this.fNumTil = 36;
        this.fNumRnk = 4;
        this.fTotTil = this.fNumTil * this.fNumRnk;
        this.prepareLayout();
        this.setRow("1  1  0x|1r|1r|1r|1r|1r|1r|1r");
        this.setRow("1  2  0x|0x|1d|1d|1d|1d|1d|1d");
        this.setRow("2  1  0x|1r|1r|1r|1r|1r|1r|1r");
        this.setRow("2  2  0x|0x|1d|1d|1d|1d|1d|1d");
        this.setRow("2  3  0x|0x|1r|1r|1r|1r|1r|0x");
        this.setRow("2  4  0x|0x|0x|1d|1d|1d|1d|0x");
        this.setRow("3  1  0x|1r|1r|1r|1r|1r|1r|1r");
        this.setRow("3  2  0x|0x|1d|1d|1d|1d|1d|1d");
        this.setRow("3  3  0x|0x|1r|1r|1r|1r|1r|0x");
        this.setRow("3  4  0x|0x|0x|1d|1d|1d|1d|0x");
        this.setRow("3  5  0x|0x|0x|1r|1r|1r|0x|0x");
        this.setRow("3  6  0x|0x|0x|0x|1d|1d|0x|0x");
        this.setRow("4  1  1r|1r|1r|1r|1r|1r|1r|1r");
        this.setRow("4  2  0x|1x|1d|1d|1d|1d|1d|1d");
        this.setRow("4  3  0x|1r|1r|1r|1r|1r|1r|0x");
        this.setRow("4  4  0x|0x|1x|1d|1d|1d|1d|0x");
        this.setRow("4  5  0x|0x|1r|1r|1r|1r|0x|0x");
        this.setRow("4  6  0x|0x|0x|0x|1d|1d|0x|0x");
        this.setRow("5  1  0x|1r|1r|1r|1r|1r|1r|1r");
        this.setRow("5  2  0x|0x|1d|1d|1d|1d|1d|1d");
        this.setRow("5  3  0x|0x|1r|1r|1r|1r|1r|0x");
        this.setRow("5  4  0x|0x|0x|1d|1d|1d|1d|0x");
        this.setRow("5  5  0x|0x|0x|1r|1r|1r|0x|0x");
        this.setRow("6  1  0x|1r|1r|1r|1r|1r|1r|1r");
        this.setRow("6  2  0x|0x|1d|1d|1d|1d|1d|1d");
        this.setRow("6  3  0x|0x|1r|1r|1r|1r|1r|0x");
        this.setRow("7  1  0x|1r|1r|1r|1r|1r|1r|1r");
    }

    public void archedBridgeLayout() {
        this.fNumRow = 4;
        this.fNumCol = 12;
        this.fNumLvl = 7;
        this.fNumTil = 36;
        this.fNumRnk = 4;
        this.fTotTil = this.fNumTil * this.fNumRnk;
        this.prepareLayout();
        this.setRow("1  1  6x|3x|4x|0x|0x|0x|0x|0x|0x|4x|3x|6x");
        this.setRow("1  3  0x|0x|0x|4x|0x|0x|0x|0x|4x|0x|0x|0x");
        this.setRow("1  4  0x|0x|0x|0x|2x|2x|2x|2x|0x|0x|0x|0x");
        this.setRow("1  6  0x|0x|0x|0x|0x|2r|0x|0x|0x|0x|0x|0x");
        this.setRow("2  1  1x|2x|3x|0x|0x|0x|0x|0x|0x|3x|2x|1x");
        this.setRow("2  2  0x|0x|0x|3x|0x|0x|0x|0x|3x|0x|0x|0x");
        this.setRow("2  3  0x|0x|0x|0x|2x|2x|2x|2x|0x|0x|0x|0x");
        this.setRow("2  6  1x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|1x");
        this.setRow("3  1  1x|2x|3x|0x|0x|0x|0x|0x|0x|3x|2x|1x");
        this.setRow("3  2  0x|0x|0x|3x|0x|0x|0x|0x|3x|0x|0x|0x");
        this.setRow("3  3  0x|0x|0x|0x|2x|2x|2x|2x|0x|0x|0x|0x");
        this.setRow("3  6  1x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|1x");
        this.setRow("4  1  6x|3x|4x|0x|0x|0x|0x|0x|0x|4x|3x|6x");
        this.setRow("4  3  0x|0x|0x|4x|0x|0x|0x|0x|4x|0x|0x|0x");
        this.setRow("4  4  0x|0x|0x|0x|2x|2x|2x|2x|0x|0x|0x|0x");
        this.setRow("4  6  0x|0x|0x|0x|0x|2r|0x|0x|0x|0x|0x|0x");
    }

    public void chineseCastleLayout() {
        this.fNumRow = 7;
        this.fNumCol = 9;
        this.fNumLvl = 5;
        this.fNumTil = 36;
        this.fNumRnk = 4;
        this.fTotTil = this.fNumTil * this.fNumRnk;
        this.prepareLayout();
        this.setRow("1  1  5x|4x|3x|4x|0x|4x|3x|4x|5x");
        this.setRow("1  3  0x|0x|0x|0x|3x|0x|0x|0x|0x");
        this.setRow("2  1  4x|0x|0x|0x|0x|0x|0x|0x|4x");
        this.setRow("2  4  0x|0x|2f|0x|0x|2f|0x|0x|0x");
        this.setRow("3  1  3x|0x|0x|3x|4x|3x|0x|0x|3x");
        this.setRow("4  1  5x|0x|0x|4x|0x|4x|0x|0x|5x");
        this.setRow("5  1  3x|0x|0x|3x|4x|3x|0x|0x|3x");
        this.setRow("5  4  0x|0x|2f|0x|0x|2f|0x|0x|0x");
        this.setRow("6  1  4x|0x|0x|0x|0x|0x|0x|0x|4x");
        this.setRow("7  1  5x|4x|3x|4x|0x|4x|3x|4x|5x");
        this.setRow("7  3  0x|0x|0x|0x|3x|0x|0x|0x|0x");
    }

    public void luckBoxLayout() {
        this.fNumRow = 7;
        this.fNumCol = 12;
        this.fNumLvl = 4;
        this.fNumTil = 36;
        this.fNumRnk = 4;
        this.fTotTil = this.fNumTil * this.fNumRnk;
        this.prepareLayout();
        this.setRow("1  1  3x|2x|2x|2x|3x|2x|3x|2x|3x|2x|2x|3x");
        this.setRow("2  1  2x|0x|0x|2x|2f|0x|0x|0x|2d|2f|0x|2x");
        this.setRow("3  1  3x|2f|0x|2x|2f|0x|0x|0x|2d|2d|0x|3x");
        this.setRow("4  1  2x|2f|0x|2r|0x|0x|2x|0x|2d|2f|0x|2x");
        this.setRow("5  1  3x|2f|2f|0x|0x|2r|2f|2f|0x|0x|0x|3x");
        this.setRow("6  1  2x|0x|0x|0x|0x|0x|0x|0x|0x|0x|0x|2x");
        this.setRow("7  1  3x|2x|2x|2x|3x|2x|2x|2x|3x|2x|2x|3x");
        this.setRow("2  4  0x|1x|0x|1x|0x|1x|0x|1x|0x|1x|0x|0x");
        this.setRow("3  4  0x|0x|1x|0x|1x|0x|1x|0x|1x|0x|1x|0x");
        this.setRow("4  4  0x|1x|0x|1x|0x|1x|0x|1x|0x|1x|0x|0x");
        this.setRow("5  4  0x|0x|1x|0x|1x|0x|1x|0x|1x|0x|1x|0x");
        this.setRow("6  4  0x|1x|0x|1x|0x|1x|0x|1x|0x|1x|0x|0x");
    }

    public void prepareLayout() {
        this.fTilLvl = new int[this.fNumCol][this.fNumRow];
        this.fTilHiLit = new boolean[this.fNumCol][this.fNumRow][this.fNumLvl];
        this.fTilXOff = new int[this.fNumCol][this.fNumRow][this.fNumLvl];
        this.fTilYOff = new int[this.fNumCol][this.fNumRow][this.fNumLvl];
        this.fTilBeg = new boolean[this.fNumCol][this.fNumRow][this.fNumLvl];
        if (this.fTilCvs != null) {
            this.fTilCvs.initBoardArrays();
        }
    }

    public void setLayout(int n) {
        if (n != this.fBrdLayOutNum) {
            this.fBrdLayOutNum = this.getLayout(n);
            this.fTilCvs.setNewLayout();
            this.loadGame();
            this.newGame();
        }
    }

    public void getNextLayout() {
        this.fBrdLayOutNum = this.getLayout(this.fBrdLayOutNum + 1);
        this.fTilCvs.setNewLayout();
        this.loadGame();
        this.newGame();
    }

    public void getPreviousLayout() {
        this.fBrdLayOutNum = this.getLayout(this.fBrdLayOutNum - 1);
        this.fTilCvs.setNewLayout();
        this.loadGame();
        this.newGame();
    }

    public int getLayout(int n) {
        if (this.fBrdLayOutNum != n) {
            this.fBrdLayOutNum = this.fTilApp.getBoardLayoutNum(n);
            this.fBrdLayOut = this.fTilApp.getBoardLayout(this.fBrdLayOutNum);
            if (this.fTilCvs != null) {
                this.fTilCvs.setNewLayout();
            }
        }
        return this.fBrdLayOutNum;
    }

    public String getLayoutName() {
        return this.fBrdLayOut;
    }

    public int getLayoutNum() {
        return this.fBrdLayOutNum;
    }

    public void loadGame() {
        this.fLftRgt = kLftRgt;
        this.fLftOff = kLftOff;
        this.fRgtOff = kRgtOff;
        this.fLvlOff = kLvlOff;
        this.fNumTil = this.fTilApp.getPlaySets();
        this.fNumRnk = this.fTilApp.getPlayPerSet();
        this.fTotTil = this.fNumTil * this.fNumRnk;
        if (this.fBrdLayOut.equalsIgnoreCase("Standard")) {
            this.standardLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Bridge")) {
            this.bridgeLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Castle")) {
            this.castleLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Room")) {
            this.roomLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Towers")) {
            this.towersLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Child")) {
            this.childLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Standard Taipei") || this.fBrdLayOut.equalsIgnoreCase("Compact")) {
            this.standardtaipeiLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Cube")) {
            this.cubeLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Glyph")) {
            this.glyphLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Pyramid")) {
            this.pyramidLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Arched Bridge")) {
            this.archedBridgeLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Chinese Castle")) {
            this.chineseCastleLayout();
        } else if (this.fBrdLayOut.equalsIgnoreCase("Luck Box")) {
            this.luckBoxLayout();
        } else {
            this.fTilApp.ohNo("Unknown board layout " + this.fBrdLayOut);
            this.standardLayout();
        }
        this.checkLayout();
        this.fTilSet = new int[this.fNumCol][this.fNumRow][this.fNumLvl];
        this.fTilRnk = new int[this.fNumCol][this.fNumRow][this.fNumLvl];
        this.fTilIs = new boolean[this.fNumCol][this.fNumRow][this.fNumLvl];
        this.fTilTop = new int[this.fNumCol][this.fNumRow];
        this.fSetMch = new int[this.fNumTil];
        this.fMovCol = new int[this.fTotTil];
        this.fMovRow = new int[this.fTotTil];
        this.fMovLvl = new int[this.fTotTil];
        this.fLodGam = false;
    }

    public void newGame() {
        if (this.fLodGam) {
            this.fBrdLayOutNum = this.getLayout(0);
            this.loadGame();
        } else {
            this.fTilCvs.swapTileImages();
        }
        if (this.fTilCvs != null) {
            this.fTilCvs.stopContinuous();
        }
        this.fMovNum = 0;
        this.fMovTop = 0;
        this.fCluLvl = 0;
        this.fCluCrd = this.fTilApp.getClueCredit();
        this.fSelCol = -1;
        int n = 0;
        while (n < this.fNumTil) {
            this.fSetMch[n] = 0;
            ++n;
        }
        this.fTilApp.showStatus("Placing tiles...");
        if (this.fTilApp.getWinnable() < 0) {
            this.dealRandom();
        } else {
            this.dealWinnable();
        }
        this.fGamRdy = true;
        this.fGamBeg = false;
        if (this.fTilCvs != null) {
            this.fTilCvs.setNewGame();
            this.fTilCvs.playing();
            this.fTilCvs.invalidateBuffer();
            this.fTilCvs.repaint();
            this.showLevel();
            this.checkDone();
        }
    }

    public void dealRandom() {
        int n;
        Object object;
        this.fWinColOne = null;
        this.fWinRowOne = null;
        this.fWinLvlOne = null;
        this.fWinColTwo = null;
        this.fWinRowTwo = null;
        this.fWinLvlTwo = null;
        this.fWinTop = 0;
        int[] nArray = new int[this.fNumTil];
        if (this.fBasSet >= this.fNumRnk) {
            object = new Random();
            n = 0;
            while (n < this.fNumTil) {
                nArray[n] = (int)(((Random)object).nextFloat() * (float)(this.fNumRnk + 1));
                ++n;
            }
        }
        object = new TileDeck(this.fTilApp, this);
        n = 0;
        while (n < this.fNumCol) {
            int n2 = 0;
            while (n2 < this.fNumRow) {
                this.fTilTop[n][n2] = -1;
                int n3 = 0;
                while (n3 < this.fNumLvl) {
                    this.fTilIs[n][n2][n3] = false;
                    if (this.fTilBeg[n][n2][n3]) {
                        Point point = ((TileDeck)object).drawTile();
                        if (point.x >= 0) {
                            this.fTilIs[n][n2][n3] = true;
                            this.fTilSet[n][n2][n3] = point.x;
                            this.fTilRnk[n][n2][n3] = this.assignRank(point.x, point.y, nArray);
                            this.fTilTop[n][n2] = n3;
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public int assignRank(int n, int n2, int[] nArray) {
        if (this.fBasSet < this.fNumRnk) {
            return (n2 % this.fGamLvl + this.fBasSet) % this.fNumRnk;
        }
        return (n2 % this.fGamLvl + nArray[n]) % this.fNumRnk;
    }

    public void resetTileIsThere() {
        int n = 0;
        while (n < this.fNumCol) {
            int n2 = 0;
            while (n2 < this.fNumRow) {
                this.fTilTop[n][n2] = -1;
                int n3 = 0;
                while (n3 < this.fNumLvl) {
                    this.fTilIs[n][n2][n3] = this.fTilBeg[n][n2][n3];
                    if (this.fTilIs[n][n2][n3] && n3 > this.fTilTop[n][n2]) {
                        this.fTilTop[n][n2] = n3;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public int expandCanMoveList(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n7, int n8, boolean[][][] blArray) {
        int n9 = n;
        while (n9 <= n4) {
            int n10 = n2;
            while (n10 <= n5) {
                int n11 = n3;
                while (n11 <= n6) {
                    if (this.isTileThere(n9, n10, n11) && !blArray[n9][n10][n11] && this.canMove(n9, n10, n11)) {
                        nArray4[n7] = n8;
                        nArray[n7] = n9;
                        nArray2[n7] = n10;
                        nArray3[n7] = n11;
                        blArray[n9][n10][n11] = true;
                        ++n7;
                    }
                    ++n11;
                }
                ++n10;
            }
            ++n9;
        }
        return n7;
    }

    public int reduceCanMoveList(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, boolean[][][] blArray, int n3) {
        int n4 = n > n2 ? n : n2;
        int n5 = n > n2 ? n2 : n;
        nArray[n4] = nArray[--n3];
        nArray2[n4] = nArray2[n3];
        nArray3[n4] = nArray3[n3];
        nArray4[n4] = nArray4[n3];
        nArray[n5] = nArray[--n3];
        nArray2[n5] = nArray2[n3];
        nArray3[n5] = nArray3[n3];
        nArray4[n5] = nArray4[n3];
        return n3;
    }

    public void dealWinnable() {
        this.dealWinnable(1);
    }

    public void dealWinnable(int n) {
        this.resetTileIsThere();
        this.fWinColOne = new int[this.fTotTil];
        this.fWinRowOne = new int[this.fTotTil];
        this.fWinLvlOne = new int[this.fTotTil];
        this.fWinColTwo = new int[this.fTotTil];
        this.fWinRowTwo = new int[this.fTotTil];
        this.fWinLvlTwo = new int[this.fTotTil];
        this.fWinTop = 0;
        int[] nArray = new int[this.fTotTil];
        int[] nArray2 = new int[this.fTotTil];
        int[] nArray3 = new int[this.fTotTil];
        int[] nArray4 = new int[this.fTotTil];
        boolean[][][] blArray = new boolean[this.fNumCol][this.fNumRow][this.fNumLvl];
        int n2 = this.expandCanMoveList(0, 0, 0, this.fNumCol - 1, this.fNumRow - 1, this.fNumLvl - 1, nArray, nArray2, nArray3, nArray4, 0, 0, blArray);
        Random random = new Random();
        int[] nArray5 = new int[this.fNumTil];
        if (this.fBasSet >= this.fNumRnk) {
            int n3 = 0;
            while (n3 < this.fNumTil) {
                nArray5[n3] = (int)(random.nextFloat() * (float)(this.fNumRnk + 1));
                ++n3;
            }
        }
        int[] nArray6 = new int[this.fNumTil];
        boolean[][] blArray2 = new boolean[this.fNumTil][this.fNumRnk];
        boolean[][][] blArray3 = new boolean[this.fNumCol][this.fNumRow][this.fNumLvl];
        int n4 = 0;
        this.fTilApp.getWinnable();
        while (n4 < this.fTotTil) {
            int n5;
            int n6;
            if (n2 < 2) {
                if (n < 20) {
                    this.dealWinnable(n + 1);
                    return;
                }
                if (this.fTilApp.getMagikMode()) {
                    this.fTilApp.ohNo("Ran out of tiles to assign at " + Integer.toString(n4));
                    this.resetTileIsThere();
                    return;
                }
                this.dealRandom();
                return;
            }
            int n7 = (int)(random.nextFloat() * (float)n2);
            int n8 = 0;
            int n9 = (int)(random.nextFloat() * (float)n2);
            if (n9 == n7) {
                n9 = (n7 + 1) % n2;
            }
            int n10 = n9;
            int n11 = -1;
            while (n8 < n2) {
                if ((n9 = (n9 + 1) % n2) != n7) {
                    n6 = nArray4[n7] + nArray4[n9];
                    n5 = this.fTilApp.getWinnable() - n6;
                    if (n5 < 0) {
                        n5 = -n5;
                    }
                    if (n5 < n11 || n11 < 0) {
                        n10 = n9;
                        n11 = n5;
                    }
                }
                ++n8;
            }
            if (n7 == n10) {
                n10 = (n7 + 1) % n2;
            }
            int n12 = nArray[n7];
            int n13 = nArray2[n7];
            int n14 = nArray3[n7];
            int n15 = nArray4[n7];
            int n16 = nArray[n10];
            int n17 = nArray2[n10];
            int n18 = nArray3[n10];
            int n19 = nArray4[n10];
            n2 = this.reduceCanMoveList(n7, n10, nArray, nArray2, nArray3, nArray4, blArray, n2);
            blArray3[n12][n13][n14] = true;
            blArray3[n16][n17][n18] = true;
            n6 = (int)(random.nextFloat() * (float)this.fNumTil);
            while (nArray6[n6] >= this.fNumRnk) {
                if (++n6 < this.fNumTil) continue;
                n6 = 0;
            }
            int n20 = n6;
            nArray6[n20] = nArray6[n20] + 2;
            n5 = (int)(random.nextFloat() * (float)this.fNumRnk);
            while (blArray2[n6][n5]) {
                if (++n5 < this.fNumRnk) continue;
                n5 = 0;
            }
            blArray2[n6][n5] = true;
            int n21 = (int)(random.nextFloat() * (float)this.fNumRnk);
            while (blArray2[n6][n21]) {
                if (++n21 < this.fNumRnk) continue;
                n21 = 0;
            }
            blArray2[n6][n21] = true;
            this.fTilSet[n12][n13][n14] = n6;
            this.fTilRnk[n12][n13][n14] = this.assignRank(n6, n5, nArray5);
            this.fTilSet[n16][n17][n18] = n6;
            this.fTilRnk[n16][n17][n18] = this.assignRank(n6, n21, nArray5);
            this.fTilIs[n12][n13][n14] = false;
            this.fTilIs[n16][n17][n18] = false;
            if (this.fTilTop[n12][n13] == n14) {
                int[] nArray7 = this.fTilTop[n12];
                int n22 = n13;
                nArray7[n22] = nArray7[n22] - 1;
            }
            if (this.fTilTop[n16][n17] == n18) {
                int[] nArray8 = this.fTilTop[n16];
                int n23 = n17;
                nArray8[n23] = nArray8[n23] - 1;
            }
            int n24 = n15;
            if (n19 > n15) {
                n24 = n19;
            }
            n2 = this.expandCanMoveList(n12 - 1, n13 - 1, n14 - 1, n12 + 1, n13 + 1, n14, nArray, nArray2, nArray3, nArray4, n2, n24 + 1, blArray);
            n2 = this.expandCanMoveList(n16 - 1, n17 - 1, n18 - 1, n16 + 1, n17 + 1, n18, nArray, nArray2, nArray3, nArray4, n2, n24 + 1, blArray);
            this.fWinColOne[this.fWinTop] = n12;
            this.fWinRowOne[this.fWinTop] = n13;
            this.fWinLvlOne[this.fWinTop] = n14;
            this.fWinColTwo[this.fWinTop] = n16;
            this.fWinRowTwo[this.fWinTop] = n17;
            this.fWinLvlTwo[this.fWinTop] = n18;
            ++this.fWinTop;
            n4 += 2;
        }
        this.resetTileIsThere();
    }

    public void showLevel() {
        if (this.fBasSet >= this.fNumRnk) {
            this.fTilApp.showStatus(String.valueOf(this.fBrdLayOut) + " Layout, " + "Level " + Integer.toString(this.fGamLvl) + ", Set Random" + "      " + this.fTilApp.getNewGameMessage());
            return;
        }
        this.fTilApp.showStatus(String.valueOf(this.fBrdLayOut) + " Layout, " + "Level " + Integer.toString(this.fGamLvl) + ", Set " + Integer.toString(this.fBasSet + 1) + "      " + this.fTilApp.getNewGameMessage());
    }

    public void adjustGameLevel(int n) {
        if (n == this.fGamLvl) {
            return;
        }
        this.fGamLvl = n > this.fTilApp.getMaxLevel() ? this.fTilApp.getMaxLevel() : (n < this.fTilApp.getMinLevel() ? this.fTilApp.getMinLevel() : n);
        this.fTilCvs.setNewLevel();
        this.showLevel();
    }

    public void setGameParms(int n, int n2, int n3) {
        this.setGameLevel(n, false);
        this.setTileSet(n2, false);
        if (n3 != this.fBrdLayOutNum) {
            this.setLayout(n3);
            return;
        }
        this.newGame();
    }

    public void setGameLevel(int n) {
        this.setGameLevel(n, true);
    }

    public void setGameLevel(int n, boolean bl) {
        this.adjustGameLevel(n);
        if (bl) {
            this.newGame();
        }
    }

    public void setTileSet(int n) {
        this.setTileSet(n, true);
    }

    public void setTileSet(int n, boolean bl) {
        this.fBasSet = --n >= this.fNumRnk + 1 ? this.fNumRnk - 1 : (n < 0 ? 0 : n);
        if (bl) {
            this.newGame();
        }
    }

    public void reduceLevel() {
        this.adjustGameLevel(this.fGamLvl - 1);
    }

    public void clueCharge(int n) {
        this.fCluCrd -= n;
        if (this.fCluCrd <= 0 && this.fTilApp.getClueCredit() > 0) {
            this.fCluCrd = this.fTilApp.getClueCredit();
            this.reduceLevel();
            this.fTilCvs.playSound("degrade.au");
            this.fTilApp.showStatus("That'll cost you...");
            return;
        }
        this.fTilCvs.playSound("clue.au");
        this.fTilApp.showStatus("Allow me to help...");
    }

    public void noClue() {
        if (this.fCluLvl > 0) {
            this.fCluLvl = 0;
            if (this.fNumHiLit > 0) {
                this.noHighlights();
                this.fTilCvs.invalidateBuffer();
                this.fTilCvs.repaint();
            }
        }
    }

    public void noHighlights() {
        this.fNumHiLit = 0;
        int n = 0;
        while (n < this.fNumCol) {
            int n2 = 0;
            while (n2 < this.fNumRow) {
                int n3 = 0;
                while (n3 < this.fNumLvl) {
                    this.fTilHiLit[n][n2][n3] = false;
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void hilightTile(int n, int n2, int n3) {
        if (!this.fTilHiLit[n][n2][n3]) {
            ++this.fNumHiLit;
        }
        this.fTilHiLit[n][n2][n3] = true;
    }

    public void unHighlightTile(int n, int n2, int n3) {
        if (this.fTilHiLit[n][n2][n3]) {
            --this.fNumHiLit;
        }
        this.fTilHiLit[n][n2][n3] = false;
    }

    public void showSelected() {
        int n = 0;
        while (n < this.fNumCol) {
            int n2 = 0;
            while (n2 < this.fNumRow) {
                int n3 = 0;
                while (n3 < this.fNumLvl) {
                    if (n == this.fSelCol && n2 == this.fSelRow && n3 == this.fSelLvl) {
                        this.hilightTile(n, n2, n3);
                        this.fTilCvs.tileMoved(n, n2, n3);
                    } else {
                        this.unHighlightTile(n, n2, n3);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.fTilCvs.repaint();
    }

    public void showMatches() {
        int n = 0;
        while (n < this.fNumCol) {
            int n2 = 0;
            while (n2 < this.fNumRow) {
                int n3 = 0;
                while (n3 < this.fNumLvl) {
                    if (this.isTileThere(n, n2, n3) && this.fTilSet[n][n2][n3] == this.fTilSet[this.fSelCol][this.fSelRow][this.fSelLvl]) {
                        if (this.canMove(n, n2, n3)) {
                            this.hilightTile(n, n2, n3);
                        } else {
                            this.unHighlightTile(n, n2, n3);
                        }
                        if (this.fTilHiLit[n][n2][n3]) {
                            this.fTilCvs.tileMoved(n, n2, n3);
                        }
                    } else {
                        this.unHighlightTile(n, n2, n3);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.fTilCvs.repaint();
    }

    public void showMoveable() {
        int n = 0;
        while (n < this.fNumCol) {
            int n2 = 0;
            while (n2 < this.fNumRow) {
                int n3 = 0;
                while (n3 < this.fNumLvl) {
                    if (this.isTileThere(n, n2, n3)) {
                        if (this.canMove(n, n2, n3)) {
                            this.hilightTile(n, n2, n3);
                        } else {
                            this.unHighlightTile(n, n2, n3);
                        }
                    } else {
                        this.unHighlightTile(n, n2, n3);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.fTilCvs.invalidateBuffer();
        this.fTilCvs.repaint();
    }

    public void showRemoveable() {
        this.showMoveable();
        int n = 0;
        while (n < this.fNumCol) {
            int n2 = 0;
            while (n2 < this.fNumRow) {
                int n3 = 0;
                while (n3 < this.fNumLvl) {
                    if (this.isTileThere(n, n2, n3) && this.fTilHiLit[n][n2][n3]) {
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < this.fNumCol) {
                            int n6 = 0;
                            while (n6 < this.fNumRow) {
                                int n7 = 0;
                                while (n7 < this.fNumLvl) {
                                    if (this.isTileThere(n5, n6, n7) && (n != n5 || n2 != n6 || n3 != n7) && this.fTilHiLit[n5][n6][n7] && this.fTilSet[n][n2][n3] == this.fTilSet[n5][n6][n7]) {
                                        ++n4;
                                        n5 = this.fNumCol;
                                        n6 = this.fNumRow;
                                        n7 = this.fNumLvl;
                                    }
                                    ++n7;
                                }
                                ++n6;
                            }
                            ++n5;
                        }
                        if (n4 == 0) {
                            this.unHighlightTile(n, n2, n3);
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.fTilCvs.invalidateBuffer();
        this.fTilCvs.repaint();
    }

    public void showRandomMatch() {
        this.showRemoveable();
        if (this.fNumHiLit == 0) {
            this.noClue();
            return;
        }
        int n = -1;
        Random random = new Random();
        int n2 = Math.abs(random.nextInt()) % this.fNumCol;
        int n3 = Math.abs(random.nextInt()) % this.fNumRow;
        int n4 = Math.abs(random.nextInt()) % this.fNumLvl;
        while (n < 0) {
            if (this.fTilHiLit[n2][n3][n4]) {
                n = this.fTilSet[n2][n3][n4];
            }
            if ((n2 = (n2 + 1) % this.fNumRow) != 0 || (n3 = (n3 + 1) % this.fNumRow) != 0) continue;
            n4 = (n4 + 1) % this.fNumLvl;
        }
        n2 = 0;
        while (n2 < this.fNumCol) {
            n3 = 0;
            while (n3 < this.fNumRow) {
                n4 = 0;
                while (n4 < this.fNumLvl) {
                    if (this.isTileThere(n2, n3, n4) && this.fTilSet[n2][n3][n4] != n) {
                        this.unHighlightTile(n2, n3, n4);
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void proveWinnable() {
        if (this.fWinTop == 0) {
            this.fTilApp.showStatus("I don't know how to win this game.");
            return;
        }
        int n = 0;
        while (n < this.fWinTop && !this.isTileThere(this.fWinColOne[n], this.fWinRowOne[n], this.fWinLvlOne[n]) && !this.isTileThere(this.fWinColTwo[n], this.fWinRowTwo[n], this.fWinLvlTwo[n])) {
            ++n;
        }
        if (n < this.fWinTop) {
            boolean bl = false;
            int n2 = n;
            while (n2 < this.fWinTop) {
                if (!this.isTileThere(this.fWinColOne[n2], this.fWinRowOne[n2], this.fWinLvlOne[n2]) || !this.isTileThere(this.fWinColTwo[n2], this.fWinRowTwo[n2], this.fWinLvlTwo[n2])) {
                    bl = true;
                    this.fTilApp.showStatus("Oops!  Let me undo your mistakes first...");
                    while (!this.isTileThere(this.fWinColOne[n2], this.fWinRowOne[n2], this.fWinLvlOne[n2]) || !this.isTileThere(this.fWinColTwo[n2], this.fWinRowTwo[n2], this.fWinLvlTwo[n2])) {
                        this.undoLastMove();
                    }
                }
                ++n2;
            }
            if (bl) {
                this.fTilApp.showStatus("Oops!  I had to undo your mistakes, first.");
                return;
            }
            this.fTilApp.showStatus("This is the next move...");
            this.selectTile(this.fWinColOne[n], this.fWinRowOne[n], this.fWinLvlOne[n]);
            this.selectTile(this.fWinColTwo[n], this.fWinRowTwo[n], this.fWinLvlTwo[n]);
            if (n < this.fWinTop - 1) {
                this.fTilApp.showStatus("That was the next move.");
                return;
            }
            this.fTilApp.showStatus("And that's how you win!");
            return;
        }
        this.checkDone();
        this.fTilApp.showStatus("You seem to have won already.");
    }

    public void nextClue() {
        this.noHighlights();
        ++this.fCluLvl;
        if (this.fSelCol >= 0) {
            switch (this.fCluLvl) {
                case 1: {
                    this.showSelected();
                    this.clueCharge(0);
                    return;
                }
                case 2: {
                    this.showMatches();
                    this.clueCharge(1);
                    return;
                }
            }
            this.noClue();
            this.fTilCvs.playSound("invalid.au");
            this.fTilApp.showStatus("No clue.");
            return;
        }
        switch (this.fCluLvl) {
            case 1: {
                this.showMoveable();
                this.clueCharge(0);
                return;
            }
            case 2: {
                this.showRemoveable();
                this.clueCharge(2);
                return;
            }
            case 3: {
                this.showRemoveable();
                this.showRandomMatch();
                this.clueCharge(3);
                return;
            }
        }
        this.showRemoveable();
        this.showRandomMatch();
        this.clueCharge(3);
    }

    public int getGameLevel() {
        return this.fGamLvl;
    }

    public int getTileSet() {
        return this.fBasSet + 1;
    }

    public boolean canMove(int n, int n2, int n3) {
        int n4 = n3 + 1;
        int n5 = n - 1;
        int n6 = n + 1;
        int n7 = n2 - 1;
        int n8 = n2 + 1;
        boolean bl = false;
        boolean bl2 = false;
        if (this.isTileThere(n, n2, n4)) {
            return false;
        }
        switch (this.xOffset(n, n2, n3) * 2 + this.yOffset(n, n2, n3)) {
            case 0: {
                if (this.isTileThere(n5, n2, n4) && this.xOffset(n5, n2, n4) > 0) {
                    return false;
                }
                if (this.isTileThere(n5, n7, n4) && this.xOffset(n5, n7, n4) > 0 && this.yOffset(n5, n7, n4) > 0) {
                    return false;
                }
                if (this.isTileThere(n, n7, n4) && this.yOffset(n, n7, n4) > 0) {
                    return false;
                }
                if (this.isTileThere(n5, n7, n3) && this.yOffset(n5, n7, n3) > 0) {
                    bl = true;
                }
                if (this.isTileThere(n5, n2, n3)) {
                    bl = true;
                }
                if (this.isTileThere(n6, n7, n3) && this.yOffset(n6, n7, n3) > 0 && this.xOffset(n6, n7, n3) == 0) {
                    bl2 = true;
                }
                if (!this.isTileThere(n6, n2, n3) || this.xOffset(n6, n2, n3) != 0) break;
                bl2 = true;
                break;
            }
            case 1: {
                if (this.isTileThere(n5, n2, n4) && this.xOffset(n5, n2, n4) > 0) {
                    return false;
                }
                if (this.isTileThere(n5, n8, n4) && this.xOffset(n5, n8, n4) > 0 && this.yOffset(n5, n8, n4) == 0) {
                    return false;
                }
                if (this.isTileThere(n, n8, n4) && this.yOffset(n, n8, n4) == 0) {
                    return false;
                }
                if (this.isTileThere(n5, n2, n3)) {
                    bl = true;
                }
                if (this.isTileThere(n5, n8, n3) && this.yOffset(n5, n8, n3) == 0) {
                    bl = true;
                }
                if (this.isTileThere(n6, n2, n3) && this.xOffset(n6, n2, n3) == 0) {
                    bl2 = true;
                }
                if (!this.isTileThere(n6, n8, n3) || this.xOffset(n6, n8, n3) != 0 || this.yOffset(n6, n8, n3) != 0) break;
                bl2 = true;
                break;
            }
            case 2: {
                if (this.isTileThere(n6, n2, n4) && this.xOffset(n6, n2, n4) == 0) {
                    return false;
                }
                if (this.isTileThere(n6, n7, n4) && this.xOffset(n6, n7, n4) == 0 && this.yOffset(n6, n7, n4) > 0) {
                    return false;
                }
                if (this.isTileThere(n, n7, n4) && this.yOffset(n, n7, n4) > 0) {
                    return false;
                }
                if (this.isTileThere(n5, n7, n3) && this.yOffset(n5, n7, n3) > 0 && this.xOffset(n5, n7, n3) > 0) {
                    bl = true;
                }
                if (this.isTileThere(n5, n2, n3) && this.xOffset(n5, n2, n3) > 0) {
                    bl = true;
                }
                if (this.isTileThere(n6, n2, n3)) {
                    bl2 = true;
                }
                if (!this.isTileThere(n6, n7, n3) || this.yOffset(n6, n7, n3) <= 0) break;
                bl2 = true;
                break;
            }
            case 3: {
                if (this.isTileThere(n6, n2, n4) && this.xOffset(n6, n2, n4) == 0) {
                    return false;
                }
                if (this.isTileThere(n, n8, n4) && this.yOffset(n, n8, n4) == 0) {
                    return false;
                }
                if (this.isTileThere(n6, n8, n4) && this.xOffset(n6, n8, n4) == 0 && this.yOffset(n6, n8, n4) == 0) {
                    return false;
                }
                if (this.isTileThere(n5, n2, n3) && this.xOffset(n5, n2, n3) > 0) {
                    bl = true;
                }
                if (this.isTileThere(n5, n8, n3) && this.yOffset(n5, n8, n3) == 0 && this.xOffset(n5, n8, n3) > 0) {
                    bl = true;
                }
                if (this.isTileThere(n6, n2, n3)) {
                    bl2 = true;
                }
                if (!this.isTileThere(n6, n8, n3) || this.yOffset(n6, n8, n3) != 0) break;
                bl2 = true;
                break;
            }
            default: {
                this.fTilApp.ohNo("Internal error: Invalid tile shift.");
                return false;
            }
        }
        return !bl || !bl2;
    }

    public void checkDone() {
        if (this.fMovNum >= this.fTotTil) {
            this.fTilCvs.win();
            return;
        }
        if (!this.findMoves()) {
            this.fTilCvs.lose();
        }
    }

    public boolean findMoves() {
        if (this.fAutPly) {
            this.fTilApp.showStatus("Scanning for autoplay...");
        }
        boolean bl = false;
        int[] nArray = new int[this.fNumTil];
        int[] nArray2 = new int[this.fNumTil];
        int[] nArray3 = new int[this.fNumTil];
        int[] nArray4 = new int[this.fNumTil];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.fNumCol) {
            int n7 = 0;
            while (n7 < this.fNumRow) {
                int n8 = 0;
                while (n8 < this.fNumLvl) {
                    if (this.isTileThere(n6, n7, n8) && this.canMove(n6, n7, n8)) {
                        int n9;
                        int n10 = n9 = this.fTilSet[n6][n7][n8];
                        nArray[n10] = nArray[n10] + 1;
                        if (nArray[n9] > 1) {
                            if (this.fAutPly) {
                                bl = true;
                            } else {
                                return true;
                            }
                        }
                        if (nArray[n9] == 1) {
                            nArray2[n9] = n6;
                            nArray3[n9] = n7;
                            nArray4[n9] = n8;
                        } else {
                            ++n2;
                            n = n9;
                            n3 = n6;
                            n4 = n7;
                            n5 = n8;
                        }
                        if (this.fAutPly && this.fSetMch[n9] + nArray[n9] == this.fNumRnk) {
                            this.selectTile(nArray2[n9], nArray3[n9], nArray4[n9]);
                            this.selectTile(n6, n7, n8);
                            return true;
                        }
                    }
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        if (this.fAutPly && n2 == 1) {
            this.selectTile(nArray2[n], nArray3[n], nArray4[n]);
            this.selectTile(n3, n4, n5);
            return true;
        }
        if (this.fAutPly) {
            this.fTilApp.showStatus("No automatic moves (" + Integer.toString(n2) + " matches available).");
        }
        return bl;
    }

    public void requestBonuses(int n, int n2, int n3) {
        if (this.fTilApp.getBonusControl().equalsIgnoreCase("match")) {
            if (this.fTilApp.getBonusType().equalsIgnoreCase("tile")) {
                this.fTilCvs.requestBonusImage(n, n2, true);
                this.fTilCvs.requestBonusImage(n, n3, true);
                return;
            }
            this.fTilCvs.requestBonusImage(n, n2, true);
            return;
        }
        if (this.fTilApp.getBonusControl().equalsIgnoreCase("set") && this.fSetMch[n] >= this.fNumRnk) {
            if (this.fTilApp.getBonusType().equalsIgnoreCase("tile")) {
                int n4 = 0;
                while (n4 < this.fNumRnk) {
                    this.fTilCvs.requestBonusImage(n, n4, true);
                    ++n4;
                }
                return;
            }
            this.fTilCvs.requestBonusImage(n, n2, true);
        }
    }

    public void selectTile(int n, int n2, int n3) {
        this.noClue();
        int n4 = this.fSelCol;
        int n5 = this.fSelRow;
        int n6 = this.fSelLvl;
        if (this.canMove(n, n2, n3)) {
            if (this.fSelCol >= 0 && this.fTilSet[n][n2][n3] == this.fTilSet[this.fSelCol][this.fSelRow][this.fSelLvl]) {
                if (this.fSelCol == n && this.fSelRow == n2 && this.fSelLvl == n3) {
                    this.fSelCol = -1;
                    this.fTilCvs.tileMoved(n4, n5, n6);
                    this.fTilCvs.playSound("select.au");
                    this.fTilApp.showStatus("Un select");
                } else {
                    this.fGamBeg = true;
                    int n7 = this.fTilSet[n][n2][n3];
                    int n8 = this.fTilRnk[n][n2][n3];
                    int n9 = this.fTilRnk[this.fSelCol][this.fSelRow][this.fSelLvl];
                    this.fMovCol[this.fMovNum] = n;
                    this.fMovRow[this.fMovNum] = n2;
                    this.fMovLvl[this.fMovNum] = n3;
                    this.fTilIs[n][n2][n3] = false;
                    ++this.fMovNum;
                    int n10 = n7;
                    this.fSetMch[n10] = this.fSetMch[n10] + 1;
                    if (this.fMovNum < this.fTotTil) {
                        this.fMovMrk[this.fMovNum] = false;
                    }
                    this.fMovCol[this.fMovNum] = this.fSelCol;
                    this.fMovRow[this.fMovNum] = this.fSelRow;
                    this.fMovLvl[this.fMovNum] = this.fSelLvl;
                    this.fTilIs[this.fSelCol][this.fSelRow][this.fSelLvl] = false;
                    ++this.fMovNum;
                    int n11 = n7;
                    this.fSetMch[n11] = this.fSetMch[n11] + 1;
                    if (this.fMovNum < this.fTotTil) {
                        this.fMovMrk[this.fMovNum] = false;
                    }
                    this.fMovTop = this.fMovNum;
                    int[] nArray = this.fTilTop[n];
                    int n12 = n2;
                    nArray[n12] = nArray[n12] - 1;
                    int[] nArray2 = this.fTilTop[this.fSelCol];
                    int n13 = this.fSelRow;
                    nArray2[n13] = nArray2[n13] - 1;
                    this.fSelCol = -1;
                    this.fTilCvs.tilesRemoved(n4, n5, n6, n, n2, n3);
                    this.fTilCvs.playSound("match.au");
                    this.fTilApp.showStatus("A match.  " + Integer.toString(this.fTotTil - this.fMovNum) + " tiles remaining.");
                    if (this.fTilApp.getBonusOption()) {
                        this.requestBonuses(n7, n8, n9);
                    }
                    this.checkDone();
                }
            } else {
                this.fSelCol = n;
                this.fSelRow = n2;
                this.fSelLvl = n3;
                this.fTilCvs.tileMoved(n4, n5, n6);
                this.fTilCvs.tileMoved(this.fSelCol, this.fSelRow, this.fSelLvl);
                if (n4 >= 0) {
                    this.fTilCvs.playSound("nomatch.au");
                } else {
                    this.fTilCvs.playSound("select.au");
                }
                this.fTilApp.showStatus("Selected.");
            }
        } else {
            this.fSelCol = -1;
            this.fTilCvs.tileMoved(n4, n5, n6);
            this.fTilCvs.playSound("invalid.au");
            this.fTilApp.showStatus("Tile cannot be removed.");
        }
        this.fTilCvs.repaint();
    }

    public void markPosition() {
        if (this.fMovNum < this.fTotTil) {
            this.fMovMrk[this.fMovNum] = true;
        }
        this.fTilCvs.playSound("mark.au");
        this.fTilApp.showStatus("Marked");
    }

    /*
     * Unable to fully structure code
     */
    public void undoToTile(int var1_1) {
        var2_2 = false;
        var3_3 = this.fMovNum - 1;
        while (var3_3 > 0 && !var2_2) {
            if (var1_1 == this.fTilSet[this.fMovCol[var3_3]][this.fMovRow[var3_3]][this.fMovLvl[var3_3]]) {
                var2_2 = true;
            }
            --var3_3;
        }
        if (var2_2) ** GOTO lbl14
        this.fTilApp.showStatus("Tile has never been matched.");
        return;
lbl-1000:
        // 1 sources

        {
            this.undoLastMove();
            if (var1_1 != this.fTilSet[this.fMovCol[this.fMovNum - 1]][this.fMovRow[this.fMovNum - 1]][this.fMovLvl[this.fMovNum - 1]]) continue;
            var2_2 = false;
lbl14:
            // 3 sources

            ** while (this.fMovNum > 0 && var2_2)
        }
lbl15:
        // 1 sources

        this.undoLastMove();
    }

    public void redoToTile(int n) {
        boolean bl = true;
        while (this.fMovNum < this.fMovTop && bl) {
            if (n == this.fTilSet[this.fMovCol[this.fMovNum]][this.fMovRow[this.fMovNum]][this.fMovLvl[this.fMovNum]]) {
                bl = false;
            }
            this.redoLastMove();
        }
    }

    public void undoToMark() {
        this.undoLastMove();
        while (!this.fMovMrk[this.fMovNum] && this.fMovNum > 0) {
            this.undoLastMove();
        }
    }

    public void redoToMark() {
        this.redoLastMove();
        while (!this.fMovMrk[this.fMovNum] && this.fMovNum < this.fMovTop) {
            this.redoLastMove();
        }
    }

    public void undoLastMove() {
        this.noClue();
        if (this.fMovNum > 0) {
            int n = this.fSelCol;
            int n2 = this.fSelRow;
            int n3 = this.fSelLvl;
            this.fSelCol = -1;
            this.fTilCvs.tileMoved(n, n2, n3);
            int n4 = 0;
            while (n4 < 2) {
                --this.fMovNum;
                int n5 = this.fMovCol[this.fMovNum];
                int n6 = this.fMovRow[this.fMovNum];
                int n7 = this.fMovLvl[this.fMovNum];
                this.fTilIs[n5][n6][n7] = true;
                int[] nArray = this.fTilTop[n5];
                int n8 = n6;
                nArray[n8] = nArray[n8] + 1;
                int n9 = this.fTilSet[n5][n6][n7];
                this.fSetMch[n9] = this.fSetMch[n9] - 1;
                this.fTilCvs.tileMoved(n5, n6, n7);
                ++n4;
            }
            this.fTilCvs.playSound("undo.au");
            this.fTilApp.showStatus("Undone.");
            this.fTilCvs.playing();
            this.fTilCvs.repaint();
            return;
        }
        this.fTilCvs.playSound("invalid.au");
        this.fTilApp.showStatus("Nothing to undo.");
    }

    public void redoLastMove() {
        this.noClue();
        if (this.fMovNum < this.fMovTop) {
            int n = this.fMovCol[this.fMovNum];
            int n2 = this.fMovRow[this.fMovNum];
            int n3 = this.fMovLvl[this.fMovNum];
            this.fTilIs[n][n2][n3] = false;
            ++this.fMovNum;
            int[] nArray = this.fTilTop[n];
            int n4 = n2;
            nArray[n4] = nArray[n4] - 1;
            int n5 = this.fTilSet[n][n2][n3];
            this.fSetMch[n5] = this.fSetMch[n5] + 1;
            int n6 = this.fMovCol[this.fMovNum];
            int n7 = this.fMovRow[this.fMovNum];
            int n8 = this.fMovLvl[this.fMovNum];
            this.fTilIs[n6][n7][n8] = false;
            ++this.fMovNum;
            int[] nArray2 = this.fTilTop[n6];
            int n9 = n7;
            nArray2[n9] = nArray2[n9] - 1;
            int n10 = this.fTilSet[n6][n7][n8];
            this.fSetMch[n10] = this.fSetMch[n10] + 1;
            this.fSelCol = -1;
            this.fTilCvs.tilesRemoved(n, n2, n3, n6, n7, n8);
            this.fTilCvs.playSound("match.au");
            this.fTilApp.showStatus("A match.");
            this.checkDone();
            return;
        }
        this.fTilCvs.playSound("invalid.au");
        this.fTilApp.showStatus("No more matches to redo.");
    }

    public void restartGame(boolean bl) {
        this.fTilCvs.stopContinuous();
        this.noClue();
        while (this.fMovNum > 0) {
            --this.fMovNum;
            int[] nArray = this.fTilTop[this.fMovCol[this.fMovNum]];
            int n = this.fMovRow[this.fMovNum];
            nArray[n] = nArray[n] + 1;
            this.fTilIs[this.fMovCol[this.fMovNum]][this.fMovRow[this.fMovNum]][this.fMovLvl[this.fMovNum]] = true;
        }
        this.fSelCol = -1;
        int n = 0;
        while (n < this.fNumTil) {
            this.fSetMch[n] = 0;
            ++n;
        }
        this.fTilCvs.setNewGame();
        if (bl) {
            this.showLevel();
        } else {
            this.fTilApp.showStatus("Start again...");
        }
        this.fTilCvs.playing();
        this.fTilCvs.invalidateBuffer();
        this.fTilCvs.repaint();
        this.checkDone();
    }

    public void toggleAutoplay() {
        boolean bl = this.fAutPly = !this.fAutPly;
        if (this.fAutPly) {
            this.fTilCvs.playSound("clue.au");
            this.fTilApp.showStatus("Autoplay on.");
            this.findMoves();
            return;
        }
        this.fTilCvs.playSound("clue.au");
        this.fTilApp.showStatus("Autoplay off.");
    }

    public int getNumRow() {
        return this.fNumRow;
    }

    public int getNumCol() {
        return this.fNumCol;
    }

    public int getNumLvl() {
        return this.fNumLvl;
    }

    public int getNumTil() {
        return this.fNumTil;
    }

    public int getNumRnk() {
        return this.fNumRnk;
    }

    public int getTotTil() {
        return this.fTotTil;
    }

    public boolean isGameReady() {
        return this.fGamRdy;
    }

    public boolean isGameBegun() {
        return this.fGamBeg;
    }

    public boolean isTileThere(int n, int n2, int n3) {
        if (n < 0 || n >= this.fNumCol || n2 < 0 || n2 >= this.fNumRow || n3 < 0 || n3 >= this.fNumLvl) {
            return false;
        }
        return this.fTilIs[n][n2][n3];
    }

    public boolean isTileVisible(int n, int n2, int n3) {
        if (n < 0 || n >= this.fNumCol || n2 < 0 || n2 >= this.fNumRow || n3 < 0 || n3 >= this.fNumLvl) {
            return false;
        }
        if (this.isTileThere(n, n2, n3 + 1)) {
            return this.xOffset(n, n2, n3) != this.xOffset(n, n2, n3 + 1) || this.yOffset(n, n2, n3) != this.yOffset(n, n2, n3 + 1);
        }
        return true;
    }

    public boolean isSelected(int n, int n2, int n3) {
        return n == this.fSelCol && n2 == this.fSelRow && n3 == this.fSelLvl;
    }

    public boolean isHighlighted(int n, int n2, int n3) {
        if (this.fCluLvl == 0) {
            return false;
        }
        return this.fTilHiLit[n][n2][n3];
    }

    public boolean onBoard(int n, int n2, int n3) {
        return n >= 0 && n < this.fNumCol && n2 >= 0 && n2 < this.fNumRow && n3 >= 0 && n3 < this.fNumLvl;
    }

    public int xOffset(int n, int n2, int n3) {
        if (this.onBoard(n, n2, n3)) {
            return this.fTilXOff[n][n2][n3];
        }
        return 0;
    }

    public int yOffset(int n, int n2, int n3) {
        if (this.onBoard(n, n2, n3)) {
            return this.fTilYOff[n][n2][n3];
        }
        return 0;
    }

    public int getTileNumber(int n, int n2, int n3) {
        return this.fTilSet[n][n2][n3];
    }

    public int getTileRank(int n, int n2, int n3) {
        return this.fTilRnk[n][n2][n3];
    }

    public float getDrawRows() {
        return (float)this.fNumRow + (this.getTopOffset() + this.getBottomOffset());
    }

    public float getTopOffset() {
        float f = -0.5f;
        int n = 0;
        while (n < this.fNumCol) {
            int n2 = 0;
            while (n2 < this.fNumLvl) {
                if (this.fTilBeg[n][0][n2] && this.yOffset(n, 0, n2) == 0) {
                    f = 0.0f;
                }
                ++n2;
            }
            ++n;
        }
        return f;
    }

    public float getBottomOffset() {
        float f = 0.0f;
        int n = 0;
        while (n < this.fNumCol) {
            int n2 = 0;
            while (n2 < this.fNumLvl) {
                if (this.fTilBeg[n][this.fNumRow - 1][n2] && this.yOffset(n, this.fNumRow - 1, n2) > 0) {
                    f = 0.5f;
                }
                ++n2;
            }
            ++n;
        }
        return f;
    }

    public float getDrawColumns() {
        return (float)this.fNumCol + (this.getLeftOffset() + this.getRightOffset());
    }

    public float getLeftOffset() {
        float f = -0.5f;
        int n = 0;
        while (n < this.fNumRow) {
            int n2 = 0;
            while (n2 < this.fNumLvl) {
                if (this.fTilBeg[0][n][n2] && this.xOffset(0, n, n2) == 0) {
                    f = 0.0f;
                }
                ++n2;
            }
            ++n;
        }
        return f;
    }

    public float getRightOffset() {
        float f = 0.0f;
        int n = 0;
        while (n < this.fNumRow) {
            int n2 = 0;
            while (n2 < this.fNumLvl) {
                if (this.fTilBeg[this.fNumRow - 1][n][n2] && this.xOffset(this.fNumCol - 1, n, n2) > 0) {
                    f = 0.5f;
                }
                ++n2;
            }
            ++n;
        }
        return f;
    }

    public int getMaxTopLevel() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.fNumCol) {
            int n3 = n + 1;
            while (n3 < this.fNumLvl) {
                if (this.fTilBeg[n2][0][n3] && n3 > n) {
                    n = n3;
                }
                ++n3;
            }
            ++n2;
        }
        return n + 1;
    }

    public int getMaxRightLevel() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.fNumRow) {
            int n3 = n + 1;
            while (n3 < this.fNumLvl) {
                if (this.fTilBeg[this.fNumCol - 1][n2][n3] && n3 > n) {
                    n = n3;
                }
                ++n3;
            }
            ++n2;
        }
        return n + 1;
    }

    public static void version() {
        System.out.println("TileGame 0.0i");
    }

    static {
        kRgtOff = 13;
        kLvlOff = 4;
        kTotTil = 144;
        kNumTil = 36;
        kNumRnk = 4;
        kLftRgt = true;
    }
}

