/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Random;

public class TileImageEffector
extends Thread {
    TileMatch fTilApp;
    int fObjID;

    public TileImageEffector(TileMatch tileMatch, int n) {
        super("loaders");
        this.fTilApp = tileMatch;
        this.fObjID = n;
        this.start();
    }

    public void destroy() {
        this.fTilApp = null;
    }

    public Image effectTileImage(Image image, int n, Color color) {
        if (image == null) {
            return null;
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        int[] nArray = this.fTilApp.getTileAnimator().getPixelArray(this.fObjID);
        if (nArray == null || nArray.length < n2 * n3) {
            nArray = this.grabPixels(image, n2, n3);
            if (nArray == null) {
                return null;
            }
            this.fTilApp.getTileAnimator().setPixelArray(this.fObjID, nArray);
        }
        switch (this.fTilApp.getTileAnimator().getObjectEffect(this.fObjID)) {
            case 2: {
                nArray = this.fadeImage(nArray, n);
                break;
            }
            case 5: {
                nArray = this.twinkleImage(nArray, n, color);
                break;
            }
            case 1: {
                nArray = this.dissolveImage(nArray, n);
                break;
            }
            case 3: {
                nArray = this.waverImage(nArray, n, n2);
                break;
            }
        }
        if (nArray.length < n2 * n3) {
            return null;
        }
        Image image2 = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, nArray, 0, n2));
        Toolkit.getDefaultToolkit().prepareImage(image2, n2, n3, null);
        if (!this.waitForImage(image2)) {
            return null;
        }
        return image2;
    }

    public int[] grabPixels(Image image, int n, int n2) {
        int n3 = n * n2;
        int[] nArray = new int[n3];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if ((pixelGrabber.status() & 0x40) != 0) {
            return null;
        }
        return nArray;
    }

    public int[] fadeImage(int[] nArray, int n) {
        int n2 = (this.fTilApp.getTileAnimator().getMaxStep() - n) * 255 / this.fTilApp.getTileAnimator().getMaxStep();
        n2 <<= 24;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (nArray[n4] & 0xFF000000) >> 24;
            if (n5 != 0) {
                nArray[n4] = nArray[n4] & 0xFFFFFF | n2;
            }
            ++n4;
        }
        return nArray;
    }

    public int[] twinkleImage(int[] nArray, int n, Color color) {
        int n2;
        int n3 = this.fTilApp.getTileAnimator().getMaxStep();
        int n4 = this.fTilApp.getTileAnimator().getEffectParmOne();
        int n5 = this.fTilApp.getTileAnimator().getEffectParmTwo();
        if (n5 > n3) {
            n5 = n3;
        }
        if (n4 > n5) {
            n2 = n4;
            n4 = n5;
            n5 = n2;
        }
        int[] nArray2 = new int[n5];
        Color color2 = color;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n4 - 1 - n6] = color2.getRGB();
            color2 = color2.darker();
            ++n6;
        }
        n6 = n4;
        while (n6 < n5) {
            nArray2[n6] = ((n5 - n6) * 255 / (n5 - n4) << 24) + color.getRGB();
            ++n6;
        }
        Random random = new Random(1234L);
        int n7 = nArray.length;
        int n8 = 0;
        while (n8 < n7) {
            int n9;
            n2 = (nArray[n8] & 0xFF000000) >> 24;
            if (n2 != 0 && (n6 = n - (n9 = n3 > n5 ? Math.abs(random.nextInt()) % (n3 - n5) : 0)) >= 0) {
                nArray[n8] = n6 < n5 ? nArray2[n6] : 0;
            }
            ++n8;
        }
        return nArray;
    }

    public int[] dissolveImage(int[] nArray, int n) {
        int n2 = this.fTilApp.getTileAnimator().getMaxStep();
        int n3 = this.fTilApp.getTileAnimator().getEffectParmOne();
        this.fTilApp.getTileAnimator().getEffectParmTwo();
        if (n3 > n2) {
            n3 = n2;
        }
        int[] nArray2 = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray2[n4] = (n3 - n4) * 255 / n3 << 24;
            ++n4;
        }
        Random random = new Random(1234L);
        int n5 = nArray.length;
        int n6 = 0;
        while (n6 < n5) {
            int n7;
            int n8 = (nArray[n6] & 0xFF000000) >> 24;
            if (n8 != 0 && (n4 = n - (n7 = Math.abs(random.nextInt()) % (n2 - n3))) >= 0) {
                nArray[n6] = n4 < n3 ? nArray[n6] & 0xFFFFFF | nArray2[n4] : 0;
            }
            ++n6;
        }
        return nArray;
    }

    public int[] waverImage(int[] nArray, int n, int n2) {
        int n3 = this.fTilApp.getTileAnimator().getMaxStep();
        int n4 = this.fTilApp.getTileAnimator().getEffectParmOne();
        int n5 = this.fTilApp.getTileAnimator().getEffectParmTwo();
        if (n5 + n4 > n3) {
            if (n4 < n3) {
                n5 = n3 - n4;
            } else if (n5 < n3) {
                n4 = n3 - n4;
            } else {
                n5 = n3;
            }
        }
        if (n5 <= 0) {
            n5 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        int[] nArray2 = new int[n5 + 1];
        int n6 = 0;
        while (n6 < n5) {
            nArray2[n6] = (n5 - n6) * 255 / n5 << 24;
            ++n6;
        }
        int n7 = nArray.length;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n7) {
            int n10 = (nArray[n9] & 0xFF000000) >> 24;
            if (n10 != 0) {
                n8 = (n9 / n2 + n) % (n4 * 2 - 1);
                if (n8 >= n4) {
                    n8 = n4 * 2 - 1 - n8;
                }
                if (n4 > n5) {
                    n8 /= n4 / n5;
                }
                if ((n8 = n8 + n - n4) > n5) {
                    n8 = n5;
                }
                if (n8 < 0) {
                    n8 = 0;
                }
                nArray[n9] = nArray[n9] & 0xFFFFFF | nArray2[n8];
            }
            ++n9;
        }
        return nArray;
    }

    public boolean waitForImage(Image image) {
        MediaTracker mediaTracker = new MediaTracker(this.fTilApp.getTileCanvas());
        this.fTilApp.getTileCanvas().prepareImage(image, null);
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            this.fTilApp.ohNo("Interrupted creating tile image");
            return false;
        }
        return true;
    }

    public void run() {
        Image image = this.effectTileImage(this.fTilApp.getTileAnimator().getTileImage(this.fObjID), this.fTilApp.getTileAnimator().getEffectStep(this.fObjID), this.fTilApp.getTileAnimator().getEffectColor(this.fObjID));
        this.fTilApp.getTileAnimator().setNewImage(this.fObjID, image);
        this.fTilApp = null;
    }

    public static void version() {
        System.out.println("TileImageEffector 0.0g");
    }
}

