/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class TileImageMaker
extends Thread {
    TileMatch fTilApp;
    int fObjNum;

    public TileImageMaker(TileMatch tileMatch, int n) {
        super("loaders");
        this.fTilApp = tileMatch;
        this.fObjNum = n;
        this.start();
    }

    public void destroy() {
        this.fTilApp = null;
    }

    public Image makeTileImage(Image image, int n, int n2) {
        int n3 = this.fTilApp.getTileCanvas().getTileImageWidth();
        int n4 = this.fTilApp.getTileCanvas().getTileImageHeight();
        Image image2 = this.fTilApp.getTileCanvas().createImage(n3, n4);
        if (!this.waitForImage(image2)) {
            return null;
        }
        Graphics graphics = image2.getGraphics();
        graphics.setColor(Color.gray);
        graphics.fillRect(0, 0, n3, n4);
        this.fTilApp.getTileCanvas().drawTile(graphics, image, this.fTilApp.getTileCanvas().getBorderWidth(), 0, this.fTilApp.getTileCanvas().getTileWidth(), this.fTilApp.getTileCanvas().getTileHeight(), n, n2, Color.red, false);
        if (!this.waitForImage(image2)) {
            return null;
        }
        int n5 = n3 * n4;
        int[] nArray = new int[n5];
        PixelGrabber pixelGrabber = new PixelGrabber(image2, 0, 0, n3, n4, nArray, 0, n3);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            this.fTilApp.ohNo("Error creating tile image (white)");
            return null;
        }
        if ((pixelGrabber.status() & 0x40) != 0) {
            this.fTilApp.ohNo("Error " + Integer.toString(pixelGrabber.status()) + " creating tile image (white)");
            return null;
        }
        Image image3 = this.fTilApp.getTileCanvas().createImage(n3, n4);
        if (!this.waitForImage(image3)) {
            return null;
        }
        Graphics graphics2 = image3.getGraphics();
        graphics2.setColor(Color.black);
        graphics2.fillRect(0, 0, n3, n4);
        this.fTilApp.getTileCanvas().drawTile(graphics2, image, this.fTilApp.getTileCanvas().getBorderWidth(), 0, this.fTilApp.getTileCanvas().getTileWidth(), this.fTilApp.getTileCanvas().getTileHeight(), n, n2, Color.blue, false);
        if (!this.waitForImage(image3)) {
            return null;
        }
        int[] nArray2 = new int[n5];
        PixelGrabber pixelGrabber2 = new PixelGrabber(image3, 0, 0, n3, n4, nArray2, 0, n3);
        try {
            pixelGrabber2.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            this.fTilApp.ohNo("Interrupted creating tile image (black)");
            return null;
        }
        if ((pixelGrabber2.status() & 0x40) != 0) {
            this.fTilApp.ohNo("Error " + Integer.toString(pixelGrabber2.status()) + " creating tile image (black)");
            return null;
        }
        int n6 = Color.black.getRGB() | 0xFF000000;
        int n7 = Color.gray.getRGB() | 0xFF000000;
        int n8 = 0;
        while (n8 < n5) {
            if (nArray2[n8] == n6 && nArray[n8] == n7) {
                nArray[n8] = 0;
            }
            ++n8;
        }
        Image image4 = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
        if (!this.waitForImage(image4)) {
            return null;
        }
        return image4;
    }

    public boolean waitForImage(Image image) {
        MediaTracker mediaTracker = new MediaTracker(this.fTilApp.getTileCanvas());
        this.fTilApp.getTileCanvas().prepareImage(image, null);
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            this.fTilApp.ohNo("Interrupted creating tile image");
            return false;
        }
        return true;
    }

    public void run() {
        Image image = this.makeTileImage(this.fTilApp.getTileAnimator().getBaseImage(this.fObjNum), -1, -1);
        this.fTilApp.getTileAnimator().setTileImage(this.fObjNum, image);
        this.fTilApp = null;
    }

    public static void version() {
        System.out.println("TileImageMaker 0.0g");
    }
}

