/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;

public class TileLoader
extends Thread {
    static final int kLodPatImg = 1;
    static final int kLodBckImg = 2;
    static final int kLodTilImg = 4;
    static final int kTrmTilImg = 8;
    static final int kCreSdwImg = 16;
    static final int kLodBonImg = 32;
    static final int kLodZomImg = 64;
    static final int kSclZomImg = 128;
    TileMatch fTilApp;
    TileLoadMgr fLodMgr;
    int fLodTyp;
    int fTilNum;
    int fRnkNum;
    URL fURL;
    Toolkit fKit = Toolkit.getDefaultToolkit();
    boolean fWait = true;
    String fLodNam = "";

    public TileLoader(int n, int n2, int n3, URL uRL, TileLoadMgr tileLoadMgr, TileMatch tileMatch) {
        super("loaders");
        this.fLodMgr = tileLoadMgr;
        this.fTilApp = tileMatch;
        this.fLodTyp = n;
        this.fTilNum = n2;
        this.fRnkNum = n3;
        this.fURL = uRL;
        this.start();
    }

    public void freeManagers() {
        this.fLodMgr = null;
        this.fTilApp = null;
    }

    public void run() {
        if (this.fLodTyp == 16) {
            this.createShadow();
        } else if (this.fLodTyp == 8) {
            this.trimTile();
        } else if (this.fLodTyp == 128) {
            this.scaleImage();
        } else {
            this.loadImage();
        }
        if (this.fLodMgr != null && this.fLodMgr.isAlive()) {
            TileLoadMgr tileLoadMgr = this.fLodMgr;
            synchronized (tileLoadMgr) {
                this.fLodMgr.notify();
            }
        }
        this.freeManagers();
    }

    public void createShadow() {
        this.fTilApp.showStatus("Creating shadow...");
        int n = this.fTilApp.getTileCanvas().getTileWidth() + 2;
        int n2 = this.fTilApp.getTileCanvas().getTileHeight() + 2;
        int[] nArray = new int[n * n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n3 + n4 * n;
                int n6 = Integer.MIN_VALUE;
                if (n3 < 2 || n3 > n - 2 || n4 < 2 || n4 > n2 - 2) {
                    n6 = 0x40000000;
                }
                if (n3 < 1 || n3 > n - 1 || n4 < 1 || n4 > n2 - 1) {
                    n6 = 0x20000000;
                }
                nArray[n5] = n6;
                ++n4;
            }
            ++n3;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        if (!this.waitForImage(image, "Shadow")) {
            image = null;
        }
        this.fLodMgr.finishImage(image, this.fLodTyp, this.fTilNum, this.fRnkNum);
    }

    public void loadImage() {
        int n;
        String string;
        URL uRL = null;
        if (this.fLodTyp == 1) {
            this.fTilApp.showStatus("Loading Pattern...");
            string = String.valueOf(this.fTilApp.getBackgroundFolder()) + "Pattern";
        } else if (this.fLodTyp == 2) {
            this.fTilApp.showStatus("Loading Background " + Integer.toString(this.fTilNum + 1) + "...");
            string = String.valueOf(this.fTilApp.getBackgroundFolder()) + this.fTilApp.getBackgroundName(this.fTilApp.getTileGame().getGameLevel(), this.fTilApp.getTileGame().getLayoutName());
        } else if (this.fLodTyp == 4) {
            n = this.fTilApp.getTileCanvas().getTileSetNum(this.fTilNum);
            if (n < this.fTilApp.getMinRankSet(this.fRnkNum) || n > this.fTilApp.getMaxRankSet(this.fRnkNum)) {
                this.fLodMgr.finishImage(null, this.fLodTyp, this.fTilNum, this.fRnkNum);
                this.fWait = false;
                return;
            }
            this.fTilApp.showStatus("Loading tile: " + Integer.toString(this.fTilNum) + "." + Integer.toString(this.fRnkNum) + "...");
            string = String.valueOf(this.fTilApp.getTileFolder()) + this.fTilApp.getTilePrefix() + Integer.toString(n + this.fTilApp.getTileBase()) + this.fTilApp.getTileInfix() + Integer.toString(this.fRnkNum + this.fTilApp.getRankBase()) + this.fTilApp.getTileSuffix();
        } else if (this.fLodTyp == 32) {
            String string2;
            n = this.fTilApp.getTileCanvas().getTileSetNum(this.fTilNum);
            this.fTilApp.showStatus("Loading bonus: " + Integer.toString(this.fTilNum) + "...");
            if (this.fTilApp.getBonusType().equalsIgnoreCase("tile")) {
                string2 = Integer.toString(this.fRnkNum + this.fTilApp.getRankBase());
            } else {
                string2 = "";
                this.fRnkNum = 0;
            }
            string = String.valueOf(this.fTilApp.getBonusFolder()) + this.fTilApp.getBonusPrefix() + Integer.toString(n + this.fTilApp.getTileBase()) + this.fTilApp.getBonusInfix() + string2 + this.fTilApp.getBonusSuffix();
        } else if (this.fLodTyp == 64) {
            String string3;
            n = this.fTilApp.getTileCanvas().getTileSetNum(this.fTilNum);
            this.fTilApp.showStatus("Loading zoom: " + Integer.toString(this.fTilNum) + "...");
            if (this.fTilApp.getZoomType().equalsIgnoreCase("tile")) {
                string3 = Integer.toString(this.fRnkNum + this.fTilApp.getRankBase());
            } else {
                string3 = "";
                this.fRnkNum = 0;
            }
            string = String.valueOf(this.fTilApp.getZoomFolder()) + this.fTilApp.getZoomPrefix() + Integer.toString(n + this.fTilApp.getTileBase()) + this.fTilApp.getZoomInfix() + string3 + this.fTilApp.getZoomSuffix();
        } else {
            this.fLodMgr.finishImage(null, this.fLodTyp, this.fTilNum, this.fRnkNum);
            this.fWait = false;
            return;
        }
        this.fLodNam = string;
        try {
            uRL = new URL(this.fURL, string);
        }
        catch (MalformedURLException malformedURLException) {
            this.fTilApp.ohNo("TileMatch: Bad URL");
            this.fLodMgr.finishImage(null, this.fLodTyp, this.fTilNum, this.fRnkNum);
            this.fWait = false;
        }
        if (uRL != null) {
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            if (image != null) {
                if (!this.waitForImage(image, this.fLodNam)) {
                    image = null;
                }
                this.fLodMgr.finishImage(image, this.fLodTyp, this.fTilNum, this.fRnkNum);
                return;
            }
            this.fLodMgr.finishImage(null, this.fLodTyp, this.fTilNum, this.fRnkNum);
            this.fWait = false;
            return;
        }
        this.fLodMgr.finishImage(null, this.fLodTyp, this.fTilNum, this.fRnkNum);
        this.fWait = false;
    }

    public void trimTile() {
        String string = "Tile." + Integer.toString(this.fTilNum) + "." + Integer.toString(this.fRnkNum);
        this.fTilApp.showStatus("Trimming tile " + string + "...");
        Image image = this.fTilApp.getTileCanvas().getTileImage(this.fTilNum, this.fRnkNum);
        int n = this.fLodMgr.getTileTrim();
        if (image == null) {
            this.fLodMgr.finishImage(null, this.fLodTyp, this.fTilNum, this.fRnkNum);
            this.fWait = false;
            return;
        }
        if (n == 0 || this.fTilApp.getPretrim()) {
            this.fLodMgr.finishImage(image, this.fLodTyp, this.fTilNum, this.fRnkNum);
            this.fWait = false;
            return;
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        int n4 = n2 * n3;
        int[] nArray = new int[n4];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n2, n3, nArray, 0, n2);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            this.fTilApp.ohNo("Error getting pixels to trim " + string);
            this.fLodMgr.finishImage(image, this.fLodTyp, this.fTilNum, this.fRnkNum);
            this.fWait = false;
            return;
        }
        if ((pixelGrabber.status() & 0x40) != 0) {
            this.fTilApp.ohNo("Error " + Integer.toString(pixelGrabber.status()) + " trimming " + string);
            this.fLodMgr.finishImage(image, this.fLodTyp, this.fTilNum, this.fRnkNum);
            this.fWait = false;
            return;
        }
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n - n5) {
                int n7 = n5 * n2 + n6;
                nArray[n7] = 0xFFFFFF;
                n7 = (n3 - 1 - n5) * n2 + n6;
                nArray[n7] = 0xFFFFFF;
                n7 = n5 * n2 + (n2 - 1 - n6);
                nArray[n7] = 0xFFFFFF;
                n7 = (n3 - 1 - n5) * n2 + (n2 - 1 - n6);
                nArray[n7] = 0xFFFFFF;
                ++n6;
            }
            ++n5;
        }
        Image image2 = this.fTilApp.getTileCanvas().fNumPltBit <= 8 ? this.fTilApp.getTileCanvas().fPltMgr.convertToIndexed(nArray, n2, n3) : Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, nArray, 0, n2));
        if (!this.waitForImage(image2, n2, n3, string)) {
            image2 = null;
        }
        this.fLodMgr.finishImage(image2, this.fLodTyp, this.fTilNum, this.fRnkNum);
        image.flush();
    }

    public void scaleImage() {
        Image image = this.fLodMgr.getZoomImage();
        int n = (int)((float)image.getWidth(null) * this.fTilApp.getZoomFactor());
        int n2 = (int)((float)image.getHeight(null) * this.fTilApp.getZoomFactor());
        if (n != 0 && n2 != 0) {
            this.fLodMgr.setZoomDimensions(n, n2);
            Image image2 = image.getScaledInstance(n, n2, 4);
            if (!this.waitForImage(image2, "Scaled Zoom")) {
                image2 = null;
            }
            this.fLodMgr.finishImage(image2, this.fLodTyp, this.fTilNum, this.fRnkNum);
        }
    }

    public boolean waitForImage(Image image, String string) {
        MediaTracker mediaTracker = new MediaTracker(this.fTilApp.getTileCanvas());
        this.fTilApp.getTileCanvas().prepareImage(image, null);
        return this.mediaTrackerWait(mediaTracker, image, string);
    }

    public boolean waitForImage(Image image, int n, int n2, String string) {
        MediaTracker mediaTracker = new MediaTracker(this.fTilApp.getTileCanvas());
        this.fTilApp.getTileCanvas().prepareImage(image, n, n2, null);
        return this.mediaTrackerWait(mediaTracker, image, string);
    }

    public boolean mediaTrackerWait(MediaTracker mediaTracker, Image image, String string) {
        mediaTracker.addImage(image, 1);
        while ((mediaTracker.statusAll(true) & 0x28) == 0) {
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                this.fTilApp.ohNo("Interrupted creating image " + string);
                return false;
            }
            if (!mediaTracker.isErrorID(1)) continue;
            if (this.fLodTyp != 4 || this.fRnkNum == 0) {
                this.fTilApp.ohNo("Error preparing image " + string);
            }
            return false;
        }
        return true;
    }

    public static void version() {
        System.out.println("TileLoader 0.0k");
    }
}

