/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import java.util.StringTokenizer;

public class TileMatch
extends Applet {
    static final String kCopyright = "Program Copyright 1998 by Robert N. Lacatena.  All rights reserved.";
    static final String kGamePanel = "Game";
    static final String kHelpPanel = "Help";
    static final String kOptionsPanel = "Options";
    static final String kOhNoPanel = "OhNo";
    static final String kSharePanel = "Shareware";
    static final int kLvl = 0;
    static final int kLayOut = 1;
    static final int kRnd = 2;
    CardLayout fCrdLayOut = new CardLayout(0, 0);
    CardLayout fFrmLayOut = new CardLayout(0, 0);
    Panel fHlpPnl;
    Panel fOptPnl;
    Panel fOhNoPnl;
    TileGame fTilGam;
    TileMatchBuffer fTilCvs;
    BufferedCanvas fCurCvs;
    Scrollbar fHlpBar = new Scrollbar(1);
    Scrollbar fOhNoBar = new Scrollbar(1);
    TileTextCanvas fHlpTxt;
    TileOhNoCanvas fOhNoCvs;
    TileFrame fAppFrm;
    TileFrame fShrFrm;
    Checkbox fSndOptBox;
    Checkbox fEffOptBox;
    Checkbox fMscOptBox;
    Checkbox fPerOptBox;
    Checkbox fSdwOptBox;
    Checkbox fSwpTilOptBox;
    Checkbox fSwpBckOptBox;
    Checkbox fBonOptBox;
    Checkbox fZomOptBox;
    CheckboxGroup fLvlGrp;
    Checkbox[] fLvlBox;
    CheckboxGroup fSetGrp;
    Checkbox[] fSetBox;
    CheckboxGroup fLayOutGrp;
    Checkbox[] fLayOutBox;
    Label fMemTotTxt;
    Label fMemFreTxt;
    Label fMemUseTxt;
    Button fOKBtn;
    Button fRstBtn;
    Button fCanBtn;
    Button fNewBtn;
    boolean fClkBckToGam = false;
    int fGamWid;
    int fGamHgt;
    Color fOptClr = Color.red;
    String fWinMsg = "Congratulations";
    Color fWinClr = Color.red;
    int fWinTop = 50;
    int fWinLft = 50;
    String fWinFnt = "Serif";
    int fWinSiz = 32;
    String fLosMsg = "No More Legal Moves";
    Color fLosClr = Color.red;
    int fLosTop = 180;
    int fLosLft = 140;
    String fLosFnt = "Serif";
    int fLosSiz = 32;
    Color fFrmClr = Color.white;
    Color fBdrClr = Color.gray;
    Color fHiLitClr = Color.yellow;
    Color fBckClr = Color.black;
    int fTotSet = 36;
    int fMaxPerSet = 4;
    int fPlySet = 36;
    int fPlyPerSet = 4;
    int fSetSwp = 36;
    int fTilTrm = 4;
    int fSidHgt = 6;
    int fMinLvl = 1;
    int fMaxLvl = 4;
    int fIniLvl = 1;
    int fIniSet = 1;
    int fTilBas = 1;
    int fRnkBas = 1;
    int fBckBas = 1;
    int fPerBas = 1;
    boolean fLftRgt = true;
    boolean fPreTrm = false;
    String fRemEff = "Fly";
    int fEffSlpTim = 10;
    int fMaxEff = 10;
    int fEffStp = 15;
    int fEffPrmOne = 5;
    int fEffPrmTwo = 10;
    float fEffPrmThr = 0.5f;
    boolean fSndOpt = true;
    boolean fEffOpt = true;
    boolean fMscOpt = true;
    boolean fPerOpt = true;
    boolean fSdwOpt = true;
    boolean fSwpTilOpt = true;
    boolean fSwpBckOpt = true;
    boolean fBonOpt = true;
    boolean fZomOpt = true;
    boolean fSndAlw = true;
    boolean fEffAlw = true;
    boolean fMscAlw = true;
    boolean fPerAlw = true;
    boolean fSdwAlw = true;
    boolean fSwpTilAlw = true;
    boolean fSwpBckAlw = true;
    boolean fBonAlw = true;
    boolean fZomAlw = true;
    int fCluCrd;
    String fTilPre = "Tile.";
    String fTilIn = ".";
    String fTilSuf = "";
    String fBonPre = "Tile.";
    String fBonIn = "";
    String fBonSuf = ".big";
    String fZomPre = "Tile.";
    String fZomIn = "";
    String fZomSuf = ".zoom";
    String fBckPre = "Background.";
    String fBckIn = "";
    String fBckSuf = "";
    String fTilFld = "Tiles";
    String fBckFld = "Backs";
    String fSndFld = "Sounds";
    String fBonFld = "Bonuses";
    String fZomFld = "Zooms";
    String fCtlFld = "Controls";
    String fXtrFld = "";
    String fBrdLayOutLst = "Standard,Bridge,Room,Towers,Castle,Chinese Castle,Arched Bridge,Glyph,Cube,Compact,Pyramid,Luck Box,Child";
    String[] fBrdLayOut;
    int fNumBrdLayOut;
    String fBonCtl = "None";
    String fBonTyp = "Set";
    int fSldShwTim = 5;
    String fZomTyp = "Set";
    float fZomFac = 1.0f;
    String fImgCpyRgt = "Ownership of any images presented is neither expressed nor implied.";
    String fNewGamMsg = "Select a tile.";
    String[] fBonCpt;
    int fNumBckCmp = 1;
    int[] fBckCmpLst = new int[]{0, 0, 0};
    int[][] fBckRndCnt;
    int fPerTim = 20;
    int fPerCnt = 2;
    boolean fPreLodSnd = true;
    boolean fOptFlp = false;
    String fSerNum;
    String fRegSitNam;
    int fNumPltBit = 24;
    String fFrmTtl = "Mi Ni Pai";
    boolean fFrmOpt = false;
    String fDlm = "/";
    int fCptTop = -10;
    int fCptLft = -1;
    Color fCptClr = Color.white;
    Color fCptBckClr = Color.black;
    int fCptSiz = 12;
    String fCptFnt = "Dialog";
    String fWinURL;
    String fWinTgt;
    String fLosURL;
    String fLosTgt;
    int fFrmWid = 1;
    boolean fFrmIns = true;
    int fFrmFad;
    int fWinRat = -1;
    boolean fMgkMod = false;
    int[] fMinRnkSet;
    int[] fMaxRnkSet;

    public void start() {
        this.restartThreads();
        if (this.fTilCvs != null) {
            this.fTilCvs.requestFocus();
        }
        super.start();
    }

    public void stop() {
        this.suspendThreads();
        super.stop();
    }

    public void destroy() {
        if (this.fTilCvs != null) {
            this.fTilCvs.destroy();
        }
        this.fTilCvs = null;
        this.fHlpPnl = null;
        this.fOptPnl = null;
        this.fOhNoPnl = null;
        System.gc();
        super.destroy();
    }

    public void restartThreads() {
        if (this.fTilCvs != null) {
            this.fTilCvs.restartThreads();
        }
    }

    public void suspendThreads() {
        if (this.fTilCvs != null) {
            this.fTilCvs.suspendThreads();
        }
    }

    public void init() {
        this.fCrdLayOut = new CardLayout(0, 0);
        this.setLayout(this.fCrdLayOut);
        this.fCrdLayOut.layoutContainer(this);
        this.addOhNoText();
        this.loadParms();
        this.addHelpText();
        this.addOptionsPanel();
        this.fTilGam = new TileGame(this);
        this.fTilCvs = new TileMatchBuffer(this, this.fTilGam);
        this.add(kGamePanel, this.fTilCvs);
        if (this.fOhNoCvs.getLines() > 0) {
            this.showCard(kOhNoPanel);
        } else {
            this.showCard(kGamePanel);
        }
        if (this.registryOkay()) {
            this.fTilGam.setBuffer(this.fTilCvs);
            this.fTilGam.newGame();
            if (this.fFrmOpt) {
                this.useFrame();
            }
        }
        if (this.getCodeBase().toString().startsWith("file:")) {
            this.sharewareFrame();
            return;
        }
        if (this.fTilCvs != null) {
            this.fTilCvs.requestFocus();
        }
    }

    public void sharewareFrame() {
        CenterCanvas centerCanvas = new CenterCanvas(this, 461, 289);
        this.fShrFrm = new TileFrame(this, "Mi Ni Pai is Shareware!");
        this.fShrFrm.resize(461, 289);
        this.fShrFrm.add(centerCanvas);
        this.fShrFrm.show();
    }

    public void useFrame() {
        if (this.fAppFrm != null) {
            return;
        }
        this.fAppFrm = new TileFrame(this, this.fFrmTtl);
        this.fAppFrm.setCursor(12);
        this.fAppFrm.resize(this.fGamWid, this.fGamHgt);
        this.fFrmLayOut = new CardLayout(0, 0);
        this.fAppFrm.setLayout(this.fFrmLayOut);
        this.fFrmLayOut.layoutContainer(this.fAppFrm);
        this.fAppFrm.add(kGamePanel, this.fTilCvs);
        this.fAppFrm.add(kHelpPanel, this.fHlpPnl);
        this.fAppFrm.add(kOptionsPanel, this.fOptPnl);
        this.fAppFrm.add(kOhNoPanel, this.fOhNoPnl);
        this.fFrmLayOut.show(this.fAppFrm, kGamePanel);
        this.fAppFrm.show();
        this.removeAll();
        this.setLayout(new BorderLayout(0, 0));
        this.add(new PatternCanvas(this));
    }

    public void removeFrame(TileFrame tileFrame) {
        if (tileFrame == this.fAppFrm) {
            this.removeFrame();
            return;
        }
        if (tileFrame == this.fShrFrm) {
            ((Component)this.fShrFrm).hide();
            this.fShrFrm.dispose();
            this.fShrFrm = null;
        }
    }

    public void removeFrame() {
        if (this.fAppFrm == null) {
            return;
        }
        ((Component)this.fAppFrm).hide();
        this.removeAll();
        this.setLayout(this.fCrdLayOut);
        this.fCrdLayOut.layoutContainer(this);
        this.add(kGamePanel, this.fTilCvs);
        this.add(kHelpPanel, this.fHlpPnl);
        this.add(kOptionsPanel, this.fOptPnl);
        this.add(kOhNoPanel, this.fOhNoPnl);
        this.fCrdLayOut.show(this, kGamePanel);
        this.fAppFrm.dispose();
        this.fAppFrm = null;
    }

    public void addHelpText() {
        this.fHlpPnl = new Panel();
        ((Component)this.fHlpPnl).setFont(new Font("Helvetica", 0, 12));
        this.fHlpPnl.setBackground(this.fBckClr);
        this.fHlpPnl.setForeground(this.fOptClr);
        this.fHlpPnl.setLayout(new BorderLayout(10, 10));
        this.fHlpTxt = new TileTextCanvas(this, String.valueOf(this.fXtrFld) + "HelpText");
        this.fHlpPnl.add("Center", this.fHlpTxt);
        this.fHlpPnl.add("East", this.fHlpBar);
        this.setHelpBar();
        this.add(kHelpPanel, this.fHlpPnl);
    }

    public void addOhNoText() {
        this.fOhNoPnl = new Panel();
        ((Component)this.fOhNoPnl).setFont(new Font("Helvetica", 0, 12));
        this.fOhNoPnl.setBackground(Color.black);
        this.fOhNoPnl.setForeground(Color.red);
        this.fOhNoPnl.setLayout(new BorderLayout(10, 10));
        this.fOhNoCvs = new TileOhNoCanvas(this);
        this.fOhNoPnl.add("Center", this.fOhNoCvs);
        this.fOhNoPnl.add("East", this.fOhNoBar);
        this.setOhNoBar();
        this.add(kOhNoPanel, this.fOhNoPnl);
    }

    public void addOptionsPanel() {
        Object object;
        int n;
        Label label;
        Panel panel;
        this.fOptPnl = new Panel();
        ((Component)this.fOptPnl).setFont(new Font("Helvetica", 0, 12));
        if (this.fOptFlp) {
            this.fOptPnl.setBackground(this.fOptClr);
            this.fOptPnl.setForeground(this.fBckClr);
        } else {
            this.fOptPnl.setBackground(this.fBckClr);
            this.fOptPnl.setForeground(this.fOptClr);
        }
        this.fOptPnl.setLayout(new BorderLayout(10, 10));
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        Label label2 = new Label("Game Options");
        label2.setFont(new Font(this.fWinFnt, 0, 24));
        panel2.add(label2);
        this.fOptPnl.add("North", panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout());
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(9, 1));
        this.fSndOptBox = new Checkbox("Sound");
        this.fMscOptBox = new Checkbox("Music");
        this.fPerOptBox = new Checkbox("Periodic Sounds");
        this.fEffOptBox = new Checkbox("Effects");
        this.fSdwOptBox = new Checkbox("Shadows");
        this.fBonOptBox = new Checkbox("Bonus Images");
        this.fZomOptBox = new Checkbox("Zoom Images");
        this.fSwpTilOptBox = new Checkbox("Swap Tiles");
        this.fSwpBckOptBox = new Checkbox("Swap Backgrounds");
        this.fSndOptBox.setState(this.fSndOpt);
        this.fMscOptBox.setState(this.fMscOpt);
        this.fPerOptBox.setState(this.fPerOpt);
        this.fEffOptBox.setState(this.fEffOpt);
        this.fBonOptBox.setState(this.fBonOpt);
        this.fZomOptBox.setState(this.fZomOpt);
        this.fSdwOptBox.setState(this.fSdwOpt);
        this.fSwpTilOptBox.setState(this.fSwpTilOpt);
        this.fSwpBckOptBox.setState(this.fSwpBckOpt);
        if (!this.fSndAlw) {
            this.fSndOptBox.disable();
        }
        if (!this.fMscAlw) {
            this.fMscOptBox.disable();
        }
        if (!this.fPerAlw) {
            this.fPerOptBox.disable();
        }
        if (!this.fEffAlw) {
            this.fEffOptBox.disable();
        }
        if (!this.fSdwAlw) {
            this.fSdwOptBox.disable();
        }
        if (!this.fBonAlw) {
            this.fBonOptBox.disable();
        }
        if (!this.fZomAlw) {
            this.fZomOptBox.disable();
        }
        if (!this.fSwpTilAlw) {
            this.fSwpTilOptBox.disable();
        }
        if (!this.fSwpBckAlw) {
            this.fSwpBckOptBox.disable();
        }
        if (this.fTotSet <= this.fPlySet || this.fSetSwp == 0) {
            this.fSwpTilOptBox.disable();
        }
        panel4.add(this.fSndOptBox);
        panel4.add(this.fMscOptBox);
        panel4.add(this.fPerOptBox);
        panel4.add(this.fEffOptBox);
        panel4.add(this.fBonOptBox);
        panel4.add(this.fZomOptBox);
        panel4.add(this.fSdwOptBox);
        panel4.add(this.fSwpTilOptBox);
        panel4.add(this.fSwpBckOptBox);
        panel3.add(panel4);
        if (this.fMaxLvl > this.fMinLvl) {
            panel = new Panel();
            panel.setLayout(new GridLayout(this.fMaxLvl - this.fMinLvl + 2, 1));
            this.fLvlGrp = new CheckboxGroup();
            label = new Label("Game Level");
            panel.add(label);
            this.fLvlBox = new Checkbox[this.fMaxLvl + 1];
            n = this.fMinLvl;
            while (n <= this.fMaxLvl) {
                object = "Level " + String.valueOf(n);
                this.fLvlBox[n] = new Checkbox((String)object, this.fLvlGrp, n == this.fIniLvl);
                panel.add(this.fLvlBox[n]);
                ++n;
            }
            panel3.add(panel);
        }
        if (this.fNumBrdLayOut > 1) {
            panel = new Panel();
            if (this.fNumBrdLayOut < 8) {
                panel.setLayout(new GridLayout(this.fNumBrdLayOut + 1, 1));
            } else {
                panel.setLayout(new GridLayout((this.fNumBrdLayOut + 1) / 2, 2));
            }
            this.fLayOutGrp = new CheckboxGroup();
            label = new Label("Layout");
            panel.add(label);
            this.fLayOutBox = new Checkbox[this.fNumBrdLayOut];
            n = 0;
            while (n < this.fNumBrdLayOut) {
                object = this.fBrdLayOut[n];
                this.fLayOutBox[n] = new Checkbox((String)object, this.fLayOutGrp, n == 0);
                panel.add(this.fLayOutBox[n]);
                ++n;
            }
            panel3.add(panel);
        }
        if (this.fMaxPerSet > 1) {
            panel = new Panel();
            panel.setLayout(new GridLayout(this.fMaxPerSet + 2, 1));
            this.fSetGrp = new CheckboxGroup();
            label = new Label("Tile Set");
            panel.add(label);
            this.fSetBox = new Checkbox[this.fMaxPerSet + 2];
            n = 1;
            while (n <= this.fMaxPerSet) {
                object = "Tile Set " + String.valueOf(n);
                this.fSetBox[n] = new Checkbox((String)object, this.fSetGrp, n == this.fIniSet);
                panel.add(this.fSetBox[n]);
                ++n;
            }
            this.fSetBox[this.fMaxPerSet + 1] = new Checkbox("Random Tiles", this.fSetGrp, this.fIniSet == this.fMaxPerSet + 1);
            panel.add(this.fSetBox[this.fMaxPerSet + 1]);
            panel3.add(panel);
        }
        panel = new Panel();
        panel.setLayout(new GridLayout(1, 3));
        this.fMemTotTxt = new Label("Total Memory: Unknown");
        this.fMemFreTxt = new Label("Free Memory: Unknown");
        this.fMemUseTxt = new Label("Used Memory: Unknown");
        panel.add(this.fMemTotTxt);
        panel.add(this.fMemFreTxt);
        panel.add(this.fMemUseTxt);
        panel3.add(panel);
        if (this.fRegSitNam != null && this.fRegSitNam.length() > 0) {
            label = new Label("Game hosted by " + this.fRegSitNam);
            Panel panel5 = new Panel();
            panel5.setLayout(new GridLayout(1, 1));
            panel5.add(label);
            panel3.add(panel5);
        }
        label = new Label(this.fImgCpyRgt);
        Panel panel6 = new Panel();
        panel6.setLayout(new GridLayout(1, 1));
        panel6.add(label);
        panel3.add(panel6);
        this.fOptPnl.add("Center", panel3);
        object = new Panel();
        ((Container)object).setLayout(new GridLayout(1, 4, 20, 0));
        this.fOKBtn = new Button("Okay");
        ((Container)object).add(this.fOKBtn);
        this.fRstBtn = new Button("Reset");
        ((Container)object).add(this.fRstBtn);
        this.fCanBtn = new Button("Cancel");
        ((Container)object).add(this.fCanBtn);
        this.fNewBtn = new Button("New Game");
        ((Container)object).add(this.fNewBtn);
        this.fOptPnl.add("South", (Component)object);
        this.resetOptions();
        this.add(kOptionsPanel, this.fOptPnl);
    }

    public void setHelpBar() {
        if (this.fHlpTxt != null) {
            this.fHlpBar.setValues(0, this.fHlpTxt.getVisible(), 0, this.fHlpTxt.getLines());
        }
    }

    public void setOhNoBar() {
        if (this.fOhNoCvs != null) {
            this.fOhNoBar.setValues(0, this.fOhNoCvs.getVisible(), 0, this.fOhNoCvs.getLines());
        }
    }

    public void setMemoryText() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() / 1024L;
        long l2 = runtime.freeMemory() / 1024L;
        long l3 = l - l2;
        if (this.fMemTotTxt != null) {
            this.fMemTotTxt.setText("Total Memory: " + String.valueOf(l) + "Kb");
        }
        if (this.fMemFreTxt != null) {
            this.fMemFreTxt.setText("Free Memory: " + String.valueOf(l2) + "Kb");
        }
        if (this.fMemUseTxt != null) {
            this.fMemUseTxt.setText("Used Memory: " + String.valueOf(l3) + "Kb");
        }
    }

    public int getNewLevel() {
        if (this.fLvlGrp != null) {
            Checkbox checkbox = this.fLvlGrp.getCurrent();
            int n = this.fTilGam.getGameLevel();
            int n2 = this.fMinLvl;
            while (n2 <= this.fMaxLvl) {
                if (this.fLvlBox[n2] == checkbox) {
                    n = n2;
                }
                ++n2;
            }
            return n;
        }
        return this.fTilGam.getGameLevel();
    }

    public boolean levelChanged() {
        return this.fTilGam.getGameLevel() != this.getNewLevel();
    }

    public int getNewTileSet() {
        if (this.fSetGrp != null) {
            Checkbox checkbox = this.fSetGrp.getCurrent();
            int n = this.fTilGam.getTileSet();
            int n2 = 1;
            while (n2 <= this.fMaxPerSet + 1) {
                if (this.fSetBox[n2] == checkbox) {
                    n = n2;
                }
                ++n2;
            }
            return n;
        }
        return this.fTilGam.getTileSet();
    }

    public boolean tileSetChanged() {
        return this.fTilGam.getTileSet() != this.getNewTileSet();
    }

    public int getNewLayoutNum() {
        if (this.fLayOutGrp != null) {
            Checkbox checkbox = this.fLayOutGrp.getCurrent();
            int n = this.fTilGam.getLayoutNum();
            int n2 = 0;
            while (n2 < this.fNumBrdLayOut) {
                if (this.fLayOutBox[n2] == checkbox) {
                    n = n2;
                }
                ++n2;
            }
            return n;
        }
        return this.fTilGam.getLayoutNum();
    }

    public boolean layoutChanged() {
        return this.fTilGam.getLayoutNum() != this.getNewLayoutNum();
    }

    public void setOptions(boolean bl) {
        boolean bl2 = this.fSdwOpt;
        this.fSndOpt = this.fSndOptBox.getState();
        this.fMscOpt = this.fMscOptBox.getState();
        this.fPerOpt = this.fPerOptBox.getState();
        this.fEffOpt = this.fEffOptBox.getState();
        this.fBonOpt = this.fBonOptBox.getState();
        this.fZomOpt = this.fZomOptBox.getState();
        this.fSdwOpt = this.fSdwOptBox.getState();
        this.fSwpTilOpt = this.fSwpTilOptBox.getState();
        this.fSwpBckOpt = this.fSwpBckOptBox.getState();
        this.fTilCvs.setParms();
        if (bl2 != this.fSdwOpt) {
            this.fTilCvs.invalidateBuffer();
        }
        this.fTilCvs.periodicSound();
        this.fTilCvs.continuousSound(false);
        if (this.levelChanged() || this.tileSetChanged() || this.layoutChanged() || bl) {
            this.fTilGam.setGameParms(this.getNewLevel(), this.getNewTileSet(), this.getNewLayoutNum());
        }
    }

    public void adjustOkayButton() {
        if (this.levelChanged() || this.tileSetChanged() || this.layoutChanged()) {
            this.fOKBtn.disable();
            return;
        }
        this.fOKBtn.enable();
    }

    public void resetOptions() {
        this.setMemoryText();
        this.fSndOptBox.setState(this.fSndOpt);
        this.fMscOptBox.setState(this.fMscOpt);
        this.fPerOptBox.setState(this.fPerOpt);
        this.fEffOptBox.setState(this.fEffOpt);
        this.fBonOptBox.setState(this.fBonOpt);
        this.fZomOptBox.setState(this.fZomOpt);
        this.fSdwOptBox.setState(this.fSdwOpt);
        this.fSwpTilOptBox.setState(this.fSwpTilOpt);
        this.fSwpBckOptBox.setState(this.fSwpBckOpt);
        if (this.fTilGam != null) {
            if (this.fLvlBox != null) {
                this.fLvlBox[this.fTilGam.getGameLevel()].setState(true);
            }
            if (this.fSetBox != null) {
                this.fSetBox[this.fTilGam.getTileSet()].setState(true);
            }
            if (this.fLayOutBox != null) {
                this.fLayOutBox[this.fTilGam.getLayoutNum()].setState(true);
            }
        }
        this.fOKBtn.enable();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201 && this.fAppFrm != null && event.target == this.fAppFrm) {
            return true;
        }
        if (event.target == this.fHlpBar && (event.id == 601 || event.id == 602 || event.id == 603 || event.id == 604 || event.id == 605)) {
            this.fHlpTxt.setTopLine(this.fHlpBar.getValue());
            this.fHlpTxt.repaint();
            return true;
        }
        if (event.target == this.fOhNoBar && (event.id == 601 || event.id == 602 || event.id == 603 || event.id == 604 || event.id == 605)) {
            this.fOhNoCvs.setTopLine(this.fOhNoBar.getValue());
            this.fOhNoCvs.repaint();
            return true;
        }
        if (event.target instanceof Checkbox && (((Checkbox)event.target).getCheckboxGroup() == this.fLvlGrp || ((Checkbox)event.target).getCheckboxGroup() == this.fSetGrp || ((Checkbox)event.target).getCheckboxGroup() == this.fLayOutGrp)) {
            this.adjustOkayButton();
            return true;
        }
        if (this.fClkBckToGam && this.registryOkay() && (event.id == 501 || event.id == 401)) {
            this.showCard(kGamePanel);
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.fNewBtn) {
            this.setOptions(true);
            this.showCard(kGamePanel);
            return true;
        }
        if (event.target == this.fOKBtn) {
            this.setOptions(false);
            this.showCard(kGamePanel);
            return true;
        }
        if (event.target == this.fCanBtn) {
            this.showCard(kGamePanel);
            return true;
        }
        if (event.target == this.fRstBtn) {
            this.resetOptions();
            return true;
        }
        return super.action(event, object);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.fClkBckToGam && this.registryOkay() && event.target != this.fHlpBar && event.target != this.fOhNoBar) {
            this.showCard(kGamePanel);
            return true;
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean keyDown(Event event, int n) {
        if (this.fClkBckToGam && this.registryOkay()) {
            this.showCard(kGamePanel);
            return true;
        }
        return super.keyDown(event, n);
    }

    public void showCard(String string) {
        if (string.equals(kOptionsPanel)) {
            this.resetOptions();
            this.fClkBckToGam = false;
        } else {
            this.fClkBckToGam = true;
        }
        if (this.fAppFrm != null) {
            this.fFrmLayOut.show(this.fAppFrm, string);
        } else {
            this.fCrdLayOut.show(this, string);
        }
        this.moveFocus(string);
    }

    public void moveFocus(String string) {
        if (string.equals(kOptionsPanel)) {
            this.fOptPnl.requestFocus();
            return;
        }
        if (string.equals(kHelpPanel)) {
            this.fHlpPnl.requestFocus();
            return;
        }
        if (string.equals(kOhNoPanel)) {
            this.fOhNoPnl.requestFocus();
            return;
        }
        this.fTilCvs.requestFocus();
    }

    public void loadParms() {
        int n;
        String string;
        StringTokenizer stringTokenizer;
        this.fSerNum = this.getParameter("MiNiPaiNo");
        if (this.fSerNum == null) {
            this.fSerNum = this.getParameter("MNPSerialNo");
        }
        if (this.fSerNum == null || this.fSerNum.length() == 0) {
            this.ohNo("Missing game serial number.  Cannot execute.");
        }
        this.fRegSitNam = this.getParameter("Registry");
        if (this.fRegSitNam == null) {
            this.ohNo("Missing site license name.  Cannot execute.");
        }
        Dimension dimension = this.size();
        this.fGamWid = dimension.width;
        this.fGamHgt = dimension.height;
        this.fGamWid = this.getIntegerParameter("gameWidth", this.fGamWid);
        this.fGamHgt = this.getIntegerParameter("gameHeight", this.fGamHgt);
        String string2 = this.getParameter("fileFolder");
        if (string2 != null) {
            this.fTilFld = string2;
            this.fBckFld = string2;
            this.fSndFld = string2;
            this.fBonFld = string2;
            this.fCtlFld = string2;
            this.fZomFld = string2;
            this.fXtrFld = string2;
        }
        this.fTilFld = this.getStringParameter("tileFolder", this.fTilFld);
        this.fBckFld = this.getStringParameter("backgroundFolder", this.fBckFld);
        this.fBonFld = this.getStringParameter("bonusFolder", this.fBonFld);
        this.fZomFld = this.getStringParameter("zoomFolder", this.fZomFld);
        this.fCtlFld = this.getStringParameter("controlFolder", this.fCtlFld);
        this.fSndFld = this.getStringParameter("soundFolder", this.fSndFld);
        this.fXtrFld = this.getStringParameter("extrasFolder", this.fXtrFld);
        this.fMinLvl = this.getIntegerParameter("minLevel", this.fMinLvl);
        this.fMaxLvl = this.getIntegerParameter("maxLevel", this.fMaxLvl);
        this.fIniLvl = this.getIntegerParameter("initLevel", this.fIniLvl);
        this.fIniSet = this.getIntegerParameter("initSet", this.fIniSet + 1) - 1;
        this.fBrdLayOutLst = this.getStringParameter("layouts", this.fBrdLayOutLst);
        this.fBonCtl = this.getStringParameter("bonus", this.fBonCtl);
        this.fBonTyp = this.getStringParameter("bonusType", this.fBonTyp);
        this.fZomTyp = this.getStringParameter("zoomType", this.fZomTyp);
        this.fZomFac = this.getFloatParameter("zoomFactor", this.fZomFac);
        this.fImgCpyRgt = this.getStringParameter("copyright", this.fImgCpyRgt);
        this.fNewGamMsg = this.getStringParameter("newMessage", this.fNewGamMsg);
        this.fWinMsg = this.getStringParameter("winMessage", this.fWinMsg);
        this.fLosMsg = this.getStringParameter("loseMessage", this.fLosMsg);
        this.fWinFnt = this.getStringParameter("winFont", this.fWinFnt);
        this.fLosFnt = this.getStringParameter("loseFont", this.fLosFnt);
        this.fCptFnt = this.getStringParameter("captionFont", this.fCptFnt);
        this.fWinSiz = this.getIntegerParameter("winSize", this.fWinSiz);
        this.fLosSiz = this.getIntegerParameter("loseSize", this.fLosSiz);
        this.fCptSiz = this.getIntegerParameter("captionSize", this.fCptSiz);
        this.fWinTop = this.getIntegerParameter("winTop", this.fWinTop);
        this.fWinLft = this.getIntegerParameter("winLeft", this.fWinLft);
        this.fLosTop = this.getIntegerParameter("loseTop", this.fLosTop);
        this.fLosLft = this.getIntegerParameter("loseLeft", this.fLosLft);
        this.fCptTop = this.getIntegerParameter("captionTop", this.fCptTop);
        this.fCptLft = this.getIntegerParameter("captionLeft", this.fCptLft);
        this.fBdrClr = this.getColorParameter("sideColor", this.fBdrClr, false);
        this.fFrmClr = this.getColorParameter("frameColor", this.fFrmClr, false);
        this.fHiLitClr = this.getColorParameter("hiliteColor", this.fHiLitClr, false);
        this.fBckClr = this.getColorParameter("backgroundColor", this.fBckClr, false);
        this.fWinClr = this.getColorParameter("winColor", this.fWinClr, false);
        this.fLosClr = this.getColorParameter("loseColor", this.fLosClr, false);
        this.fCptClr = this.getColorParameter("captionColor", this.fCptClr, true);
        this.fCptBckClr = this.getColorParameter("captionBackColor", this.fCptBckClr, true);
        this.fOptClr = this.fWinClr;
        string2 = this.getParameter("OptColor");
        if (string2 != null) {
            if (string2.equalsIgnoreCase("flip")) {
                this.fOptFlp = true;
            } else {
                this.fOptClr = ColorPicker.getColor(string2);
            }
        }
        if ((string2 = this.getParameter("direction")) != null && (string2.equalsIgnoreCase("vertical") || string2.equalsIgnoreCase("vert") || string2.equalsIgnoreCase("v"))) {
            this.fLftRgt = false;
        }
        this.fWinURL = this.getStringParameter("winURL", this.fWinURL);
        this.fWinTgt = this.getStringParameter("winTarget", this.fWinTgt);
        this.fLosURL = this.getStringParameter("loseURL", this.fLosURL);
        this.fLosTgt = this.getStringParameter("loseTarget", this.fLosTgt);
        this.fRemEff = this.getStringParameter("effect", this.fRemEff);
        this.fMaxEff = this.getIntegerParameter("effectSimul", this.fMaxEff);
        this.fEffStp = this.getIntegerParameter("steps", this.fEffStp);
        this.fEffSlpTim = this.getIntegerParameter("effectLapse", this.fEffSlpTim);
        this.fEffPrmOne = this.getIntegerParameter("effectParm1", this.fEffPrmOne);
        this.fEffPrmTwo = this.getIntegerParameter("effectParm2", this.fEffPrmTwo);
        this.fEffPrmThr = this.getFloatParameter("effectParm3", this.fEffPrmThr);
        this.fTilBas = this.getIntegerParameter("tileBase", this.fTilBas);
        this.fRnkBas = this.getIntegerParameter("rankBase", this.fRnkBas);
        this.fRnkBas = this.getIntegerParameter("backgroundBase", this.fRnkBas);
        this.fPerBas = this.getIntegerParameter("periodicBase", this.fPerBas);
        this.fPreTrm = this.getBooleanParameter("pertrim", this.fPreTrm);
        this.fTilTrm = this.getIntegerParameter("trim", this.fTilTrm);
        this.fSidHgt = this.getIntegerParameter("sideHeight", this.fSidHgt);
        this.fNumPltBit = this.getIntegerParameter("imageBits", this.fNumPltBit);
        this.fSndAlw = this.getBooleanParameter("allowSound", this.fSndAlw);
        this.fEffAlw = this.getBooleanParameter("allowEffects", this.fEffAlw);
        this.fMscAlw = this.getBooleanParameter("allowMusic", this.fMscAlw);
        this.fPerAlw = this.getBooleanParameter("allowPeriodic", this.fPerAlw);
        this.fSdwAlw = this.getBooleanParameter("allowShadows", this.fSdwAlw);
        this.fBonAlw = this.getBooleanParameter("allowBonus", this.fBonAlw);
        this.fZomAlw = this.getBooleanParameter("allowZoom", this.fZomAlw);
        this.fSwpTilAlw = this.getBooleanParameter("allowSwapTiles", this.fSwpTilAlw);
        this.fSwpBckAlw = this.getBooleanParameter("allowSwapBack", this.fSwpBckAlw);
        this.fSndOpt = this.getBooleanParameter("soundOption", this.fSndOpt) && this.fSndAlw;
        this.fEffOpt = this.getBooleanParameter("effectsOption", this.fEffOpt) && this.fEffAlw;
        this.fMscOpt = this.getBooleanParameter("musicOption", this.fMscOpt) && this.fMscAlw;
        this.fPerOpt = this.getBooleanParameter("periodicOption", this.fPerOpt) && this.fPerAlw;
        this.fSdwOpt = this.getBooleanParameter("shadowsOption", this.fSdwOpt) && this.fSdwAlw;
        this.fBonOpt = this.getBooleanParameter("bonusOption", this.fBonOpt) && this.fBonAlw;
        this.fZomOpt = this.getBooleanParameter("zoomOption", this.fZomOpt) && this.fZomAlw;
        this.fSwpTilOpt = this.getBooleanParameter("swapTilesOption", this.fSwpTilOpt) && this.fSwpTilAlw;
        this.fSwpBckOpt = this.getBooleanParameter("swapBackOption", this.fSwpBckOpt) && this.fSwpBckAlw;
        this.fFrmTtl = this.getStringParameter("title", this.fFrmTtl);
        this.fFrmOpt = this.getBooleanParameter("window", this.fFrmOpt);
        this.fSldShwTim = this.getIntegerParameter("showSeconds", this.fSldShwTim);
        this.fTotSet = this.getIntegerParameter("imageSets", this.fTotSet);
        this.fMaxPerSet = this.getIntegerParameter("imagesPerSet", this.fMaxPerSet);
        if (this.fPlySet > this.fTotSet) {
            this.fPlySet = this.fTotSet;
        }
        this.fPlySet = this.getIntegerParameter("playSets", this.fPlySet);
        this.fPlyPerSet = this.getIntegerParameter("playPerSet", this.fPlyPerSet);
        if (this.fPlySet > this.fTotSet) {
            this.fTotSet = this.fPlySet;
        }
        this.fSetSwp = this.fPlySet;
        this.fSetSwp = this.getIntegerParameter("swap", this.fSetSwp);
        if (this.fSetSwp > this.fTotSet - this.fPlySet) {
            this.fSetSwp = this.fTotSet - this.fPlySet;
        }
        this.fPerTim = this.getIntegerParameter("periodicTime", this.fPerTim);
        this.fPerCnt = this.getIntegerParameter("periodicCount", this.fPerCnt);
        if (!this.fPerAlw) {
            this.fPerCnt = 0;
        }
        this.fPreLodSnd = this.getBooleanParameter("preloadSounds", this.fPreLodSnd);
        this.fCluCrd = this.getIntegerParameter("clue", this.fCluCrd);
        string2 = this.getParameter("delimiter");
        if (string2 != null) {
            this.fDlm = string2;
        }
        this.fDlm = this.getStringParameter("delimiter", this.fDlm);
        string2 = this.getParameter("tileName");
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, this.fDlm);
            this.fTilPre = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "Tile.";
            this.fTilIn = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            this.fTilSuf = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        }
        if ((string2 = this.getParameter("bonusName")) != null) {
            stringTokenizer = new StringTokenizer(string2, this.fDlm);
            this.fBonPre = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "Tile.";
            this.fBonIn = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            this.fBonSuf = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        }
        if ((string2 = this.getParameter("zoomName")) != null) {
            stringTokenizer = new StringTokenizer(string2, this.fDlm);
            this.fZomPre = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "Tile.";
            this.fZomIn = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            this.fZomSuf = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        }
        if ((string2 = this.getParameter("backgroundName")) != null) {
            stringTokenizer = new StringTokenizer(string2, this.fDlm);
            this.fBckPre = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "Background.";
            this.fBckIn = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            this.fBckSuf = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        }
        if ((string2 = this.getParameter("backChooser")) != null) {
            stringTokenizer = new StringTokenizer(string2, "/, ");
            string = "";
            this.fNumBckCmp = 0;
            n = 1;
            int n2 = 1;
            boolean bl = false;
            boolean bl2 = true;
            while (stringTokenizer.hasMoreTokens() && this.fNumBckCmp < 3 && bl2) {
                string = stringTokenizer.nextToken();
                if (string.equalsIgnoreCase("Level")) {
                    this.fBckCmpLst[this.fNumBckCmp] = 0;
                    n = this.fMaxLvl - this.fMinLvl + 1;
                    ++this.fNumBckCmp;
                    continue;
                }
                if (string.equalsIgnoreCase("Layout")) {
                    this.fBckCmpLst[this.fNumBckCmp] = 1;
                    n2 = new StringTokenizer(this.fBrdLayOutLst, ", ").countTokens();
                    ++this.fNumBckCmp;
                    continue;
                }
                if (string.equalsIgnoreCase("Random")) {
                    this.fBckCmpLst[this.fNumBckCmp] = 2;
                    ++this.fNumBckCmp;
                    bl = true;
                    continue;
                }
                bl2 = false;
            }
            if (bl) {
                this.fBckRndCnt = new int[n][n2];
                int n3 = 0;
                while (n3 < n) {
                    int n4 = 0;
                    while (n4 < n2) {
                        this.fBckRndCnt[n3][n4] = this.getIntegerParm(string, 0);
                        string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "0";
                        ++n4;
                    }
                    ++n3;
                }
            }
        }
        this.fWinRat = this.getIntegerParameter("winnable", this.fWinRat);
        this.fMgkMod = this.getBooleanParameter("magikMode", this.fMgkMod);
        this.fFrmWid = this.getIntegerParameter("frameWidth", this.fFrmWid);
        this.fFrmIns = this.getBooleanParameter("frameInset", this.fFrmIns);
        string2 = this.getParameter("frameFade");
        if (string2 != null) {
            if (string2.equalsIgnoreCase("darker")) {
                this.fFrmFad = 2;
            } else if (string2.equalsIgnoreCase("lighter") || string2.equalsIgnoreCase("brighter")) {
                this.fFrmFad = 1;
            } else if (string2.equalsIgnoreCase("paler")) {
                this.fFrmFad = 3;
            } else if (string2.equalsIgnoreCase("truer")) {
                this.fFrmFad = 4;
            } else if (string2.equalsIgnoreCase("redder")) {
                this.fFrmFad = 5;
            } else if (string2.equalsIgnoreCase("bluer")) {
                this.fFrmFad = 6;
            } else if (string2.equalsIgnoreCase("greener")) {
                this.fFrmFad = 7;
            } else if (string2.equalsIgnoreCase("same")) {
                this.fFrmFad = 0;
            } else {
                this.fFrmFad = 0;
                this.ohNo("Invalid frameFade value " + string2);
            }
        }
        if (this.fTilFld.length() > 0) {
            this.fTilFld = String.valueOf(this.fTilFld) + "/";
        }
        if (this.fBckFld.length() > 0) {
            this.fBckFld = String.valueOf(this.fBckFld) + "/";
        }
        if (this.fZomFld.length() > 0) {
            this.fZomFld = String.valueOf(this.fZomFld) + "/";
        }
        if (this.fBonFld.length() > 0) {
            this.fBonFld = String.valueOf(this.fBonFld) + "/";
        }
        if (this.fSndFld.length() > 0) {
            this.fSndFld = String.valueOf(this.fSndFld) + "/";
        }
        if (this.fXtrFld.length() > 0) {
            this.fXtrFld = String.valueOf(this.fXtrFld) + "/";
        }
        if (this.fCtlFld.length() > 0) {
            this.fCtlFld = String.valueOf(this.fCtlFld) + "/";
        }
        if ((string2 = this.getParameter("captions")) != null) {
            this.getCaptionStrings(string2);
        }
        if ((string2 = this.getParameter("minRankSet")) != null) {
            this.fMinRnkSet = new int[this.fMaxPerSet];
            stringTokenizer = new StringTokenizer(string2, "/, ");
            string = "";
            n = 0;
            while (stringTokenizer.hasMoreTokens() && n < this.fMaxPerSet) {
                string = stringTokenizer.nextToken();
                this.fMinRnkSet[n] = this.getIntegerParm(string, this.fTilBas) - this.fTilBas;
                if (n == 0) {
                    this.fMinRnkSet[n] = 0;
                }
                ++n;
            }
        }
        if ((string2 = this.getParameter("maxRankSet")) != null) {
            this.fMaxRnkSet = new int[this.fMaxPerSet];
            stringTokenizer = new StringTokenizer(string2, "/, ");
            string = "";
            n = 0;
            while (stringTokenizer.hasMoreTokens() && n < this.fMaxPerSet) {
                string = stringTokenizer.nextToken();
                this.fMaxRnkSet[n] = this.getIntegerParm(string, this.fTotSet - 1 + this.fTilBas) - this.fTilBas;
                if (n == 0) {
                    this.fMaxRnkSet[n] = this.fTotSet - 1;
                }
                ++n;
            }
            while (n < this.fMaxPerSet) {
                this.fMaxRnkSet[n] = this.fTotSet - 1;
            }
        }
        this.parseLayouts();
    }

    public int getIntegerParameter(String string, int n) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            return this.getIntegerParm(string2, n);
        }
        return n;
    }

    public String getStringParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public Color getColorParameter(String string, Color color, boolean bl) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            if (bl && string2.equalsIgnoreCase("none")) {
                return null;
            }
            return ColorPicker.getColor(string2);
        }
        return color;
    }

    public boolean getBooleanParameter(String string, boolean bl) {
        String string2 = this.getParameter(string);
        return this.getBooleanParm(string2, bl);
    }

    public float getFloatParameter(String string, float f) {
        String string2 = this.getParameter(string);
        return this.getFloatParm(string2, f);
    }

    public int getIntegerParm(String string, int n) {
        int n2;
        block2: {
            n2 = n;
            if (string == null) break block2;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n;
                this.ohNo("Invalid numeric parameter value " + string);
            }
        }
        return n2;
    }

    public float getFloatParm(String string, float f) {
        float f2;
        block2: {
            f2 = f;
            if (string == null) break block2;
            try {
                f2 = Float.valueOf(string).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                f2 = f;
                this.ohNo("Invalid decimal parameter value " + string);
            }
        }
        return f2;
    }

    public void parseLayouts() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.fBrdLayOutLst, ",");
        this.fNumBrdLayOut = stringTokenizer.countTokens();
        if (this.fNumBrdLayOut == 0) {
            this.ohNo("No board layouts");
            this.fNumBrdLayOut = 1;
            this.fBrdLayOut = new String[1];
            this.fBrdLayOut[1] = "Standard";
            return;
        }
        this.fBrdLayOut = new String[this.fNumBrdLayOut];
        int n = 0;
        while (n < this.fNumBrdLayOut) {
            this.fBrdLayOut[n] = stringTokenizer.nextToken();
            ++n;
        }
    }

    public boolean getBooleanParm(String string, boolean bl) {
        boolean bl2 = bl;
        if (string != null) {
            if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("off")) {
                bl2 = false;
            } else if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on")) {
                bl2 = true;
            } else {
                this.ohNo("Invalid boolean parameter value " + string);
            }
        }
        return bl2;
    }

    public void getCaptionStrings(String string) {
        this.fBonCpt = new String[this.fTotSet];
        try {
            URL uRL = new URL(this.getDocumentBase(), String.valueOf(this.fXtrFld) + string);
            try {
                InputStream inputStream = uRL.openStream();
                int n = inputStream.read();
                while (n > 0) {
                    String string2 = "";
                    String string3 = "";
                    while (n > 0 && n != 32 && n != 13) {
                        string2 = String.valueOf(string2) + (char)n;
                        n = inputStream.read();
                    }
                    while (n == 32) {
                        n = inputStream.read();
                    }
                    while (n > 0 && n != 13) {
                        string3 = String.valueOf(string3) + (char)n;
                        n = inputStream.read();
                    }
                    int n2 = this.getIntegerParm(string2, 0);
                    if ((n2 -= this.fTilBas) >= 0 && n2 < this.fTotSet) {
                        this.fBonCpt[n2] = string3;
                    }
                    if (n != 13) continue;
                    n = inputStream.read();
                }
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                this.ohNo("Reading captions\r" + iOException.toString());
                this.ohNo(String.valueOf(this.fXtrFld) + string);
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.ohNo("Reading captions\r" + malformedURLException.toString());
            return;
        }
    }

    public String getAppletInfo() {
        return "TileMatch Version 1.0   Copyright Robert N. Lacatena, 1998";
    }

    public int getGameWidth() {
        return this.fGamWid;
    }

    public int getGameHeight() {
        return this.fGamHgt;
    }

    public Color getBorderColor() {
        return this.fBdrClr;
    }

    public Color getFrameColor() {
        return this.fFrmClr;
    }

    public Color getBackgroundColor() {
        return this.fBckClr;
    }

    public Color getHiLiteColor() {
        return this.fHiLitClr;
    }

    public Color getWinColor() {
        return this.fWinClr;
    }

    public Color getLoseColor() {
        return this.fLosClr;
    }

    public Color getCaptionColor() {
        return this.fCptClr;
    }

    public Color getCaptionBackColor() {
        return this.fCptBckClr;
    }

    public String getTileFolder() {
        return this.fTilFld;
    }

    public String getBackgroundFolder() {
        return this.fBckFld;
    }

    public String getZoomFolder() {
        return this.fZomFld;
    }

    public String getBonusFolder() {
        return this.fBonFld;
    }

    public String getControlFolder() {
        return this.fCtlFld;
    }

    public String getSoundFolder() {
        return this.fSndFld;
    }

    public String getExtrasFolder() {
        return this.fXtrFld;
    }

    public String getWinMessage() {
        return this.fWinMsg;
    }

    public String getLoseMessage() {
        return this.fLosMsg;
    }

    public String getWinFont() {
        return this.fWinFnt;
    }

    public String getLoseFont() {
        return this.fLosFnt;
    }

    public String getCaptionFont() {
        return this.fCptFnt;
    }

    public int getWinSize() {
        return this.fWinSiz;
    }

    public int getLoseSize() {
        return this.fLosSiz;
    }

    public int getCaptionSize() {
        return this.fCptSiz;
    }

    public int getWinLeft() {
        return this.fWinLft;
    }

    public int getLoseLeft() {
        return this.fLosLft;
    }

    public int getCaptionLeft() {
        return this.fCptLft;
    }

    public int getWinTop() {
        return this.fWinTop;
    }

    public int getLoseTop() {
        return this.fLosTop;
    }

    public int getCaptionTop() {
        return this.fCptTop;
    }

    public int getTileTrim() {
        return this.fTilTrm;
    }

    public int getSideHeight() {
        return this.fSidHgt;
    }

    public int getTotSets() {
        return this.fTotSet;
    }

    public int getMaxPerSet() {
        return this.fMaxPerSet;
    }

    public int getPlaySets() {
        return this.fPlySet;
    }

    public int getPlayPerSet() {
        return this.fPlyPerSet;
    }

    public int getSetSwap() {
        return this.fSetSwp;
    }

    public int getSetSave() {
        return this.fPlySet - this.fSetSwp;
    }

    public int getMaxLevel() {
        return this.fMaxLvl;
    }

    public int getMinLevel() {
        return this.fMinLvl;
    }

    public int getInitLevel() {
        return this.fIniLvl;
    }

    public int getInitSet() {
        return this.fIniSet;
    }

    public boolean getLeftRight() {
        return this.fLftRgt;
    }

    public boolean getPretrim() {
        return this.fPreTrm;
    }

    public String getBoardLayouts() {
        return this.fBrdLayOutLst;
    }

    public String getZoomType() {
        return this.fZomTyp;
    }

    public float getZoomFactor() {
        return this.fZomFac;
    }

    public String getBonusControl() {
        return this.fBonCtl;
    }

    public String getBonusType() {
        return this.fBonTyp;
    }

    public int getSlideShowTime() {
        return this.fSldShwTim;
    }

    public String getImageCopyright() {
        return this.fImgCpyRgt;
    }

    public String getRemoveEffect() {
        return this.fRemEff;
    }

    public int getEffectSteps() {
        return this.fEffStp;
    }

    public int getEffectLapse() {
        return this.fEffSlpTim;
    }

    public int getSimulEffect() {
        return this.fMaxEff;
    }

    public int getEffectParmOne() {
        return this.fEffPrmOne;
    }

    public int getEffectParmTwo() {
        return this.fEffPrmTwo;
    }

    public float getEffectParmThree() {
        return this.fEffPrmThr;
    }

    public boolean getSoundOption() {
        return this.fSndOpt && this.fSndAlw;
    }

    public boolean getEffectsOption() {
        return this.fEffOpt && this.fEffAlw;
    }

    public boolean getMusicOption() {
        return this.fMscOpt && this.fMscAlw;
    }

    public boolean getPeriodicOption() {
        return this.fPerOpt && this.fPerAlw && this.fSndAlw;
    }

    public boolean getShadowsOption() {
        return this.fSdwOpt && this.fSdwAlw;
    }

    public boolean getBonusOption() {
        return this.fBonOpt && this.fBonAlw;
    }

    public boolean getZoomOption() {
        return this.fZomOpt && this.fZomAlw;
    }

    public boolean getSwapTilesOption() {
        return this.fSwpTilOpt && this.fSwpTilAlw;
    }

    public boolean getSwapBackOption() {
        return this.fSwpBckOpt && this.fSwpBckAlw;
    }

    public boolean getPreloadSounds() {
        return this.fPreLodSnd;
    }

    public int getClueCredit() {
        return this.fCluCrd;
    }

    public String getTilePrefix() {
        return this.fTilPre;
    }

    public String getTileInfix() {
        return this.fTilIn;
    }

    public String getTileSuffix() {
        return this.fTilSuf;
    }

    public int getTileBase() {
        return this.fTilBas;
    }

    public int getRankBase() {
        return this.fRnkBas;
    }

    public int getBackgroundBase() {
        return this.fBckBas;
    }

    public int getPeriodicBase() {
        return this.fPerBas;
    }

    public String getZoomPrefix() {
        return this.fZomPre;
    }

    public String getZoomInfix() {
        return this.fZomIn;
    }

    public String getZoomSuffix() {
        return this.fZomSuf;
    }

    public String getBonusPrefix() {
        return this.fBonPre;
    }

    public String getBonusInfix() {
        return this.fBonIn;
    }

    public String getBonusSuffix() {
        return this.fBonSuf;
    }

    public String getBackgroundPrefix() {
        return this.fBckPre;
    }

    public String getBackgroundInfix() {
        return this.fBckIn;
    }

    public String getBackgroundSuffix() {
        return this.fBckSuf;
    }

    public String getNewGameMessage() {
        return this.fNewGamMsg;
    }

    public int getPeriodicTime() {
        return this.fPerTim;
    }

    public int getPeriodicCount() {
        return this.fPerCnt;
    }

    public int getPaletteBits() {
        return this.fNumPltBit;
    }

    public int getFrameWidth() {
        return this.fFrmWid;
    }

    public boolean getFrameInset() {
        return this.fFrmIns;
    }

    public int getFrameFade() {
        return this.fFrmFad;
    }

    public int getWinnable() {
        return this.fWinRat;
    }

    public boolean getMagikMode() {
        return this.fMgkMod;
    }

    public void toggleMagikMode() {
        boolean bl = this.fMgkMod = !this.fMgkMod;
        if (this.fMgkMod) {
            this.showStatus("Magik Mode on!");
            return;
        }
        this.showStatus("Mundane Mode on (ho, hum).");
    }

    public void toggleWinnable() {
        if (this.fWinRat < 0) {
            this.fWinRat = 0;
            this.showStatus("Winnable deals (easy).");
            return;
        }
        this.fWinRat = -1;
        this.showStatus("Random deals");
    }

    public void increaseDifficulty() {
        this.fWinRat += 5;
        this.showStatus("Difficulty is now " + Integer.toString(this.fWinRat));
    }

    public TileTextCanvas getHelpTextCanvas() {
        return this.fHlpTxt;
    }

    public String getCaption(int n) {
        if (this.fBonCpt == null) {
            return null;
        }
        if (n < this.fBonCpt.length) {
            return this.fBonCpt[n];
        }
        return null;
    }

    public int getBoardLayoutNum(int n) {
        return n % this.fNumBrdLayOut;
    }

    public String getBoardLayout(int n) {
        return this.fBrdLayOut[this.getBoardLayoutNum(n)];
    }

    public boolean swapByLevel() {
        int n = 0;
        while (n < this.fNumBckCmp) {
            if (this.fBckCmpLst[n] == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean swapByLayout() {
        int n = 0;
        while (n < this.fNumBckCmp) {
            if (this.fBckCmpLst[n] == 1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean swapByRandom() {
        int n = 0;
        while (n < this.fNumBckCmp) {
            if (this.fBckCmpLst[n] == 2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int getBackgroundCount(int n, String string) {
        boolean[] blArray = new boolean[3];
        int n2 = 0;
        while (n2 < this.fNumBckCmp) {
            if (this.fBckCmpLst[n2] >= 0) {
                blArray[this.fBckCmpLst[n2]] = true;
            }
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        if (blArray[0]) {
            n3 = n - this.fMinLvl;
        }
        if (blArray[1]) {
            n4 = this.getLayoutIndex(string);
        }
        if (blArray[2]) {
            return this.fBckRndCnt[n3][n4];
        }
        return 1;
    }

    public String getBackgroundName(int n, String string) {
        boolean[] blArray = new boolean[3];
        int[] nArray = new int[3];
        int n2 = 0;
        while (n2 < this.fNumBckCmp) {
            if (this.fBckCmpLst[n2] >= 0) {
                blArray[this.fBckCmpLst[n2]] = true;
            }
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (blArray[0]) {
            n3 = n - this.fMinLvl;
        }
        if (blArray[1]) {
            n4 = this.getLayoutIndex(string);
        }
        if (blArray[2]) {
            n5 = (int)(new Random().nextFloat() * (float)this.fBckRndCnt[n3][n4]);
        }
        nArray[0] = n3 + this.fBckBas;
        nArray[1] = n4 + this.fBckBas;
        nArray[2] = n5 + this.fBckBas;
        String string2 = this.fBckPre;
        String string3 = "";
        int n6 = 0;
        while (n6 < this.fNumBckCmp) {
            string2 = String.valueOf(string2) + string3 + Integer.toString(nArray[this.fBckCmpLst[n6]]);
            string3 = this.fBckIn;
            ++n6;
        }
        string2 = String.valueOf(string2) + this.fBckSuf;
        return string2;
    }

    public int getLayoutIndex(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.fBrdLayOutLst, ", ");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public int getMinRankSet(int n) {
        if (this.fMinRnkSet == null) {
            return 0;
        }
        return this.fMinRnkSet[n];
    }

    public int getMaxRankSet(int n) {
        if (this.fMaxRnkSet == null) {
            return this.fTotSet - 1;
        }
        return this.fMaxRnkSet[n];
    }

    public TileMatchBuffer getTileCanvas() {
        return this.fTilCvs;
    }

    public TileGame getTileGame() {
        return this.fTilGam;
    }

    public TileAnimator getTileAnimator() {
        return this.fTilCvs.getTileAnimator();
    }

    public void showWinDocument() {
        if (this.fWinURL != null) {
            try {
                URL uRL = new URL(this.getDocumentBase(), this.fWinURL);
                if (this.fWinTgt != null) {
                    this.getAppletContext().showDocument(uRL, this.fWinTgt);
                    return;
                }
                this.getAppletContext().showDocument(uRL);
                return;
            }
            catch (MalformedURLException malformedURLException) {
                this.ohNo("Loading winner's document\r" + malformedURLException.toString());
                return;
            }
        }
    }

    public void showLoseDocument() {
        if (this.fLosURL != null) {
            try {
                URL uRL = new URL(this.getDocumentBase(), this.fLosURL);
                if (this.fLosTgt != null) {
                    this.getAppletContext().showDocument(uRL, this.fLosTgt);
                    return;
                }
                this.getAppletContext().showDocument(uRL);
                return;
            }
            catch (MalformedURLException malformedURLException) {
                this.ohNo("Loading loser's document\r" + malformedURLException.toString());
                return;
            }
        }
    }

    public boolean registryOkay() {
        return this.fSerNum != null && this.fRegSitNam != null && this.fSerNum.length() > 0;
    }

    public void ohNo(String string) {
        this.fOhNoCvs.addMessage(string);
        this.showCard(kOhNoPanel);
    }

    public static void version() {
        System.out.println("TileMatch 0.0k");
    }
}

