/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;

public class TileMatchBuffer
extends BufferedCanvas {
    static final int kCncImg = 4;
    static final int kBdrWid = 6;
    static final int kTopMgn = 2;
    static final int kLftMgn = 14;
    static final int kNoBon = 99999;
    static final boolean kBdrFrm = true;
    static final int kPrgMrgWid = 2;
    static final int kPrgMrgHgt = 2;
    static final int kPrgHgt = 15;
    static final int kPrgOff = 60;
    static final int kMaxSndCnt = 10;
    static final String kMgkCod = "\"Easter Egg\"";
    TileMatch fTilApp;
    TileGame fTilGam;
    TileAnimator fTilAni;
    TileSoundPlayer fCntSndPly;
    TileSoundPlayer fPerSndPly;
    TileSoundPlayer fIniSndPly;
    TileSlideShow fTilSldShw;
    TileLoadMgr fIniLodMgr;
    ThreadGroup fLodThrGrp = new ThreadGroup("loaders");
    ThreadGroup fSndThrGrp = new ThreadGroup("sounds");
    boolean fUpdDon = false;
    boolean fTryCntSnd = true;
    boolean fCntSndPlyIng = false;
    boolean fSndCtl = true;
    boolean fEffCtl = true;
    boolean fMscCtl = true;
    boolean fPerCtl = true;
    boolean fBonCtl = true;
    boolean fZomCtl = true;
    boolean fSwpTilCtl = true;
    boolean fSwpBckCtl = true;
    int fPrgNow;
    int fPrgMax;
    int fPrgFac;
    Image fPatImg;
    Image fBckImg;
    int fBckImgNum;
    Image fSdwImg;
    Image[][] fTilImg;
    Color[] fTilClr;
    Color fBckClr = Color.black;
    boolean fPatImgRdy = false;
    boolean fBckImgRdy = false;
    boolean fSdwImgRdy = false;
    boolean fLodRdy = false;
    boolean fBonSho = false;
    boolean fReLod = false;
    int[] fRnkTilCnt;
    int[] fRnkTryCnt;
    int fRnkRdy = -1;
    int[] fTilSetNum;
    int fMaxRnk;
    int fMinWid;
    int fMaxWid;
    int f1stWid;
    int fMinHgt;
    int fMaxHgt;
    int f1stHgt;
    Color fBdrClr = Color.gray;
    int fBdrWid = 6;
    int fTilTrm;
    int fLftMgn = 14;
    int fTopMgn = 2;
    boolean fBdrFrm = true;
    boolean fSdwCtl = false;
    Color fFrmClr = Color.gray;
    Color fHiLitClr = Color.red;
    int fNumPltBit = 12;
    URL fURL;
    int fNumBrdTil;
    int[] fBrdTop;
    int[] fBrdLft;
    int[] fBrdCol;
    int[] fBrdRow;
    int[] fBrdLvl;
    int[][][] fBrdOrd;
    int[] fBonTilLst;
    int[] fBonRnkLst;
    int fBonCnt;
    int fCurBon = -1;
    int fCpyRgtFlg;
    boolean fWin = false;
    boolean fLose = false;
    boolean fShoWin = true;
    boolean fSusGam = false;
    boolean fPlyBegSnd = true;
    int fLstMseUpTil = -1;
    int fMseDwnTil = -1;
    int fLstClkCnt;
    boolean fLstClkCtl = false;
    boolean fLstClkSft = false;
    PaletteMgr fPltMgr;
    static final int kMaxSnd = 20;
    int fNumSnd;
    String[] fSndNamLst;
    AudioClip[] fAudClpLst;
    String fMgkCod = "";

    public TileMatchBuffer(TileMatch tileMatch) {
        this.fTilApp = tileMatch;
        this.setParms();
        this.fURL = this.fTilApp.getDocumentBase();
        this.sizeBuffer();
        this.fTilAni = new TileAnimator(tileMatch);
        this.fPltMgr = new PaletteMgr();
        if (this.fNumPltBit < 16) {
            this.fPltMgr.makePalette(this.fNumPltBit);
        }
    }

    public TileMatchBuffer(TileMatch tileMatch, TileGame tileGame) {
        this.fTilApp = tileMatch;
        this.fTilGam = tileGame;
        this.setParms();
        this.fURL = this.fTilApp.getDocumentBase();
        this.sizeBuffer();
        this.fTilAni = new TileAnimator(tileMatch);
        this.fPltMgr = new PaletteMgr();
        if (this.fNumPltBit < 16) {
            this.fPltMgr.makePalette(this.fNumPltBit);
        }
    }

    public void destroy() {
        int n;
        this.suspendThreads();
        if (this.fTilAni != null) {
            this.fTilAni.stop();
        }
        this.fIniLodMgr.die();
        this.fIniLodMgr = null;
        int n2 = 0;
        while (n2 < this.fTilGam.getNumTil()) {
            n = 0;
            while (n < this.fTilApp.getMaxPerSet()) {
                if (this.fTilImg[n2][n] != null) {
                    this.fTilImg[n2][n].flush();
                }
                this.fTilImg[n2][n] = null;
                ++n;
            }
            ++n2;
        }
        if (this.fBckImg != null) {
            this.fBckImg.flush();
        }
        this.fBckImg = null;
        if (this.fPatImg != null) {
            this.fPatImg.flush();
        }
        this.fPatImg = null;
        if (this.fImgBuf != null) {
            this.fImgBuf.flush();
        }
        n = 0;
        while (n < this.fAudClpLst.length) {
            this.fAudClpLst[n] = null;
            ++n;
        }
        if (this.fCntSndPly != null) {
            this.fCntSndPly.stop();
        }
        this.fCntSndPly = null;
        this.fSndThrGrp.stop();
        this.fImgBuf = null;
        this.fTilApp = null;
        this.fTilGam = null;
        this.fTilAni = null;
        System.gc();
    }

    public void restartThreads() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fSusGam) {
                if (!this.fWin && !this.fLose) {
                    this.continuousSound(false);
                }
                this.periodicSound();
                if (this.fTilAni != null) {
                    this.fTilAni.resume();
                }
            }
            this.fSusGam = false;
            return;
        }
    }

    public void suspendThreads() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            this.stopContinuous();
            this.stopPeriodic();
            if (this.fTilAni != null) {
                this.fTilAni.suspend();
            }
            this.fSusGam = true;
            return;
        }
    }

    public void setUpdateDone(boolean bl) {
        this.fUpdDon = bl;
    }

    public boolean getUpdateDone() {
        return this.fUpdDon;
    }

    public void setGame(TileGame tileGame) {
        this.fTilGam = tileGame;
    }

    public void setParms() {
        this.fFrmClr = this.fTilApp.getFrameColor();
        this.fBdrClr = this.fTilApp.getBorderColor();
        this.fBckClr = this.fTilApp.getBackgroundColor();
        this.fHiLitClr = this.fTilApp.getHiLiteColor();
        this.fSndCtl = this.fTilApp.getSoundOption();
        this.fMscCtl = this.fTilApp.getMusicOption();
        this.fEffCtl = this.fTilApp.getEffectsOption();
        this.fPerCtl = this.fTilApp.getPeriodicOption();
        this.fSdwCtl = this.fTilApp.getShadowsOption();
        this.fBonCtl = this.fTilApp.getBonusOption();
        this.fZomCtl = this.fTilApp.getZoomOption();
        this.fSwpTilCtl = this.fTilApp.getSwapTilesOption();
        this.fSwpBckCtl = this.fTilApp.getSwapBackOption();
        this.fNumPltBit = this.fTilApp.getPaletteBits();
        this.fBdrWid = this.fTilApp.getSideHeight();
        if (!this.fEffCtl && this.fTilAni != null) {
            this.fTilAni.clearAnimation();
        }
        if (!this.fSndCtl && !this.fMscCtl) {
            this.initSoundArrays();
            if (!this.fMscCtl && this.fCntSndPly != null) {
                this.stopContinuous();
                this.fCntSndPly.stop();
                this.fCntSndPly = null;
            }
        }
    }

    public void win() {
        this.fWin = true;
        this.stopContinuous();
        if (this.fTilAni != null) {
            this.fTilAni.redraw();
        } else {
            this.invalidateBuffer();
        }
        this.repaint();
        this.playSound("win.au");
        this.fTilApp.showWinDocument();
        this.fTilApp.showStatus(this.fTilApp.getWinMessage());
    }

    public void lose() {
        this.fLose = true;
        this.stopContinuous();
        if (this.fTilAni != null) {
            this.fTilAni.redraw();
        } else {
            this.invalidateBuffer();
        }
        this.repaint();
        this.playSound("lose.au");
        this.fTilApp.showLoseDocument();
        this.fTilApp.showStatus(this.fTilApp.getLoseMessage());
    }

    public void playing() {
        if (this.fWin || this.fLose) {
            this.fWin = false;
            this.fLose = false;
            this.fShoWin = true;
            this.invalidateBuffer();
            this.repaint();
            this.continuousSound(false);
        }
    }

    public void setNewGame() {
        this.removeBonusImage();
        if (this.fTilAni != null) {
            this.fTilAni.clearAnimation();
        }
        this.fBonCnt = 0;
        this.fCurBon = 99999;
        this.setMargins();
        this.fPlyBegSnd = true;
        this.continuousSound(true);
    }

    public void initArrays() {
        this.initTileSetArrays();
        this.initBoardArrays();
    }

    public void initTileSetArrays() {
        this.fBckImgNum = this.fTilGam.getGameLevel() - 1;
        this.fTilImg = new Image[this.fTilGam.getNumTil()][this.fTilApp.getMaxPerSet()];
        this.fRnkTilCnt = new int[this.fTilApp.getMaxPerSet()];
        this.fRnkTryCnt = new int[this.fTilApp.getMaxPerSet()];
        this.fBonTilLst = new int[this.fTilGam.getTotTil()];
        this.fBonRnkLst = new int[this.fTilGam.getTotTil()];
        this.fTilSetNum = RandomList.newList(this.fTilGam.getNumTil(), this.fTilApp.getTotSets() - 1);
    }

    public void initBoardArrays() {
        int n = this.fTilGam.getNumCol() * this.fTilGam.getNumRow() * this.fTilGam.getNumLvl();
        this.fBrdTop = new int[n];
        this.fBrdLft = new int[n];
        this.fBrdCol = new int[n];
        this.fBrdRow = new int[n];
        this.fBrdLvl = new int[n];
        this.fBrdOrd = new int[this.fTilGam.getNumCol()][this.fTilGam.getNumRow()][this.fTilGam.getNumLvl()];
    }

    public void initSoundArrays() {
        this.fSndNamLst = new String[20 + this.fTilApp.getPeriodicCount()];
        this.fAudClpLst = new AudioClip[20 + this.fTilApp.getPeriodicCount()];
    }

    public void initSounds() {
        if (this.fTilApp.getPreloadSounds() && this.fSndCtl) {
            this.initSoundArrays();
            new TileSoundLoader(this.fTilApp);
        }
    }

    public void initColors() {
        if (this.fTilClr == null) {
            this.fTilClr = new Color[this.fTilGam.getNumTil()];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            Color color = Color.blue;
            while (n < this.fTilGam.getNumTil()) {
                this.fTilClr[n] = color;
                ++n;
                color = color.darker();
                if (++n3 <= 3) continue;
                n3 = 0;
                switch (++n2) {
                    case 1: {
                        color = Color.cyan;
                        break;
                    }
                    case 2: {
                        color = Color.gray;
                        break;
                    }
                    case 3: {
                        color = Color.green;
                        break;
                    }
                    case 4: {
                        color = Color.magenta;
                        break;
                    }
                    case 5: {
                        color = Color.orange;
                        break;
                    }
                    case 6: {
                        color = Color.red;
                        break;
                    }
                    case 7: {
                        color = Color.yellow;
                        break;
                    }
                    case 8: {
                        color = Color.pink;
                        break;
                    }
                    case 9: {
                        color = Color.white;
                        break;
                    }
                }
            }
        }
    }

    public void setMargins() {
        Dimension dimension = this.size();
        this.setMargins(dimension);
    }

    public void setMargins(Dimension dimension) {
        this.setMargins(dimension.width, dimension.height);
    }

    public void setMargins(int n, int n2) {
        int n3 = this.fLftMgn;
        int n4 = this.fTopMgn;
        float f = this.fTilGam.getDrawColumns();
        float f2 = this.fTilGam.getDrawRows();
        int n5 = (int)(f * (float)this.fMaxWid);
        int n6 = this.fBdrWid * this.fTilGam.getMaxRightLevel();
        int n7 = n5 + n6;
        int n8 = n - n7;
        this.fLftMgn = n8 / 2;
        this.fLftMgn = (int)((float)this.fLftMgn + (float)this.fMaxWid * this.fTilGam.getLeftOffset());
        int n9 = (int)(f2 * (float)this.fMaxHgt);
        int n10 = this.fBdrWid * this.fTilGam.getMaxTopLevel();
        int n11 = n9 + n10;
        int n12 = n2 - n11;
        int n13 = this.fBdrWid * (this.fTilGam.getMaxTopLevel() - 1);
        this.fTopMgn = n12 / 2 + n13;
        this.fTopMgn = (int)((float)this.fTopMgn + (float)this.fMaxHgt * this.fTilGam.getTopOffset());
        if (n3 != this.fLftMgn || n4 != this.fTopMgn) {
            this.invalidateBuffer();
            this.repaint(0L);
        }
    }

    public void resetRankTryCounts(int n) {
        int n2 = 0;
        while (n2 < this.fTilApp.getMaxPerSet()) {
            this.fRnkTryCnt[n2] = n;
            ++n2;
        }
    }

    public void loadImages() {
        this.resetProgress(this.needRanks() * this.fTilGam.getNumTil());
        this.initSounds();
        if (this.fSndCtl) {
            this.fIniSndPly = new TileSoundPlayer(this.fTilApp, "init.au", false);
        }
        this.periodicSound();
        this.initArrays();
        this.initColors();
        this.invalidateBuffer();
        this.repaint();
        this.resetRankTryCounts(0);
        this.fIniLodMgr = new TileLoadMgr(this.fTilApp);
        this.fIniLodMgr.start();
    }

    public void swapTileImages() {
        if (this.fLodRdy) {
            TileLoadMgr tileLoadMgr;
            if (this.fBckImg == null || this.fSwpBckCtl && this.fTilApp.swapByRandom() && this.fTilApp.getBackgroundCount(this.fTilGam.getGameLevel(), this.fTilGam.getLayoutName()) > 1) {
                if (this.fBckImg != null) {
                    this.fBckImg.flush();
                }
                this.fBckImg = null;
                tileLoadMgr = new TileLoadMgr(this.fTilApp, 2);
                tileLoadMgr.start();
            }
            if (this.fSwpTilCtl && this.fTilApp.getSetSwap() > 0) {
                this.fTilSetNum = RandomList.replaceList(this.fTilSetNum, this.fTilApp.getSetSave(), this.fTilApp.getTotSets() - 1);
                this.fLodRdy = false;
                this.fReLod = true;
                this.fRnkRdy = -1;
                if (this.fTilApp.getSetSave() > 0) {
                    int n = this.fTilApp.getSetSwap();
                    while (n < this.fTilGam.getNumTil()) {
                        int n2 = n - this.fTilApp.getSetSwap();
                        int n3 = 0;
                        while (n3 < this.fTilApp.getMaxPerSet()) {
                            this.fTilImg[n2][n3] = this.fTilImg[n][n3];
                            if (this.fTilImg[n][n3] != null) {
                                this.fTilImg[n][n3].flush();
                            }
                            this.fTilImg[n][n3] = null;
                            ++n3;
                        }
                        ++n;
                    }
                    System.gc();
                }
                this.resetProgress((this.fTilGam.getNumTil() - this.fTilApp.getSetSave()) * this.needRanks());
                this.resetRankTryCounts(this.fTilApp.getSetSave());
                tileLoadMgr = new TileLoadMgr(this.fTilApp, 12, this.fTilApp.getSetSave());
                tileLoadMgr.start();
                return;
            }
        } else if (this.fBckImg == null) {
            TileLoadMgr tileLoadMgr = new TileLoadMgr(this.fTilApp, 2);
            tileLoadMgr.start();
        }
    }

    public void setLoadReady() {
        this.fLodRdy = true;
        if (this.fReLod) {
            this.fReLod = false;
            this.fTilGam.showLevel();
            this.invalidateBuffer();
            this.repaint(0L);
        }
    }

    public void setRankReady(int n) {
        if (n > this.fRnkRdy) {
            this.fRnkRdy = n;
            if (this.tilesReady()) {
                this.fCpyRgtFlg = 1;
                this.continuousSound(true);
                this.invalidateBuffer();
                this.repaint(0L);
            }
        }
    }

    public boolean tilesReady() {
        return this.fRnkRdy >= this.fTilGam.getGameLevel() - 1 + (this.fTilGam.getTileSet() - 1) || this.fRnkRdy >= this.fTilApp.getMaxPerSet() - 1;
    }

    public int needRanks() {
        int n = this.fTilGam.getGameLevel() + this.fTilGam.getTileSet() - 1;
        if (n > this.fTilApp.getMaxPerSet()) {
            n = this.fTilApp.getMaxPerSet();
        }
        return n;
    }

    public void drawProgress(Graphics graphics) {
        if (!this.tilesReady() && this.fPrgNow < this.fPrgMax && graphics != null) {
            Dimension dimension = this.size();
            int n = (dimension.width - this.fPrgMax + 2) / 2;
            int n2 = (dimension.height - 17) / 2 + 60;
            graphics.setColor(this.fTilApp.getWinColor());
            graphics.fillRect(n - 2, n2 - 2, this.fPrgMax + 4, 19);
            Color color = Color.gray;
            graphics.setColor(color);
            graphics.fillRect(n, n2, this.fPrgNow, 15);
            graphics.setColor(color.brighter().brighter());
            graphics.fillRect(n + 1, n2 + 1, this.fPrgNow - 1, 1);
            graphics.fillRect(n + 1, n2 + 1, 1, 13);
            graphics.setColor(color.brighter());
            graphics.fillRect(n, n2, this.fPrgNow + 1, 1);
            graphics.fillRect(n, n2 + 1, 1, 14);
            graphics.setColor(color.darker());
            graphics.fillRect(n + 1, n2 + 15 - 2, this.fPrgNow - 2, 1);
            graphics.fillRect(n + this.fPrgNow - 1, n2 + 2, 1, 13);
            graphics.setColor(color.darker().darker());
            graphics.fillRect(n, n2 + 15 - 1, this.fPrgNow + 1, 1);
            graphics.fillRect(n + this.fPrgNow, n2 + 1, 1, 13);
        }
    }

    public void updateProgress() {
        this.fPrgNow += this.fPrgFac;
        Graphics graphics = this.getGraphics();
        this.drawProgress(graphics);
    }

    public void resetProgress(int n) {
        this.fPrgNow = 0;
        this.fPrgFac = n < 200 ? 200 / n : 1;
        this.fPrgMax = n * this.fPrgFac;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.setMargins(n3, n4);
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.setMargins(n, n2);
    }

    public void resize(Dimension dimension) {
        super.resize(dimension);
        this.setMargins(dimension);
    }

    public void sizeBuffer() {
    }

    private void adjustBuffer() {
        if (this.fImgBuf == null || this.fTilApp.getGameWidth() != this.fImgBuf.getWidth(null) || this.fTilApp.getGameHeight() != this.fImgBuf.getHeight(null)) {
            this.createBuffer(this.fTilApp.getGameWidth(), this.fTilApp.getGameHeight());
        }
    }

    public boolean paintBuffer(Graphics graphics) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            this.drawBackground(graphics);
            if (this.tilesReady()) {
                this.drawTiles(graphics);
            }
            this.fTilAni.updateSaveBuffer(graphics);
            this.fTilAni.drawAnimated(graphics);
            boolean bl = true;
            Object var4_4 = null;
            return bl;
        }
    }

    public void paintBuffer(Graphics graphics, int n, int n2) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            this.drawBackground(graphics);
            if (this.tilesReady()) {
                this.drawSomeTiles(graphics, n - 2, n2 - 2, n + 2, n2 + 2);
            }
            this.fTilAni.updateSaveBuffer(graphics);
            this.fTilAni.drawAnimated(graphics);
            return;
        }
    }

    public Image copyBuffer(Graphics graphics, Image image) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fImgBuf != null) {
                if (this.fImgBuf.getWidth(null) <= 1 || this.fImgBuf.getHeight(null) <= 1) {
                    Image image2 = image;
                    Object var5_6 = null;
                    return image2;
                }
                Rectangle rectangle = graphics.getClipRect();
                if (rectangle == null) {
                    rectangle = new Rectangle(0, 0, this.fImgBuf.getWidth(null), this.fImgBuf.getHeight(null));
                }
                if (image == null || image.getWidth(null) != this.fImgBuf.getWidth(null) || image.getHeight(null) != this.fImgBuf.getHeight(null)) {
                    image = this.createImage(this.fImgBuf.getWidth(null), this.fImgBuf.getHeight(null));
                    rectangle.x = 0;
                    rectangle.y = 0;
                    rectangle.width = this.fImgBuf.getWidth(null);
                    rectangle.height = this.fImgBuf.getHeight(null);
                }
                if (rectangle.width == 0) {
                    rectangle.width = this.fImgBuf.getWidth(null);
                }
                if (rectangle.height == 0) {
                    rectangle.height = this.fImgBuf.getHeight(null);
                }
                Graphics graphics2 = image.getGraphics();
                graphics2 = graphics2.create();
                graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2.drawImage(this.fImgBuf, 0, 0, null);
                graphics2.dispose();
            }
            Image image3 = image;
            Object var5_7 = null;
            return image3;
        }
    }

    public boolean useAnimation() {
        return this.fEffCtl || this.fBonCtl || this.fZomCtl;
    }

    public void playSound(String string) {
        if (this.fSndCtl) {
            TileSoundPlayer tileSoundPlayer = new TileSoundPlayer(this.fTilApp, string, false);
        }
    }

    public void continuousSound(boolean bl) {
        if (this.fMscCtl) {
            if (this.fTryCntSnd) {
                this.fCntSndPly = new TileSoundPlayer(this.fTilApp, "continuous.au", "start.au");
                this.fTryCntSnd = false;
                this.fCntSndPlyIng = true;
            } else if (this.fCntSndPly != null && !this.fCntSndPlyIng) {
                if (bl) {
                    this.fCntSndPly.loopStart();
                } else {
                    this.fCntSndPly.loopResume();
                }
                this.fCntSndPlyIng = true;
            }
        } else {
            this.stopContinuous();
            if (bl && this.fPlyBegSnd) {
                this.playSound("start.au");
            }
        }
        if (bl) {
            this.fPlyBegSnd = false;
        }
    }

    public void stopContinuous() {
        if (this.fCntSndPly != null && this.fCntSndPlyIng) {
            this.fCntSndPly.loopStop();
            this.fCntSndPlyIng = false;
        }
    }

    public void periodicSound() {
        if (this.fSndCtl && this.fPerCtl) {
            if (this.fPerSndPly == null) {
                this.fPerSndPly = new TileSoundPlayer(this.fTilApp, "periodic", this.fTilApp.getPeriodicCount(), this.fTilApp.getPeriodicTime());
                return;
            }
        } else {
            this.stopPeriodic();
        }
    }

    public void stopPeriodic() {
        if (this.fPerSndPly != null) {
            if (this.fPerSndPly.isAlive()) {
                this.fPerSndPly.stop();
            }
            this.fPerSndPly = null;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
        this.fUpdDon = true;
    }

    public void paint(Graphics graphics) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            super.paint(graphics);
            return;
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        int n3 = n + this.fOffWid;
        int n4 = n2 + this.fOffHgt;
        this.fLstClkCnt = event.clickCount;
        this.fLstClkCtl = this.myModifierDown(event);
        this.fLstClkSft = this.myOtherModifierDown(event);
        int n5 = this.fNumBrdTil;
        while (n5 > 0) {
            if (this.fBrdLft[--n5] > n3 || this.fBrdLft[n5] + this.fMaxWid < n3 || this.fBrdTop[n5] > n4 || this.fBrdTop[n5] + this.fMaxHgt < n4) continue;
            this.preSelect(n5);
            return true;
        }
        this.unPreSelect();
        return super.mouseDown(event, n, n2);
    }

    public void preSelect(int n) {
        this.fMseDwnTil = n;
    }

    public void unPreSelect() {
        int n = this.fMseDwnTil;
        this.fMseDwnTil = -1;
        if (n >= 0) {
            this.redrawTile(n);
            this.repaint();
        }
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.fCpyRgtFlg == 0) {
            this.fCpyRgtFlg = 1;
        }
        if (this.fCpyRgtFlg > 0) {
            this.fTilApp.showStatus("Program Copyright 1998 by Robert N. Lacatena.  All rights reserved.");
        } else {
            this.fTilApp.showStatus(this.fTilApp.getImageCopyright());
        }
        this.fCpyRgtFlg *= -1;
        if (this.fBonSho) {
            if (this.fTilSldShw != null) {
                this.continueSlideShow();
            } else {
                this.removeBonusImage();
            }
            this.unPreSelect();
            return true;
        }
        if (this.fWin) {
            this.messageToggle();
            return true;
        }
        int n3 = n + this.fOffWid;
        int n4 = n2 + this.fOffHgt;
        int n5 = this.fNumBrdTil;
        while (n5 > 0) {
            if (this.fBrdLft[--n5] > n3 || this.fBrdLft[n5] + this.fMaxWid < n3 || this.fBrdTop[n5] > n4 || this.fBrdTop[n5] + this.fMaxHgt < n4) continue;
            if (n5 == this.fMseDwnTil) {
                if (this.fLstClkCnt == 2 && this.fZomCtl && n5 == this.fLstMseUpTil) {
                    int n6 = this.fBrdCol[n5];
                    int n7 = this.fBrdRow[n5];
                    int n8 = this.fBrdLvl[n5];
                    int n9 = this.fTilGam.getTileNumber(n6, n7, n8);
                    int n10 = this.fTilGam.getTileRank(n6, n7, n8);
                    this.requestZoomImage(n9, n10, n6, n7, n8);
                    this.unPreSelect();
                } else {
                    this.fMseDwnTil = -1;
                    if (this.fLstClkCtl) {
                        int n11 = this.fBrdCol[n5];
                        int n12 = this.fBrdRow[n5];
                        int n13 = this.fBrdLvl[n5];
                        int n14 = this.fTilGam.getTileNumber(n11, n12, n13);
                        this.fTilGam.undoToTile(n14);
                    } else if (this.fLstClkSft) {
                        int n15 = this.fBrdCol[n5];
                        int n16 = this.fBrdRow[n5];
                        int n17 = this.fBrdLvl[n5];
                        int n18 = this.fTilGam.getTileNumber(n15, n16, n17);
                        this.fTilGam.redoToTile(n18);
                    } else {
                        this.fTilGam.selectTile(this.fBrdCol[n5], this.fBrdRow[n5], this.fBrdLvl[n5]);
                    }
                }
            } else {
                this.unPreSelect();
            }
            this.fLstMseUpTil = n5;
            return true;
        }
        this.unPreSelect();
        return super.mouseUp(event, n, n2);
    }

    public void setNewLevel() {
        if (this.fTilApp.swapByRandom() || this.fTilApp.swapByLevel()) {
            this.fBckImgNum = this.fTilGam.getGameLevel() - 1;
            if (this.fBckImg != null) {
                this.fBckImg.flush();
            }
            this.fBckImg = null;
            this.fBckImgRdy = false;
        }
    }

    public void setNewLayout() {
        if (this.fTilApp.swapByRandom() || this.fTilApp.swapByLayout()) {
            if (this.fBckImg != null) {
                this.fBckImg.flush();
            }
            this.fBckImg = null;
            this.fBckImgRdy = false;
        }
    }

    public void shadowToggle(boolean bl) {
        this.fSdwCtl = bl;
        this.invalidateBuffer();
        this.repaint();
    }

    public void messageToggle() {
        this.fShoWin = !this.fShoWin;
        this.invalidateBuffer();
        this.repaint();
    }

    public boolean myModifierDown(Event event) {
        return event.metaDown() || event.controlDown();
    }

    public boolean myOtherModifierDown(Event event) {
        return event.shiftDown();
    }

    public boolean keyDown(Event event, int n) {
        if (event.controlDown() && n < 32 && n != 8) {
            n += 64;
        }
        if (event.id == 401) {
            char c = (char)n;
            this.fMgkCod = String.valueOf(this.fMgkCod) + c;
            if (kMgkCod.startsWith(this.fMgkCod)) {
                if (this.fMgkCod.equals(kMgkCod)) {
                    this.fTilApp.toggleMagikMode();
                    this.playSound("bonus.au");
                    return true;
                }
                return true;
            }
            this.fMgkCod = "";
            if (this.fTilApp.getMagikMode() && (n == 118 || n == 86)) {
                this.listVersions();
                return true;
            }
            if (n == 8 || n == 32 || n == 117 || n == 85) {
                if (this.myModifierDown(event)) {
                    this.fTilGam.undoToMark();
                } else {
                    this.fTilGam.undoLastMove();
                }
                return true;
            }
            if (n == 114 || n == 82) {
                if (this.myModifierDown(event)) {
                    this.fTilGam.redoToMark();
                } else {
                    this.fTilGam.redoLastMove();
                }
                return true;
            }
            if (n == 111 || n == 79) {
                this.fTilApp.showCard("Options");
                return true;
            }
            if (n == 42) {
                this.fTilApp.sharewareFrame();
                return true;
            }
            if (n == 101 || n == 69) {
                this.fTilApp.showCard("OhNo");
                return true;
            }
            if (n == 104 || n == 72) {
                this.fTilApp.showCard("Help");
                return true;
            }
            if (n == 109 || n == 77) {
                this.fTilGam.markPosition();
                return true;
            }
            if (n == 63) {
                this.fTilGam.showLevel();
                return true;
            }
            if (this.myModifierDown(event) && (n == 108 || n == 76)) {
                this.fTilGam.getNextLayout();
                return true;
            }
            if (this.fTilApp.getMagikMode() && this.myModifierDown(event) && (n == 119 || n == 87)) {
                if (this.myOtherModifierDown(event)) {
                    this.fTilApp.increaseDifficulty();
                } else {
                    this.fTilApp.toggleWinnable();
                }
                return true;
            }
            if (n == 119 || n == 87) {
                this.fTilApp.useFrame();
                return true;
            }
            if (this.fTilApp.getMagikMode() && this.myModifierDown(event) && (n == 97 || n == 65 || n == 47 || n == 92)) {
                if (this.myOtherModifierDown(event)) {
                    this.fTilGam.toggleAutoplay();
                } else {
                    this.fTilGam.proveWinnable();
                }
                return true;
            }
            if (this.myModifierDown(event) && (n == 105 || n == 73)) {
                this.fTilGam.getNextLayout();
                return true;
            }
            if (n == 122 || n == 90) {
                this.startSlideShow();
                return true;
            }
            if (n == 46) {
                this.stopSlideShow();
                return true;
            }
            if (this.myModifierDown(event) && (n == 120 || n == 88)) {
                this.shadowToggle(!this.fSdwCtl);
                return true;
            }
            if (this.myModifierDown(event) && (n == 115 || n == 83)) {
                this.fTilGam.restartGame(false);
                return true;
            }
            if (this.myModifierDown(event) && (n == 110 || n == 78)) {
                this.fTilGam.newGame();
                return true;
            }
            if (this.myModifierDown(event) && (n == 99 || n == 67)) {
                this.fTilGam.nextClue();
                return true;
            }
            if (n == 98 || n == 66) {
                this.nextBonusImage();
                return true;
            }
            if (n == 102 || n == 70) {
                this.previousBonusImage();
                return true;
            }
            if (this.myModifierDown(event) && n >= 49 && n <= 57) {
                int n2 = n - 48;
                if (this.myOtherModifierDown(event)) {
                    this.fTilGam.setTileSet(n2);
                } else {
                    this.fTilGam.setGameLevel(n2);
                }
                return true;
            }
        }
        if (event.id == 401) {
            if (this.myModifierDown(event) && n == 1004) {
                this.fTilGam.setGameLevel(this.fTilGam.getGameLevel() + 1);
                return true;
            }
            if (this.myModifierDown(event) && n == 1005) {
                this.fTilGam.setGameLevel(this.fTilGam.getGameLevel() - 1);
                return true;
            }
            if (this.myModifierDown(event) && n == 1006) {
                this.fTilGam.setTileSet(this.fTilGam.getTileSet() + 1);
                return true;
            }
            if (this.myModifierDown(event) && n == 1007) {
                this.fTilGam.setTileSet(this.fTilGam.getTileSet() - 1);
                return true;
            }
        }
        this.fTilApp.showCard("Help");
        this.fTilApp.showStatus("Click anywhere in the help text to return to the game.");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AudioClip getAudioClip(String string) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fSndNamLst == null || this.fAudClpLst == null) {
                this.initSoundArrays();
            }
            int n = 0;
            while (n < this.fNumSnd) {
                if (this.fSndNamLst[n] != null && string.equals(this.fSndNamLst[n])) {
                    return this.fAudClpLst[n];
                }
                ++n;
            }
            ++this.fNumSnd;
            if (this.fNumSnd >= 20) {
                this.fTilApp.ohNo("INTERNAL ERROR: Too many sounds (" + string + ")");
                return null;
            }
            this.fSndNamLst[this.fNumSnd - 1] = string;
        }
        this.fAudClpLst[this.fNumSnd - 1] = this.fTilApp.getAudioClip(this.fTilApp.getDocumentBase(), string);
        return this.fAudClpLst[this.fNumSnd - 1];
    }

    public void requestBonusImage(int n, int n2, boolean bl) {
        if (bl) {
            this.removeBonusImage();
        }
        TileLoadMgr tileLoadMgr = new TileLoadMgr(this.fTilApp, 32, n, n2);
        tileLoadMgr.start();
    }

    public void requestZoomImage(int n, int n2, int n3, int n4, int n5) {
        this.removeBonusImage();
        int n6 = this.getTileX(n3, n4, n5, this.fMaxWid, this.fMaxHgt) + this.fMaxWid / 2;
        int n7 = this.getTileY(n3, n4, n5, this.fMaxWid, this.fMaxHgt) + this.fMaxHgt / 2;
        TileLoadMgr tileLoadMgr = new TileLoadMgr(this.fTilApp, 64, n, n2, n6, n7);
        tileLoadMgr.start();
    }

    public void setPatternImage(Image image) {
        this.fPatImgRdy = true;
        this.fPatImg = image;
        this.invalidateBuffer();
        this.repaint(0L);
        this.fTilApp.repaint(0L);
        this.fTilGam.showLevel();
    }

    public void setBackgroundImage(Image image, int n) {
        this.fBckImgRdy = true;
        this.fBckImg = image;
        this.invalidateBuffer();
        this.repaint();
        this.fTilGam.showLevel();
    }

    public void setShadowImage(Image image) {
        this.fSdwImgRdy = true;
        this.fSdwImg = image;
        this.invalidateBuffer();
        this.repaint();
    }

    public void setZoomImage(Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        if (image != null) {
            TileMatch tileMatch = this.fTilApp;
            synchronized (tileMatch) {
                this.fBonSho = true;
                this.fTilAni.addBonus(image, n, n3, n4, n5, n6);
                this.playSound("zoom.au");
                String string = this.fTilApp.getCaption(this.fTilSetNum[n]);
                if (string == null) {
                    this.fTilApp.showStatus("Zoom image shown.");
                } else {
                    this.fTilApp.showStatus(string);
                }
                return;
            }
        }
    }

    public void setBonusImage(Image image, int n, int n2) {
        if (image != null) {
            TileMatch tileMatch = this.fTilApp;
            synchronized (tileMatch) {
                this.fBonSho = true;
                this.playSound("bonus.au");
                String string = this.fTilApp.getCaption(this.fTilSetNum[n]);
                if (string == null) {
                    this.fTilApp.showStatus("Bonus image shown.");
                } else {
                    this.fTilApp.showStatus(string);
                }
                this.fTilAni.addBonus(image, n, string);
                int n3 = 0;
                while (n3 < this.fBonCnt) {
                    if (this.fBonTilLst[n3] == n && this.fBonRnkLst[n3] == n2) {
                        Object var5_7 = null;
                        return;
                    }
                    ++n3;
                }
                this.fBonTilLst[this.fBonCnt] = n;
                this.fBonRnkLst[this.fBonCnt] = n2;
                this.fCurBon = this.fBonCnt++;
                return;
            }
        }
    }

    public void removeBonusImage() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            this.fBonSho = this.fTilAni.removeBonus();
            this.fCurBon = 99999;
            return;
        }
    }

    public void startSlideShow() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            this.stopSlideShow();
            this.fTilSldShw = new TileSlideShow(this.fTilApp);
            return;
        }
    }

    public void stopSlideShow() {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fTilSldShw != null) {
                this.fTilSldShw.stop();
                this.removeBonusImage();
                this.fTilSldShw = null;
            }
            return;
        }
    }

    public void continueSlideShow() {
        TileSlideShow tileSlideShow = this.fTilSldShw;
        synchronized (tileSlideShow) {
            this.fTilSldShw.notify();
            return;
        }
    }

    public void nextBonusImage() {
        this.nextBonusImage(true);
    }

    public void nextBonusImage(boolean bl) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fBonCnt > 0) {
                this.fCurBon = this.fCurBon == 99999 ? this.fBonCnt - 1 : --this.fCurBon;
                if (this.fCurBon < 0) {
                    this.fCurBon = 99999;
                    this.removeBonusImage();
                    this.playSound("invalid.au");
                    this.fTilApp.showStatus("No more bonus images.");
                    this.stopSlideShow();
                } else {
                    int n = this.fCurBon;
                    this.requestBonusImage(this.fBonTilLst[this.fCurBon], this.fBonRnkLst[this.fCurBon], bl);
                    this.fCurBon = n;
                }
            } else {
                this.removeBonusImage();
                this.playSound("invalid.au");
                this.fTilApp.showStatus("No bonus images.");
                this.stopSlideShow();
            }
            return;
        }
    }

    public void previousBonusImage() {
        this.previousBonusImage(true);
    }

    public void previousBonusImage(boolean bl) {
        TileMatch tileMatch = this.fTilApp;
        synchronized (tileMatch) {
            if (this.fBonCnt > 0) {
                this.fCurBon = this.fCurBon == 99999 ? 0 : ++this.fCurBon;
                if (this.fCurBon >= this.fBonCnt) {
                    this.fCurBon = 99999;
                    this.removeBonusImage();
                    this.playSound("invalid.au");
                    this.fTilApp.showStatus("No more bonus images.");
                    this.stopSlideShow();
                } else {
                    int n = this.fCurBon;
                    this.requestBonusImage(this.fBonTilLst[this.fCurBon], this.fBonRnkLst[this.fCurBon], bl);
                    this.fCurBon = n;
                }
            } else {
                this.removeBonusImage();
                this.playSound("invalid.au");
                this.fTilApp.showStatus("No bonus images.");
                this.stopSlideShow();
            }
            return;
        }
    }

    public void setTileImage(Image image, int n, int n2) {
        if (image != null) {
            if (this.fTilImg[n][n2] == null) {
                int n3 = n2;
                this.fRnkTilCnt[n3] = this.fRnkTilCnt[n3] + 1;
                if (n2 > this.fMaxRnk) {
                    this.fMaxRnk = n2;
                }
            }
            int n4 = image.getWidth(null) + this.getFrameAdd();
            int n5 = image.getHeight(null) + this.getFrameAdd();
            if (n4 > this.fMaxWid) {
                this.fMaxWid = n4;
            }
            if (n5 > this.fMaxHgt) {
                this.fMaxHgt = n5;
            }
            if (n4 < this.fMinWid || this.fMinWid == 0) {
                this.fMinWid = n4;
            }
            if (n5 < this.fMinHgt || this.fMinHgt == 0) {
                this.fMinHgt = n5;
            }
            if (this.f1stWid == 0 || this.f1stHgt == 0) {
                this.setMargins();
            }
            if (this.f1stWid == 0) {
                this.f1stWid = n4;
            }
            if (this.f1stHgt == 0) {
                this.f1stHgt = n5;
            }
            if (this.f1stHgt != n5 || this.f1stWid != n4) {
                this.fTilApp.ohNo("Tile " + Integer.toString(this.fTilSetNum[n] + this.fTilApp.getTileBase()) + ", rank " + Integer.toString(n2 + this.fTilApp.getRankBase()) + " is " + Integer.toString(n4) + " by " + Integer.toString(n5) + " (1st was " + Integer.toString(this.f1stWid) + " by " + Integer.toString(this.f1stHgt) + ").");
            }
        }
        this.fTilImg[n][n2] = image;
        int n6 = n2;
        this.fRnkTryCnt[n6] = this.fRnkTryCnt[n6] + 1;
        if (this.fRnkTryCnt[n2] >= this.fTilApp.getPlaySets()) {
            this.setRankReady(n2);
        }
        this.updateProgress();
    }

    public int getFrameAdd() {
        if (this.fTilApp.getFrameInset()) {
            return 0;
        }
        return this.fTilApp.getFrameWidth() * 2;
    }

    public void setTileTrim(int n) {
        this.fTilTrm = n;
        this.updateProgress();
        this.invalidateBuffer();
        this.repaint();
    }

    public void tileMoved(int n, int n2, int n3) {
        if (n >= 0) {
            this.redrawTile(n, n2, n3, this.fMaxWid, this.fMaxHgt);
            this.repaint();
        }
    }

    public void removeEffect(int n, int n2, int n3) {
        if (this.fEffCtl) {
            int n4 = this.getTileX(n, n2, n3, this.fMaxWid, this.fMaxHgt) + this.fBdrWid;
            int n5 = this.getTileY(n, n2, n3, this.fMaxWid, this.fMaxHgt) - this.fBdrWid;
            Image image = this.getTileImage(n, n2, n3);
            Color color = this.fTilClr[this.fTilGam.getTileNumber(n, n2, n3)];
            this.fTilAni.addEffectObject(image, n4, n5, this.fMaxWid, this.fMaxHgt, color, this.fTilApp.getRemoveEffect());
        }
    }

    public void tilesRemoved(int n, int n2, int n3, int n4, int n5, int n6) {
        this.removeEffect(n, n2, n3);
        this.removeEffect(n4, n5, n6);
        this.tileMoved(n, n2, n3);
        this.tileMoved(n4, n5, n6);
    }

    public void drawBackground(Graphics graphics) {
        int n;
        int n2;
        int n3;
        Dimension dimension;
        if (this.fBckImg != null && this.fBckImgRdy && this.tilesReady()) {
            dimension = this.size();
            n3 = this.fBckImg.getWidth(null);
            n2 = this.fBckImg.getHeight(null);
            n = (dimension.width - n3) / 2;
            int n4 = (dimension.height - n2) / 2;
            if (n3 < dimension.width || n2 < dimension.height) {
                graphics.setColor(this.fBckClr);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
            graphics.drawImage(this.fBckImg, n, n4, this.fTilApp);
        } else if (this.fPatImg != null && this.fPatImgRdy) {
            dimension = this.size();
            n3 = this.fPatImg.getWidth(null);
            n2 = this.fPatImg.getHeight(null);
            n = 0;
            while (n < dimension.height && n2 > 0) {
                int n5 = 0;
                while (n5 < dimension.width && n3 > 0) {
                    graphics.drawImage(this.fPatImg, n5, n, this.fTilApp);
                    n5 += n3;
                }
                n += n2;
            }
        } else {
            dimension = this.size();
            graphics.setColor(this.fBckClr);
            if (dimension.width == 0) {
                graphics.fillRect(0, 0, 700, 500);
            } else {
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
        }
        if (this.fCpyRgtFlg == 0 && !this.fLodRdy) {
            FontMetrics fontMetrics;
            dimension = this.size();
            Font font = graphics.getFont();
            n2 = 12;
            if (font != null) {
                font = new Font(font.getName(), 0, 12);
                graphics.setFont(font);
            }
            if ((fontMetrics = this.getFontMetrics(this.getFont())) != null) {
                n2 = fontMetrics.getHeight();
            }
            graphics.setColor(this.fTilApp.getWinColor());
            graphics.drawString("Program Copyright 1998 by Robert N. Lacatena.  All rights reserved.", 5, dimension.height - n2 * 2);
            graphics.drawString(this.fTilApp.getImageCopyright(), 5, dimension.height - n2);
        }
    }

    public void drawForeground(Graphics graphics) {
        Font font;
        Dimension dimension = this.size();
        if (!this.tilesReady()) {
            graphics.setColor(Color.red);
            font = graphics.getFont();
            font = font != null ? new Font(font.getName(), 1, 24) : new Font("Serif", 1, 24);
            if (font != null) {
                graphics.setFont(font);
            }
            String string = "Please Wait...";
            int n = 200;
            int n2 = 20;
            if (font != null) {
                FontMetrics fontMetrics = this.getFontMetrics(font);
                n = fontMetrics.stringWidth(string);
                n2 = fontMetrics.getHeight();
            }
            int n3 = (dimension.width - n) / 2;
            int n4 = (dimension.height - n2) / 2;
            graphics.drawString(string, n3, n4);
            this.drawProgress(graphics);
        }
        if (this.fWin && this.fShoWin) {
            graphics.setColor(this.fTilApp.getWinColor());
            font = new Font(this.fTilApp.getWinFont(), 1, this.fTilApp.getWinSize());
            if (font == null) {
                font = graphics.getFont();
                font = font != null ? new Font(font.getName(), 1, this.fTilApp.getWinSize()) : new Font("Serif", 1, this.fTilApp.getWinSize());
            }
            if (font != null) {
                graphics.setFont(font);
            }
            graphics.drawString(this.fTilApp.getWinMessage(), this.fTilApp.getWinLeft(), this.fTilApp.getWinTop());
        }
        if (this.fLose) {
            graphics.setColor(this.fTilApp.getLoseColor());
            font = new Font(this.fTilApp.getLoseFont(), 1, this.fTilApp.getLoseSize());
            if (font == null) {
                font = graphics.getFont();
                font = font != null ? new Font(font.getName(), 1, this.fTilApp.getLoseSize()) : new Font("Serif", 1, this.fTilApp.getLoseSize());
            }
            if (font != null) {
                graphics.setFont(font);
            }
            graphics.drawString(this.fTilApp.getLoseMessage(), this.fTilApp.getLoseLeft(), this.fTilApp.getLoseTop());
        }
    }

    public void redrawTile(int n) {
        this.redrawTile(this.fBrdCol[n], this.fBrdRow[n], this.fBrdLvl[n], this.fMaxWid, this.fMaxHgt);
    }

    public void redrawTile(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getTileX(n, n2, n3, n4, n5);
        int n7 = this.getTileY(n, n2, n3, n4, n5);
        Graphics graphics = this.fImgBuf.getGraphics();
        graphics = graphics.create();
        graphics.clipRect(n6 - 2 * this.fBdrWid, n7 - 2 * this.fBdrWid, n4 + this.fBdrWid * 4, n5 + this.fBdrWid * 4);
        this.paintBuffer(graphics, n, n2);
        graphics.dispose();
    }

    public boolean isPreSelected(int n, int n2, int n3) {
        return this.fMseDwnTil >= 0 && n == this.fBrdCol[this.fMseDwnTil] && n2 == this.fBrdCol[this.fMseDwnTil] && n3 == this.fBrdCol[this.fMseDwnTil];
    }

    public void drawSomeTiles(Graphics graphics, int n, int n2, int n3, int n4) {
        n = Math.max(0, n);
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, this.fTilGam.getNumCol() - 1);
        n4 = Math.min(n4, this.fTilGam.getNumRow() - 1);
        if (this.fTilGam.isGameReady()) {
            boolean bl = this.fNumBrdTil == 0;
            int n5 = 0;
            while (n5 < this.fTilGam.getNumLvl()) {
                int n6;
                int n7;
                if (this.fSdwCtl) {
                    n7 = n2;
                    while (n7 <= n4) {
                        n6 = n3;
                        while (n6 >= n) {
                            this.drawShadow(graphics, n6, n7, n5, this.fMaxWid, this.fMaxHgt);
                            --n6;
                        }
                        ++n7;
                    }
                }
                n7 = 0;
                while (n7 <= n4) {
                    n6 = n3;
                    while (n6 >= n) {
                        Point point = this.drawTile(graphics, n6, n7, n5, this.fMaxWid, this.fMaxHgt, this.fBdrWid, this.fTilTrm);
                        if (bl) {
                            this.fBrdOrd[n6][n7][n5] = this.fNumBrdTil;
                            this.fBrdCol[this.fNumBrdTil] = n6;
                            this.fBrdRow[this.fNumBrdTil] = n7;
                            this.fBrdLvl[this.fNumBrdTil] = n5;
                            ++this.fNumBrdTil;
                        }
                        int n8 = this.fBrdOrd[n6][n7][n5];
                        this.fBrdLft[n8] = point.x;
                        this.fBrdTop[n8] = point.y;
                        if (this.fTilGam.isTileThere(n6, n7, n5) && this.fTilGam.isTileThere(n6 - 1, n7 - 1, n5) && this.fTilGam.isTileVisible(n6 - 1, n7 - 1, n5) && this.fTilGam.yOffset(n6 - 1, n7 - 1, n5) > 0) {
                            Graphics graphics2 = graphics.create();
                            graphics2.getClipRect();
                            graphics2.clipRect(this.getTileX(n6, n7, n5, this.fMaxWid, this.fMaxHgt) - this.fBdrWid, this.getTileY(n6, n7, n5, this.fMaxWid, this.fMaxHgt), this.fBdrWid, this.fMaxHgt + this.fBdrWid);
                            this.drawTile(graphics2, n6 - 1, n7 - 1, n5, this.fMaxWid, this.fMaxHgt, this.fBdrWid, this.fTilTrm);
                            graphics2.dispose();
                        }
                        if (this.fTilGam.isSelected(n6, n7, n5 - 1) || this.isPreSelected(n6, n7, n5 - 1)) {
                            this.drawContent(graphics, n6, n7, n5 - 1, this.fMaxWid, this.fMaxHgt, this.fTilTrm);
                        }
                        --n6;
                    }
                    ++n7;
                }
                n6 = n2;
                while (n6 <= n4) {
                    int n9 = n3;
                    while (n9 >= n) {
                        this.drawHilite(graphics, n9, n6, n5, this.fMaxWid, this.fMaxHgt, this.fTilTrm);
                        --n9;
                    }
                    ++n6;
                }
                ++n5;
            }
        }
    }

    public void drawTiles(Graphics graphics) {
        this.fNumBrdTil = 0;
        this.drawSomeTiles(graphics, 0, 0, this.fTilGam.getNumCol() - 1, this.fTilGam.getNumRow() - 1);
    }

    public int getBackgroundNum() {
        return this.fBckImgNum;
    }

    public int getTileSetNum(int n) {
        return this.fTilSetNum[n];
    }

    public int getTileWidth() {
        return this.fMaxWid;
    }

    public int getTileHeight() {
        return this.fMaxHgt;
    }

    public Image getTileImage(int n, int n2) {
        return this.fTilImg[n][n2];
    }

    public Image getTileImage(int n, int n2, int n3) {
        int n4 = this.fTilGam.getTileNumber(n, n2, n3);
        int n5 = this.fTilGam.getTileRank(n, n2, n3);
        int n6 = -1;
        int n7 = 0;
        while (this.fTilImg[n4][n5] == null && n7 < this.fTilApp.getMaxPerSet()) {
            ++n7;
            n5 = (n5 + n6) % this.fTilApp.getMaxPerSet();
            n6 = n6 < 0 ? -n6 + 1 : -(n6 + 1);
        }
        return this.fTilImg[n4][n5];
    }

    public int getTileX(int n, int n2, int n3, int n4, int n5) {
        int n6 = n * n4 + this.fLftMgn + n3 * this.fBdrWid;
        n6 += this.fTilGam.xOffset(n, n2, n3) * n4 / 2;
        if (this.fTilGam.isSelected(n, n2, n3) || this.isPreSelected(n, n2, n3)) {
            n6 += this.fBdrWid / 2;
        }
        return n6;
    }

    public int getTileY(int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 * n5 + this.fTopMgn - n3 * this.fBdrWid;
        n6 += this.fTilGam.yOffset(n, n2, n3) * n5 / 2;
        if (this.fTilGam.isSelected(n, n2, n3) || this.isPreSelected(n, n2, n3)) {
            n6 -= this.fBdrWid / 2;
        }
        return n6;
    }

    public Image getPattern() {
        if (this.fPatImgRdy) {
            return this.fPatImg;
        }
        return null;
    }

    public Color getBackColor() {
        return this.fBckClr;
    }

    public int getBorderWidth() {
        return this.fBdrWid;
    }

    public int getTileImageWidth() {
        return this.fBdrWid + this.fMaxWid + 1;
    }

    public int getTileImageHeight() {
        return this.fBdrWid + this.fMaxHgt + 1;
    }

    public void drawTile(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color, boolean bl) {
        this.drawBorder(graphics, n, n2, n3, n4, n5, n6);
        this.drawContent(graphics, image, n, n2, n3, n4, n6, color, bl);
    }

    public Point drawTile(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.drawBorder(graphics, n, n2, n3, n4, n5, n6, n7);
        return this.drawContent(graphics, n, n2, n3, n4, n5, n7);
    }

    public void drawBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 < 0) {
            n5 = this.fBdrWid * n5 * -1;
        }
        if (n6 < 0) {
            n6 = this.fTilTrm * n6 * -1;
        }
        n -= n5;
        Color color = this.fBdrClr;
        int n7 = 0;
        while (n7 < n5) {
            graphics.setColor(color);
            color = color.darker();
            int n8 = n2 + (n5 - n7) + n6;
            int n9 = n8 + (n4 - 1) - 2 * n6;
            int n10 = n + n7;
            graphics.drawLine(n10, n8, n10, n9);
            int n11 = n2 + n4 + (n5 - (n7 + 1));
            int n12 = n + n7 + n6;
            int n13 = n12 + (n3 - 1) - 2 * n6;
            graphics.drawLine(n12, n11, n13, n11);
            if (n6 != 0) {
                int n14 = n10 + n6;
                int n15 = n9 + n6;
                graphics.drawLine(n10, n9, n14, n15);
                graphics.drawLine(n10 + 1, n9, n14 + 1, n15);
            }
            ++n7;
        }
    }

    public void drawBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.fTilGam.isTileThere(n, n2, n3)) {
            int n8 = this.getTileX(n, n2, n3, n4, n5);
            int n9 = this.getTileY(n, n2, n3, n4, n5);
            this.drawBorder(graphics, n8, n9, n4, n5, n6, n7);
        }
    }

    public void drawShadow(Graphics graphics, int n, int n2, int n3, int n4) {
        if (!this.fSdwCtl) {
            return;
        }
        int n5 = n + this.fBdrWid;
        int n6 = n2 - this.fBdrWid;
        graphics.drawImage(this.fSdwImg, n5, n6, null);
    }

    public void drawShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (this.fSdwImgRdy && this.fTilGam.isTileThere(n, n2, n3) && this.fTilGam.isTileVisible(n, n2, n3)) {
            if (this.fTilGam.isTileThere(n + 1, n2, n3) && this.fTilGam.isTileThere(n, n2 - 1, n3) && this.fTilGam.isTileThere(n + 1, n2 - 1, n3)) {
                return;
            }
            int n6 = this.getTileX(n, n2, n3, n4, n5);
            int n7 = this.getTileY(n, n2, n3, n4, n5);
            this.drawShadow(graphics, n6, n7, n4, n5);
        }
    }

    public void drawHilite(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n5 < 0) {
            n5 = this.fTilTrm * n5 * -1;
        }
        graphics.setColor(this.fHiLitClr);
        graphics.drawRoundRect(n, n2, n3, n4, n5 * 4, n5 * 4);
    }

    public void drawHilite(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.fTilGam.isTileThere(n, n2, n3) && (this.fTilGam.isTileVisible(n, n2, n3) || this.fTilGam.isSelected(n, n2, n3 + 1) || this.isPreSelected(n, n2, n3 + 1)) && this.fTilGam.isHighlighted(n, n2, n3)) {
            int n7 = this.getTileX(n, n2, n3, n4, n5);
            int n8 = this.getTileY(n, n2, n3, n4, n5);
            this.drawHilite(graphics, n7, n8, n4, n5, n6);
        }
    }

    public void drawContent(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        int n6;
        if ((n3 <= 1 || n4 <= 1) && image != null) {
            n3 = image.getWidth(null);
            n4 = image.getHeight(null);
        }
        if (n5 < 0) {
            n5 = this.fTilTrm * n5 * -1;
        }
        if (image != null) {
            if (this.fTilApp.getFrameInset()) {
                graphics.drawImage(image, n, n2, null);
            } else {
                graphics.drawImage(image, n + this.fTilApp.getFrameWidth(), n2 + this.fTilApp.getFrameWidth(), null);
            }
        } else {
            graphics.setColor(color);
            graphics.fillRoundRect(n, n2, n3, n4, n5, n5);
        }
        Color color2 = this.fFrmClr;
        if (bl) {
            color2 = this.fHiLitClr;
        }
        graphics.setColor(color2);
        int n7 = this.fTilApp.getFrameWidth();
        int n8 = this.fTilApp.getFrameFade();
        int n9 = n6 = this.fTilApp.getFrameInset() ? 0 : 1;
        if ((bl || this.fBdrFrm) && n3 > 1 && n4 > 1) {
            int n10 = 0;
            while (n10 < n7) {
                graphics.drawRoundRect(n + n10, n2 + n10, n3 - n10 * 2 - n6, n4 - n10 * 2 - n6, n5 * 4, n5 * 4);
                switch (n8) {
                    case 1: {
                        color2 = color2.brighter();
                        graphics.setColor(color2);
                        break;
                    }
                    case 2: {
                        color2 = color2.darker();
                        graphics.setColor(color2);
                        break;
                    }
                    case 3: {
                        color2 = ColorPicker.paler(color2);
                        color2 = ColorPicker.paler(color2);
                        color2 = ColorPicker.paler(color2);
                        graphics.setColor(color2);
                        break;
                    }
                    case 4: {
                        color2 = ColorPicker.truer(color2);
                        color2 = ColorPicker.truer(color2);
                        color2 = ColorPicker.truer(color2);
                        graphics.setColor(color2);
                        break;
                    }
                    case 5: {
                        color2 = ColorPicker.redder(color2);
                        color2 = ColorPicker.redder(color2);
                        color2 = ColorPicker.redder(color2);
                        graphics.setColor(color2);
                        break;
                    }
                    case 6: {
                        color2 = ColorPicker.bluer(color2);
                        color2 = ColorPicker.bluer(color2);
                        color2 = ColorPicker.bluer(color2);
                        graphics.setColor(color2);
                        break;
                    }
                    case 7: {
                        color2 = ColorPicker.greener(color2);
                        color2 = ColorPicker.greener(color2);
                        color2 = ColorPicker.greener(color2);
                        graphics.setColor(color2);
                        break;
                    }
                }
                ++n10;
            }
        }
    }

    public Point drawContent(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Point point = new Point(-999, -999);
        if (this.fTilGam.isTileThere(n, n2, n3) && (this.fTilGam.isTileVisible(n, n2, n3) || this.fTilGam.isSelected(n, n2, n3 + 1) || this.isPreSelected(n, n2, n3 + 1))) {
            int n7 = this.getTileX(n, n2, n3, n4, n5);
            int n8 = this.getTileY(n, n2, n3, n4, n5);
            Image image = this.getTileImage(n, n2, n3);
            this.drawContent(graphics, image, n7, n8, n4, n5, n6, this.fTilClr[this.fTilGam.getTileNumber(n, n2, n3)], this.fTilGam.isHighlighted(n, n2, n3));
            point.x = n7;
            point.y = n8;
        }
        return point;
    }

    public TileAnimator getTileAnimator() {
        return this.fTilAni;
    }

    public void listVersions() {
        System.out.println("Current class versions:");
        System.out.println();
        BufferedCanvas.version();
        ColorPicker.version();
        PaletteMgr.version();
        PatternCanvas.version();
        RandomList.version();
        TileAnimator.version();
        TileDeck.version();
        TileFrame.version();
        TileGame.version();
        TileImageEffector.version();
        TileImageMaker.version();
        TileLoader.version();
        TileLoadMgr.version();
        TileMatch.version();
        TileMatchBuffer.version();
        TileOhNoCanvas.version();
        TileSlideShow.version();
        TileSoundPlayer.version();
        TileSoundLoader.version();
        TileTextCanvas.version();
        CenterCanvas.version();
        System.out.println("---------------");
    }

    public static void version() {
        System.out.println("TileMatchBuffer 0.0k");
    }
}

