/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class TileOhNoCanvas
extends Canvas {
    static final int kTxtInc = 10;
    String[] fTxt;
    TileMatch fTilApp;
    int fLinCnt;
    int fTopLin;

    public TileOhNoCanvas(TileMatch tileMatch) {
        this.fTilApp = tileMatch;
        Dimension dimension = this.fTilApp.size();
        this.resize(dimension.width, dimension.height);
    }

    public void freeManagers() {
        this.fTilApp = null;
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        if (this.fTilApp.registryOkay()) {
            graphics.drawString("Click anywhere to return to the game.", 0, n);
        } else {
            graphics.drawString("This game is not properly registered.  Cannot play.", 0, n);
        }
        n += 2 * fontMetrics.getHeight();
        if (this.fTxt != null) {
            int n2 = this.fTopLin;
            while (n2 < this.fLinCnt) {
                graphics.drawString(this.fTxt[n2], 0, n);
                n += fontMetrics.getHeight();
                ++n2;
            }
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.fTilApp != null) {
            this.fTilApp.setOhNoBar();
        }
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        if (this.fTilApp != null) {
            this.fTilApp.setOhNoBar();
        }
    }

    public void resize(Dimension dimension) {
        super.resize(dimension);
        if (this.fTilApp != null) {
            this.fTilApp.setOhNoBar();
        }
    }

    public int getLines() {
        return this.fLinCnt;
    }

    public int getVisible() {
        Dimension dimension = this.size();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            return dimension.height / fontMetrics.getHeight() - 2;
        }
        return 1;
    }

    public void setTopLine(int n) {
        this.fTopLin = n;
    }

    public boolean keyDown(Event event, int n) {
        return this.fTilApp.keyDown(event, n);
    }

    public void addMessage(String string) {
        if (this.fTxt == null) {
            this.fTxt = new String[10];
        }
        this.fTxt[this.fLinCnt] = string;
        ++this.fLinCnt;
        if (this.fLinCnt >= this.fTxt.length) {
            String[] stringArray = new String[this.fTxt.length + 10];
            int n = 0;
            while (n < this.fTxt.length) {
                stringArray[n] = this.fTxt[n];
                ++n;
            }
            this.fTxt = stringArray;
        }
        this.fTilApp.setOhNoBar();
        this.repaint();
    }

    public static void version() {
        System.out.println("TileOhNoCanvas 0.0");
    }
}

