/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;

public class TileSoundPlayer
extends Thread {
    TileMatch fTilApp;
    String fSndNam;
    String fSndNamTwo;
    String[] fSndLst;
    int[] fSndCnt;
    boolean fLoop;
    int fPerTim;
    int fPerCnt;
    int fCurPer;
    AudioClip fAudClp;
    AudioClip fOthAudClp;

    public TileSoundPlayer(TileMatch tileMatch, String string, boolean bl) {
        super("sounds");
        this.fTilApp = tileMatch;
        this.fSndNam = String.valueOf(tileMatch.getSoundFolder()) + string;
        this.fLoop = bl;
        this.fPerTim = 0;
        this.start();
    }

    public TileSoundPlayer(TileMatch tileMatch, String string, String string2) {
        super("sounds");
        this.fTilApp = tileMatch;
        this.fSndNam = String.valueOf(tileMatch.getSoundFolder()) + string;
        this.fSndNamTwo = String.valueOf(tileMatch.getSoundFolder()) + string2;
        this.fLoop = true;
        this.fPerTim = 0;
        this.start();
    }

    public TileSoundPlayer(TileMatch tileMatch, String string, int n, int n2) {
        super("sounds");
        if (n == 0 || n2 == 0) {
            return;
        }
        this.fTilApp = tileMatch;
        this.fPerCnt = n;
        this.fSndLst = new String[this.fPerCnt];
        this.fSndCnt = new int[this.fPerCnt];
        if (this.fPerCnt == 1) {
            this.fSndLst[0] = String.valueOf(tileMatch.getSoundFolder()) + string + ".au";
        } else {
            int n3 = 0;
            while (n3 < this.fPerCnt) {
                this.fSndLst[n3] = String.valueOf(tileMatch.getSoundFolder()) + string + "." + Integer.toString(n3 + tileMatch.getPeriodicBase()) + ".au";
                ++n3;
            }
        }
        this.fSndNam = this.fSndLst[0];
        this.fLoop = false;
        this.fPerTim = n2 * 1000;
        this.start();
    }

    public void start(String string) {
        this.fSndNam = string;
        this.start();
    }

    public void destroy() {
        this.fTilApp = null;
        this.fAudClp = null;
        this.fOthAudClp = null;
    }

    public void loopStart() {
        if (this.fOthAudClp != null) {
            this.fOthAudClp.play();
        }
        this.fAudClp.loop();
    }

    public void loopResume() {
        this.fAudClp.loop();
    }

    public void loopStop() {
        this.fAudClp.stop();
    }

    public void run() {
        if (this.fPerTim > 0) {
            this.doPeriodic();
            return;
        }
        if (this.fLoop) {
            this.doLoop();
            return;
        }
        this.doSingle();
    }

    public void doSingle() {
        this.fAudClp = this.fTilApp.getTileCanvas().getAudioClip(this.fSndNam);
        if (this.fAudClp != null) {
            this.fAudClp.play();
        }
    }

    public void doLoop() {
        this.fAudClp = this.fTilApp.getTileCanvas().getAudioClip(this.fSndNam);
        if (this.fSndNamTwo != null) {
            this.fOthAudClp = this.fTilApp.getTileCanvas().getAudioClip(this.fSndNamTwo);
        }
        if (this.fOthAudClp != null) {
            this.fOthAudClp.play();
        }
        if (this.fAudClp != null) {
            this.fAudClp.loop();
        }
    }

    public void doPeriodic() {
        while (true) {
            try {
                Thread.sleep(this.fPerTim);
            }
            catch (InterruptedException interruptedException) {}
            if (this.fSndCnt[this.fCurPer] < 3) {
                this.fAudClp = this.fTilApp.getTileCanvas().getAudioClip(this.fSndLst[this.fCurPer]);
                int n = this.fCurPer;
                this.fSndCnt[n] = this.fSndCnt[n] + 1;
                if (this.fAudClp != null) {
                    this.fSndCnt[this.fCurPer] = 0;
                    this.fAudClp.play();
                }
            }
            this.fCurPer = (this.fCurPer + 1) % this.fPerCnt;
        }
    }

    public static void version() {
        System.out.println("TileSoundPlayer 0.0g");
    }
}

