/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class TileTextCanvas
extends Canvas {
    String fFilNam;
    String[] fTxt;
    TileMatch fTilApp;
    int fLinCnt;
    int fTopLin;

    public TileTextCanvas(TileMatch tileMatch, String string) {
        this.fTilApp = tileMatch;
        this.fFilNam = string;
        Dimension dimension = this.fTilApp.size();
        this.resize(dimension.width, dimension.height);
        this.loadText(string);
    }

    public void freeManagers() {
        this.fTilApp = null;
    }

    public void paint(Graphics graphics) {
        Font font = graphics.getFont();
        Font font2 = new Font(font.getName(), 0, font.getSize());
        Font font3 = new Font(font.getName(), 1, font.getSize());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        graphics.drawString("Click anywhere to return to the game.", 0, n);
        n += 2 * fontMetrics.getHeight();
        if (this.fTxt == null) {
            graphics.drawString("Please wait (loading Help text)...", 0, n);
            this.loadText(this.fFilNam);
        } else {
            int n2 = this.fTopLin;
            while (n2 < this.fLinCnt) {
                if (this.fTxt[n2].startsWith("*")) {
                    graphics.setFont(font3);
                } else {
                    graphics.setFont(font2);
                }
                graphics.drawString(this.fTxt[n2], 0, n);
                n += fontMetrics.getHeight();
                ++n2;
            }
        }
        graphics.setFont(font);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.fTilApp != null) {
            this.fTilApp.setHelpBar();
        }
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        if (this.fTilApp != null) {
            this.fTilApp.setHelpBar();
        }
    }

    public void resize(Dimension dimension) {
        super.resize(dimension);
        if (this.fTilApp != null) {
            this.fTilApp.setHelpBar();
        }
    }

    public int getLines() {
        return this.fLinCnt;
    }

    public int getVisible() {
        Dimension dimension = this.size();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            return dimension.height / fontMetrics.getHeight() - 2;
        }
        return 1;
    }

    public void loadText(String string) {
        Vector<String> vector = new Vector<String>();
        this.fLinCnt = 0;
        try {
            URL uRL = new URL(this.fTilApp.getDocumentBase(), string);
            try {
                String string2 = "";
                InputStream inputStream = uRL.openStream();
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                while (string2 != null) {
                    string2 = dataInputStream.readLine();
                    if (string2 == null) continue;
                    ++this.fLinCnt;
                    vector.addElement(string2);
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                this.fTilApp.ohNo("Reading help file\r" + iOException.toString());
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.fTilApp.ohNo("Reading help file\r" + malformedURLException.toString());
        }
        this.fTxt = new String[this.fLinCnt];
        vector.copyInto(this.fTxt);
    }

    public void setTopLine(int n) {
        this.fTopLin = n;
    }

    public boolean keyDown(Event event, int n) {
        return this.fTilApp.keyDown(event, n);
    }

    public static void version() {
        System.out.println("TileTextCanvas 0.0");
    }
}

